/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import hidden.org.codehaus.plexus.util.IOUtil;
import hidden.org.codehaus.plexus.util.StringUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.Authentication;
import org.apache.maven.artifact.ant.LocalRepository;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.ant.Proxy;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.maven.artifact.ant.RepositoryPolicy;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import org.apache.maven.usability.diagnostics.ErrorDiagnostics;
import org.apache.maven.wagon.Wagon;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.embed.Embedder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class AbstractArtifactTask
extends Task {
    private Settings settings;
    private PlexusContainer container;
    private Pom pom;
    private String pomRefId;
    private LocalRepository localRepository;
    static /* synthetic */ Class class$org$codehaus$plexus$PlexusContainer;

    protected ArtifactRepository createLocalArtifactRepository() {
        if (this.localRepository == null) {
            this.localRepository = this.getDefaultLocalRepository();
        }
        ArtifactRepositoryLayout repositoryLayout = (ArtifactRepositoryLayout)this.lookup(ArtifactRepositoryLayout.ROLE, this.localRepository.getLayout());
        return new DefaultArtifactRepository("local", "file://" + this.localRepository.getPath(), repositoryLayout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArtifactRepository createRemoteArtifactRepository(RemoteRepository repository) {
        ArtifactRepository artifactRepository;
        Proxy proxy;
        ArtifactRepositoryLayout repositoryLayout = (ArtifactRepositoryLayout)this.lookup(ArtifactRepositoryLayout.ROLE, repository.getLayout());
        WagonManager manager = (WagonManager)this.lookup(WagonManager.ROLE);
        Authentication authentication = repository.getAuthentication();
        if (authentication != null) {
            manager.addAuthenticationInfo(repository.getId(), authentication.getUserName(), authentication.getPassword(), authentication.getPrivateKey(), authentication.getPassphrase());
        }
        if ((proxy = repository.getProxy()) != null) {
            manager.addProxy(proxy.getType(), proxy.getHost(), proxy.getPort(), proxy.getUserName(), proxy.getPassword(), proxy.getNonProxyHosts());
        }
        ArtifactRepositoryFactory repositoryFactory = null;
        try {
            repositoryFactory = (ArtifactRepositoryFactory)this.lookup(ArtifactRepositoryFactory.ROLE);
            ArtifactRepositoryPolicy snapshots = AbstractArtifactTask.buildArtifactRepositoryPolicy(repository.getSnapshots());
            ArtifactRepositoryPolicy releases = AbstractArtifactTask.buildArtifactRepositoryPolicy(repository.getReleases());
            artifactRepository = repositoryFactory.createArtifactRepository(repository.getId(), repository.getUrl(), repositoryLayout, snapshots, releases);
        }
        finally {
            try {
                this.getContainer().release(repositoryFactory);
            }
            catch (ComponentLifecycleException e) {}
        }
        return artifactRepository;
    }

    private static ArtifactRepositoryPolicy buildArtifactRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String updatePolicy = null;
        String checksumPolicy = null;
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updatePolicy = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksumPolicy = policy.getChecksumPolicy();
            }
        }
        return new ArtifactRepositoryPolicy(enabled, updatePolicy, checksumPolicy);
    }

    protected LocalRepository getDefaultLocalRepository() {
        Settings settings = this.getSettings();
        LocalRepository localRepository = new LocalRepository();
        localRepository.setId("local");
        localRepository.setPath(new File(settings.getLocalRepository()));
        return localRepository;
    }

    protected synchronized Settings getSettings() {
        if (this.settings == null) {
            File settingsFile = new File(System.getProperty("user.home"), ".ant/settings.xml");
            if (!settingsFile.exists()) {
                settingsFile = new File(System.getProperty("user.home"), ".m2/settings.xml");
            }
            if (!settingsFile.exists()) {
                settingsFile = new File(System.getProperty("ant.home"), "etc/settings.xml");
            }
            if (!settingsFile.exists()) {
                Vector env = Execute.getProcEnvironment();
                Iterator iter = env.iterator();
                while (iter.hasNext()) {
                    String var = (String)iter.next();
                    if (!var.startsWith("M2_HOME=")) continue;
                    String m2_home = var.substring("M2_HOME=".length());
                    settingsFile = new File(m2_home, "conf/settings.xml");
                    break;
                }
            }
            if (settingsFile.exists()) {
                this.loadSettings(settingsFile);
            } else {
                this.settings = new Settings();
                this.checkSettingsLocalRepository();
            }
        }
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadSettings(File settingsFile) {
        FileReader reader = null;
        try {
            this.log("Loading Maven settings file: " + settingsFile.getPath(), 3);
            reader = new FileReader(settingsFile);
            SettingsXpp3Reader modelReader = new SettingsXpp3Reader();
            this.settings = modelReader.read(reader);
            this.checkSettingsLocalRepository();
        }
        catch (IOException e) {
            this.log("Error reading settings file '" + settingsFile + "' - ignoring. Error was: " + e.getMessage(), 1);
            IOUtil.close(reader);
        }
        catch (XmlPullParserException e2) {
            this.log("Error parsing settings file '" + settingsFile + "' - ignoring. Error was: " + e2.getMessage(), 1);
            {
                catch (Throwable throwable) {
                    IOUtil.close(reader);
                    throw throwable;
                }
            }
            IOUtil.close(reader);
        }
        IOUtil.close(reader);
    }

    private void checkSettingsLocalRepository() {
        if (StringUtils.isEmpty(this.settings.getLocalRepository())) {
            String location = new File(System.getProperty("user.home"), ".m2/repository").getAbsolutePath();
            this.settings.setLocalRepository(location);
        }
    }

    public void setSettingsFile(File settingsFile) {
        if (!settingsFile.exists()) {
            throw new BuildException("settingsFile does not exist: " + settingsFile.getAbsolutePath());
        }
        this.loadSettings(settingsFile);
    }

    protected RemoteRepository createAntRemoteRepository(Repository pomRepository) {
        RemoteRepository r = this.createAntRemoteRepositoryBase(pomRepository);
        if (pomRepository.getSnapshots() != null) {
            r.addSnapshots(AbstractArtifactTask.convertRepositoryPolicy(pomRepository.getSnapshots()));
        }
        if (pomRepository.getReleases() != null) {
            r.addReleases(AbstractArtifactTask.convertRepositoryPolicy(pomRepository.getReleases()));
        }
        return r;
    }

    protected RemoteRepository createAntRemoteRepositoryBase(RepositoryBase pomRepository) {
        Mirror mirror;
        org.apache.maven.settings.Proxy proxy;
        RemoteRepository r = new RemoteRepository();
        r.setId(pomRepository.getId());
        r.setUrl(pomRepository.getUrl());
        r.setLayout(pomRepository.getLayout());
        Server server = this.getSettings().getServer(pomRepository.getId());
        if (server != null) {
            r.addAuthentication(new Authentication(server));
        }
        if ((proxy = this.getSettings().getActiveProxy()) != null) {
            r.addProxy(new Proxy(proxy));
        }
        if ((mirror = this.getSettings().getMirrorOf(pomRepository.getId())) != null) {
            r.setUrl(mirror.getUrl());
        }
        return r;
    }

    protected Object lookup(String role) {
        try {
            return this.getContainer().lookup(role);
        }
        catch (ComponentLookupException e) {
            throw new BuildException("Unable to find component: " + role, (Throwable)e);
        }
    }

    protected Object lookup(String role, String roleHint) {
        try {
            return this.getContainer().lookup(role, roleHint);
        }
        catch (ComponentLookupException e) {
            throw new BuildException("Unable to find component: " + role + "[" + roleHint + "]", (Throwable)e);
        }
    }

    protected synchronized PlexusContainer getContainer() {
        if (this.container == null) {
            this.container = (PlexusContainer)this.getProject().getReference((class$org$codehaus$plexus$PlexusContainer == null ? (class$org$codehaus$plexus$PlexusContainer = AbstractArtifactTask.class$("org.codehaus.plexus.PlexusContainer")) : class$org$codehaus$plexus$PlexusContainer).getName());
            if (this.container == null) {
                try {
                    ClassWorld classWorld = new ClassWorld();
                    classWorld.newRealm("plexus.core", ((Object)((Object)this)).getClass().getClassLoader());
                    Embedder embedder = new Embedder();
                    embedder.start(classWorld);
                    this.container = embedder.getContainer();
                }
                catch (PlexusContainerException e) {
                    throw new BuildException("Unable to start embedder", (Throwable)e);
                }
                catch (DuplicateRealmException e) {
                    throw new BuildException("Unable to create embedder ClassRealm", (Throwable)e);
                }
                this.getProject().addReference((class$org$codehaus$plexus$PlexusContainer == null ? (class$org$codehaus$plexus$PlexusContainer = AbstractArtifactTask.class$("org.codehaus.plexus.PlexusContainer")) : class$org$codehaus$plexus$PlexusContainer).getName(), (Object)this.container);
            }
        }
        return this.container;
    }

    public Pom buildPom(MavenProjectBuilder projectBuilder, ArtifactRepository localArtifactRepository) {
        if (this.pomRefId != null && this.pom != null) {
            throw new BuildException("You cannot specify both a POM element and a pomrefid element");
        }
        Pom pom = this.pom;
        if (this.pomRefId != null && (pom = (Pom)((Object)this.getProject().getReference(this.pomRefId))) == null) {
            throw new BuildException("Reference '" + this.pomRefId + "' was not found.");
        }
        if (pom != null) {
            pom.initialise(projectBuilder, localArtifactRepository);
        }
        return pom;
    }

    protected Pom createDummyPom() {
        Model mavenModel = new Model();
        mavenModel.setGroupId("unspecified");
        mavenModel.setArtifactId("unspecified");
        mavenModel.setVersion("0.0");
        mavenModel.setPackaging("jar");
        MavenProject mavenProject = new MavenProject(mavenModel);
        Pom pom = new Pom();
        pom.setMavenProject(mavenProject);
        return pom;
    }

    public String[] getSupportedProtocols() {
        try {
            Map wagonMap = this.getContainer().lookupMap(Wagon.ROLE);
            ArrayList protocols = new ArrayList();
            Iterator iter = wagonMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                protocols.add(entry.getKey());
            }
            return protocols.toArray(new String[protocols.size()]);
        }
        catch (ComponentLookupException e) {
            throw new BuildException("Unable to lookup Wagon providers", (Throwable)e);
        }
    }

    public String getSupportedProtocolsAsString() {
        return StringUtils.join(this.getSupportedProtocols(), ", ");
    }

    public void diagnoseError(Throwable error) {
        try {
            ErrorDiagnostics diagnostics = (ErrorDiagnostics)this.container.lookup(ErrorDiagnostics.ROLE);
            StringBuffer message = new StringBuffer();
            message.append("An error has occurred while processing the Maven artifact tasks.\n");
            message.append(" Diagnosis:\n\n");
            message.append(diagnostics.diagnose(error));
            message.append("\n\n");
            this.log(message.toString(), 2);
        }
        catch (ComponentLookupException e) {
            this.log("Failed to retrieve error diagnoser.", 4);
        }
    }

    public void addPom(Pom pom) {
        this.pom = pom;
    }

    public String getPomRefId() {
        return this.pomRefId;
    }

    public void setPomRefId(String pomRefId) {
        this.pomRefId = pomRefId;
    }

    public LocalRepository getLocalRepository() {
        return this.localRepository;
    }

    public void addLocalRepository(LocalRepository localRepository) {
        this.localRepository = localRepository;
    }

    public void setProfiles(String profiles) {
        if (profiles != null) {
            this.log("Profiles not yet supported, ignoring profiles '" + profiles + "'", 1);
        }
    }

    protected Artifact createArtifact(Pom pom) {
        ArtifactFactory factory = (ArtifactFactory)this.lookup(ArtifactFactory.ROLE);
        return factory.createBuildArtifact(pom.getGroupId(), pom.getArtifactId(), pom.getVersion(), pom.getPackaging());
    }

    private static RepositoryPolicy convertRepositoryPolicy(org.apache.maven.model.RepositoryPolicy pomRepoPolicy) {
        RepositoryPolicy policy = new RepositoryPolicy();
        policy.setEnabled(pomRepoPolicy.isEnabled());
        policy.setUpdatePolicy(pomRepoPolicy.getUpdatePolicy());
        return policy;
    }

    public void execute() {
        try {
            this.doExecute();
        }
        catch (BuildException e) {
            this.diagnoseError(e);
            throw e;
        }
    }

    protected abstract void doExecute();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

