/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PropertyExpander {
    private static final Pattern EXPANSION_PATTERN = Pattern.compile("(\\$\\{([^}]+?)\\})", 8);

    private PropertyExpander() {
    }

    public static String expandProperties(String input, Map props) {
        if (input == null) {
            return null;
        }
        Matcher matcher = EXPANSION_PATTERN.matcher(input);
        StringBuffer expanded = new StringBuffer(input.length());
        while (matcher.find()) {
            String propName = matcher.group(2);
            String value = (String)props.get(propName);
            if (value == null) {
                value = matcher.group(0);
            }
            matcher.appendReplacement(expanded, "");
            expanded.append(value);
        }
        matcher.appendTail(expanded);
        return expanded.toString();
    }

    public static String expandSystemProperties(String input) {
        return PropertyExpander.expandProperties(input, System.getProperties());
    }
}

