/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;

public final class RegexUtil {
    public static final Pattern mailtoPattern = Pattern.compile("mailto:([a-zA-Z0-9\\.]+@[a-zA-Z0-9\\.]+\\.[a-zA-Z0-9]+)");
    public static final Pattern emailPattern = Pattern.compile("\\b[a-zA-Z0-9\\.]+(@)([a-zA-Z0-9\\.]+)(\\.)([a-zA-Z0-9]+)\\b");

    public static String encodeEmail(String str) {
        Matcher mailtoMatch = mailtoPattern.matcher(str);
        while (mailtoMatch.find()) {
            String email = mailtoMatch.group(1);
            String hexed = RegexUtil.encode(email);
            str = str.replaceFirst("mailto:" + email, "mailto:" + hexed);
        }
        return RegexUtil.obfuscateEmail(str);
    }

    public static String obfuscateEmail(String str) {
        Matcher emailMatch = emailPattern.matcher(str);
        while (emailMatch.find()) {
            String at = emailMatch.group(1);
            str = str.replaceFirst(at, "-AT-");
            String dot = emailMatch.group(2) + emailMatch.group(3) + emailMatch.group(4);
            String newDot = emailMatch.group(2) + "-DOT-" + emailMatch.group(4);
            str = str.replaceFirst(dot, newDot);
        }
        return str;
    }

    public static ArrayList getMatches(Pattern pattern, String match, int group) {
        ArrayList<String> matches = new ArrayList<String>();
        Matcher matcher = pattern.matcher(match);
        while (matcher.find()) {
            matches.add(matcher.group(group));
        }
        return matches;
    }

    public static String encode(String email) {
        StringBuffer result = new StringBuffer();
        try {
            char[] hexString = Hex.encodeHex((byte[])email.getBytes("UTF-8"));
            for (int i = 0; i < hexString.length; ++i) {
                if (i % 2 == 0) {
                    result.append("%");
                }
                result.append(hexString[i]);
            }
        }
        catch (UnsupportedEncodingException e) {
            return email;
        }
        return result.toString();
    }
}

