/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.CallableStatement;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.DatabaseMetaData;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.EncryptionManager;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.Savepoint;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SectionManager;
import org.apache.derby.client.am.SqlCode;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlState;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.am.UnitOfWorkListener;
import org.apache.derby.client.am.Utils;
import org.apache.derby.jdbc.ClientDataSource;

public abstract class Connection
implements java.sql.Connection,
ConnectionCallbackInterface {
    public Agent agent_;
    public DatabaseMetaData databaseMetaData_;
    final LinkedList openStatements_ = new LinkedList();
    final LinkedList RollbackOnlyListeners_ = new LinkedList();
    final LinkedList CommitAndRollbackListeners_ = new LinkedList();
    private SqlWarning warnings_ = null;
    public transient String user_;
    public boolean retrieveMessageText_;
    protected boolean jdbcReadOnly_;
    public int resultSetHoldability_;
    public String databaseName_;
    public String productID_;
    protected EncryptionManager encryptionManager_;
    private Statement setTransactionIsolationStmt = null;
    protected boolean open_ = true;
    protected boolean availableForReuse_ = false;
    public int isolation_ = 2;
    public boolean autoCommit_ = true;
    protected boolean inUnitOfWork_ = false;
    private boolean accumulated440ForMessageProcFailure_ = false;
    private boolean accumulated444ForMessageProcFailure_ = false;
    private boolean accumulatedSetReadOnlyWarning_ = false;
    protected boolean isXAConnection_ = false;
    public static final int XA_T0_NOT_ASSOCIATED = 0;
    public static final int XA_T1_ASSOCIATED = 1;
    protected int xaState_ = 0;
    public int xaHostVersion_ = 0;
    public int loginTimeout_;
    public ClientDataSource dataSource_;
    public String serverNameIP_;
    public int portNumber_;
    public Hashtable clientCursorNameCache_ = new Hashtable();
    public boolean canUseCachedConnectBytes_ = false;
    public int commBufferSize_ = Short.MAX_VALUE;
    public boolean resetConnectionAtFirstSql_ = false;
    private static String DERBY_TRANSACTION_REPEATABLE_READ = "RS";
    private static String DERBY_TRANSACTION_SERIALIZABLE = "RR";
    private static String DERBY_TRANSACTION_READ_COMMITTED = "CS";
    private static String DERBY_TRANSACTION_READ_UNCOMMITTED = "UR";
    public int dncGeneratedSavepointId_;
    public static final String dncGeneratedSavepointNamePrefix__ = "DNC_GENENERATED_NAME_";

    protected Connection(LogWriter logWriter, String string, String string2, ClientDataSource clientDataSource) throws SqlException {
        this.initConnection(logWriter, string, clientDataSource);
    }

    protected Connection(LogWriter logWriter, String string, String string2, boolean bl, ClientDataSource clientDataSource) throws SqlException {
        this.isXAConnection_ = bl;
        this.initConnection(logWriter, string, clientDataSource);
    }

    protected void initConnection(LogWriter logWriter, String string, ClientDataSource clientDataSource) throws SqlException {
        if (logWriter != null) {
            logWriter.traceConnectEntry(clientDataSource);
        }
        Configuration.checkForExceptionsFromLoadConfiguration(logWriter);
        this.user_ = string;
        this.databaseName_ = clientDataSource.getDatabaseName() + clientDataSource.getConnectionAttributes();
        this.retrieveMessageText_ = clientDataSource.getRetrieveMessageText();
        this.loginTimeout_ = clientDataSource.getLoginTimeout();
        this.dataSource_ = clientDataSource;
        this.serverNameIP_ = clientDataSource.getServerName();
        this.portNumber_ = clientDataSource.getPortNumber();
        this.agent_ = this.newAgent_(logWriter, this.loginTimeout_, this.serverNameIP_, this.portNumber_);
    }

    protected Connection(LogWriter logWriter, boolean bl, ClientDataSource clientDataSource) throws SqlException {
        if (logWriter != null) {
            logWriter.traceConnectEntry(clientDataSource);
        }
        this.isXAConnection_ = bl;
        Configuration.checkForExceptionsFromLoadConfiguration(logWriter);
        this.user_ = "APP";
        this.databaseName_ = clientDataSource.getDatabaseName();
        this.retrieveMessageText_ = clientDataSource.getRetrieveMessageText();
        this.loginTimeout_ = clientDataSource.getLoginTimeout();
        this.dataSource_ = clientDataSource;
        this.serverNameIP_ = clientDataSource.getServerName();
        this.portNumber_ = clientDataSource.getPortNumber();
        this.agent_ = this.newAgent_(logWriter, this.loginTimeout_, this.serverNameIP_, this.portNumber_);
    }

    protected void resetConnection(LogWriter logWriter, String string, ClientDataSource clientDataSource, boolean bl) throws SqlException {
        this.clearWarningsX();
        String string2 = this.user_ = string != null ? string : this.user_;
        if (clientDataSource != null && bl) {
            this.user_ = string != null ? string : clientDataSource.getUser();
            this.retrieveMessageText_ = clientDataSource.getRetrieveMessageText();
            this.encryptionManager_ = null;
            this.isolation_ = 2;
            this.autoCommit_ = true;
            this.inUnitOfWork_ = false;
            this.loginTimeout_ = clientDataSource.getLoginTimeout();
            this.dataSource_ = clientDataSource;
        }
        if (bl) {
            this.agent_.resetAgent(this, logWriter, this.loginTimeout_, this.serverNameIP_, this.portNumber_);
        }
    }

    protected void resetConnection(LogWriter logWriter, String string, Properties properties) throws SqlException {
        this.clearWarningsX();
        this.databaseName_ = string;
        this.user_ = ClientDataSource.getUser(properties);
        this.retrieveMessageText_ = ClientDataSource.getRetrieveMessageText(properties);
        this.encryptionManager_ = null;
        this.isolation_ = 2;
        this.autoCommit_ = true;
        this.inUnitOfWork_ = false;
        this.agent_.resetAgent(this, logWriter, this.loginTimeout_, this.serverNameIP_, this.portNumber_);
    }

    protected Connection(LogWriter logWriter, int n, String string, int n2, String string2, Properties properties) throws SqlException {
        if (logWriter != null) {
            logWriter.traceConnectEntry(string, n2, string2, properties);
        }
        Configuration.checkForExceptionsFromLoadConfiguration(logWriter);
        this.databaseName_ = string2;
        this.user_ = ClientDataSource.getUser(properties);
        this.retrieveMessageText_ = ClientDataSource.getRetrieveMessageText(properties);
        this.loginTimeout_ = n;
        this.serverNameIP_ = string;
        this.portNumber_ = n2;
        this.agent_ = this.newAgent_(logWriter, this.loginTimeout_, this.serverNameIP_, this.portNumber_);
    }

    protected void finalize() throws Throwable {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "finalize");
        }
        if (!this.open_) {
            return;
        }
        this.agent_.disconnectEvent();
        super.finalize();
    }

    public synchronized java.sql.Statement createStatement() throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "createStatement");
        }
        Statement statement = this.createStatementX(1003, 1007, this.resultSetHoldability_);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "createStatement", statement);
        }
        return statement;
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "prepareStatement", string);
        }
        PreparedStatement preparedStatement = this.prepareStatementX(string, 1003, 1007, this.resultSetHoldability_, 2, null);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", preparedStatement);
        }
        return preparedStatement;
    }

    public synchronized PreparedStatement preparePositionedUpdateStatement(String string, Section section) throws SqlException {
        this.checkForClosedConnection();
        PreparedStatement preparedStatement = this.newPositionedUpdatePreparedStatement_(string, section);
        preparedStatement.flowPrepareDescribeInputOutput();
        return preparedStatement;
    }

    public synchronized java.sql.CallableStatement prepareCall(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "prepareCall", string);
        }
        CallableStatement callableStatement = this.prepareCallX(string, 1003, 1007, this.resultSetHoldability_);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "prepareCall", callableStatement);
        }
        return callableStatement;
    }

    synchronized PreparedStatement prepareDynamicCatalogQuery(String string) throws SqlException {
        PreparedStatement preparedStatement = this.newPreparedStatement_(string, 1003, 1007, this.resultSetHoldability_, 2, null);
        preparedStatement.isCatalogQuery_ = true;
        preparedStatement.prepare();
        this.openStatements_.add(preparedStatement);
        return preparedStatement;
    }

    public String nativeSQL(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "nativeSQL", string);
        }
        String string2 = this.nativeSQLX(string);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "nativeSQL", string2);
        }
        return string2;
    }

    public synchronized String nativeSQLX(String string) throws SqlException {
        this.checkForClosedConnection();
        if (string == null) {
            throw new SqlException(this.agent_.logWriter_, "Null SQL string passed.");
        }
        String string2 = string.trim();
        if (string2.startsWith("{") && string2.lastIndexOf("}") >= 0) {
            return string2.substring(1, string2.lastIndexOf("}"));
        }
        return string2;
    }

    protected abstract boolean allowLocalCommitRollback_() throws SqlException;

    public synchronized void setAutoCommit(boolean bl) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setAutoCommit", bl);
        }
        this.checkForClosedConnection();
        if (!this.allowLocalCommitRollback_()) {
            if (bl) {
                throw new SqlException(this.agent_.logWriter_, "setAutoCommit(true) invalid during global transaction", SqlState._2D521, SqlCode.invalidSetAutoCommitUnderXA);
            }
        } else {
            if (bl == this.autoCommit_) {
                return;
            }
            if (this.inUnitOfWork_) {
                this.flowCommit();
            }
        }
        this.autoCommit_ = bl;
    }

    public boolean getAutoCommit() throws SqlException {
        this.checkForClosedConnection();
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getAutoCommit", this.autoCommit_);
        }
        if (!this.allowLocalCommitRollback_()) {
            return false;
        }
        return this.autoCommit_;
    }

    public synchronized void commit() throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "commit");
        }
        this.checkForInvalidXAStateOnCommitOrRollback();
        this.checkForClosedConnection();
        this.flowCommit();
    }

    private void checkForInvalidXAStateOnCommitOrRollback() throws SqlException {
        if (!this.allowLocalCommitRollback_()) {
            throw new SqlException(this.agent_.logWriter_, "COMMIT or ROLLBACK invalid for application execution environment", SqlState._2D521, SqlCode.invalidCommitOrRollbackUnderXA);
        }
    }

    public void flowCommit() throws SqlException {
        if (this.isXAConnection_) {
            this.agent_.beginWriteChainOutsideUOW();
            this.writeCommit();
            this.agent_.flowOutsideUOW();
            this.readCommit();
            this.agent_.endReadChain();
        } else {
            this.agent_.beginWriteChain(null);
            this.writeCommit();
            this.agent_.flow(null);
            this.readCommit();
            this.agent_.endReadChain();
        }
    }

    public void flowAutoCommit() throws SqlException {
        if (this.willAutoCommitGenerateFlow()) {
            this.flowCommit();
        }
    }

    public boolean willAutoCommitGenerateFlow() throws SqlException {
        if (!this.autoCommit_) {
            return false;
        }
        return this.allowLocalCommitRollback_();
    }

    void writeAutoCommit() throws SqlException {
        if (this.willAutoCommitGenerateFlow()) {
            this.writeCommit();
        }
    }

    public void writeCommit() throws SqlException {
        if (this.isXAConnection_) {
            if (this.xaState_ == 0) {
                this.writeLocalXACommit_();
            }
        } else {
            this.writeLocalCommit_();
        }
    }

    void readAutoCommit() throws SqlException {
        if (this.willAutoCommitGenerateFlow()) {
            this.readCommit();
        }
    }

    public void readCommit() throws SqlException {
        if (this.isXAConnection_) {
            if (this.xaState_ == 0) {
                this.readLocalXACommit_();
            }
        } else {
            this.readLocalCommit_();
        }
    }

    public synchronized void rollback() throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "rollback");
        }
        this.checkForInvalidXAStateOnCommitOrRollback();
        this.checkForClosedConnection();
        this.flowRollback();
    }

    protected void flowRollback() throws SqlException {
        if (this.isXAConnection_) {
            this.agent_.beginWriteChainOutsideUOW();
            this.writeRollback();
            this.agent_.flowOutsideUOW();
            this.readRollback();
            this.agent_.endReadChain();
        } else {
            this.agent_.beginWriteChain(null);
            this.writeRollback();
            this.agent_.flow(null);
            this.readRollback();
            this.agent_.endReadChain();
        }
    }

    public void writeRollback() throws SqlException {
        if (this.isXAConnection_) {
            this.writeLocalXARollback_();
        } else {
            this.writeLocalRollback_();
        }
    }

    public void readRollback() throws SqlException {
        if (this.isXAConnection_) {
            this.readLocalXARollback_();
        } else {
            this.readLocalRollback_();
        }
    }

    public synchronized void close() throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "close");
        }
        this.closeX();
    }

    void checkForTransactionInProgress() throws SqlException {
        if (!this.autoCommit_ && this.inUnitOfWork_ && !this.allowCloseInUOW_()) {
            throw new SqlException(this.agent_.logWriter_, "java.sql.Connection.close() requested while a transaction is in progress on the connection.The transaction remains active, and the connection cannot be closed.");
        }
    }

    public synchronized void closeX() throws SqlException {
        if (!this.open_) {
            return;
        }
        this.closeResourcesX();
    }

    public synchronized void closeResources() throws SqlException {
        if (this.open_ || !this.open_ && this.availableForReuse_) {
            this.availableForReuse_ = false;
            this.closeResourcesX();
        }
    }

    private void closeResourcesX() throws SqlException {
        this.checkForTransactionInProgress();
        this.resetConnectionAtFirstSql_ = false;
        SqlException sqlException = null;
        if (this.setTransactionIsolationStmt != null) {
            try {
                this.setTransactionIsolationStmt.close();
            }
            catch (SqlException sqlException2) {
                sqlException = sqlException2;
            }
        }
        try {
            this.flowClose();
        }
        catch (SqlException sqlException3) {
            sqlException = Utils.accumulateSQLException(sqlException3, sqlException);
        }
        this.markClosed();
        try {
            this.agent_.close();
        }
        catch (SqlException sqlException4) {
            throw Utils.accumulateSQLException(sqlException4, sqlException);
        }
    }

    protected abstract boolean isGlobalPending_();

    public synchronized void closeForReuse() throws SqlException {
        if (!this.open_) {
            return;
        }
        this.resetConnectionAtFirstSql_ = false;
        SqlException sqlException = null;
        try {
            this.flowClose();
        }
        catch (SqlException sqlException2) {
            sqlException = sqlException2;
        }
        if (this.open_) {
            this.markClosedForReuse();
        }
        if (sqlException != null) {
            throw sqlException;
        }
    }

    private void flowClose() throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        if (this.doCloseStatementsOnClose_()) {
            this.writeCloseStatements();
        }
        if (this.autoCommit_) {
            this.writeAutoCommit();
        }
        this.agent_.flowOutsideUOW();
        if (this.doCloseStatementsOnClose_()) {
            this.readCloseStatements();
        }
        if (this.autoCommit_) {
            this.readAutoCommit();
        }
        this.agent_.endReadChain();
    }

    protected abstract void markClosed_();

    public void markClosed() {
        this.open_ = false;
        this.inUnitOfWork_ = false;
        this.markStatementsClosed();
        this.CommitAndRollbackListeners_.clear();
        this.RollbackOnlyListeners_.clear();
        this.markClosed_();
    }

    private void markClosedForReuse() {
        this.availableForReuse_ = true;
        this.markClosed();
    }

    private void markStatementsClosed() {
        ListIterator listIterator = this.openStatements_.listIterator();
        while (listIterator.hasNext()) {
            Statement statement = (Statement)listIterator.next();
            statement.markClosed();
            listIterator.remove();
        }
    }

    private void writeCloseStatements() throws SqlException {
        ListIterator listIterator = this.openStatements_.listIterator();
        while (listIterator.hasNext()) {
            ((Statement)listIterator.next()).writeClose(false);
        }
    }

    private void readCloseStatements() throws SqlException {
        ListIterator listIterator = this.openStatements_.listIterator();
        while (listIterator.hasNext()) {
            ((Statement)listIterator.next()).readClose(false);
        }
    }

    public boolean isPhysicalConnClosed() {
        return !this.open_ && !this.availableForReuse_;
    }

    public boolean isClosed() {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "isClosed", !this.open_);
        }
        return !this.open_;
    }

    public boolean isClosedX() {
        return !this.open_;
    }

    public synchronized void setTransactionIsolation(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setTransactionIsolation", n);
        }
        this.checkForClosedConnection();
        String string = null;
        switch (n) {
            case 4: {
                string = DERBY_TRANSACTION_REPEATABLE_READ;
                break;
            }
            case 2: {
                string = DERBY_TRANSACTION_READ_COMMITTED;
                break;
            }
            case 8: {
                string = DERBY_TRANSACTION_SERIALIZABLE;
                break;
            }
            case 1: {
                string = DERBY_TRANSACTION_READ_UNCOMMITTED;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, "Transaction isolation level " + n + " is an invalid argument for java.sql.Connection.setTransactionIsolation()." + " See Javadoc specification for a list of valid arguments.", "XJ045");
            }
        }
        if (this.setTransactionIsolationStmt == null) {
            this.setTransactionIsolationStmt = this.createStatementX(1003, 1007, this.resultSetHoldability_);
        }
        this.setTransactionIsolationStmt.executeUpdate("SET CURRENT ISOLATION = " + string);
        this.isolation_ = n;
    }

    public int getTransactionIsolation() throws SqlException {
        this.checkForClosedConnection();
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getTransactionIsolation", this.isolation_);
        }
        return this.isolation_;
    }

    public SQLWarning getWarnings() {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getWarnings", this.warnings_);
        }
        return this.warnings_;
    }

    public synchronized void clearWarnings() throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "clearWarnings");
        }
        this.clearWarningsX();
    }

    public void clearWarningsX() throws SqlException {
        this.warnings_ = null;
        this.accumulated440ForMessageProcFailure_ = false;
        this.accumulated444ForMessageProcFailure_ = false;
        this.accumulatedSetReadOnlyWarning_ = false;
    }

    public java.sql.DatabaseMetaData getMetaData() throws SqlException {
        this.checkForClosedConnection();
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getMetaData", this.databaseMetaData_);
        }
        return this.databaseMetaData_;
    }

    public synchronized void setReadOnly(boolean bl) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setReadOnly", bl);
        }
        this.checkForClosedConnection();
    }

    public boolean isReadOnly() throws SqlException {
        this.checkForClosedConnection();
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "isReadOnly", this.jdbcReadOnly_);
        }
        return false;
    }

    public synchronized void setCatalog(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setCatalog", string);
        }
        this.checkForClosedConnection();
    }

    public String getCatalog() throws SqlException {
        this.checkForClosedConnection();
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getCatalog", (Object)null);
        }
        return null;
    }

    public synchronized java.sql.Statement createStatement(int n, int n2) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "createStatement", n, n2);
        }
        Statement statement = this.createStatementX(n, n2, this.resultSetHoldability_);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "createStatement", statement);
        }
        return statement;
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String string, int n, int n2) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "prepareStatement", (Object)string, n, n2);
        }
        PreparedStatement preparedStatement = this.prepareStatementX(string, n, n2, this.resultSetHoldability_, 2, null);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", preparedStatement);
        }
        return preparedStatement;
    }

    public synchronized java.sql.CallableStatement prepareCall(String string, int n, int n2) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "prepareCall", (Object)string, n, n2);
        }
        CallableStatement callableStatement = this.prepareCallX(string, n, n2, this.resultSetHoldability_);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "prepareCall", callableStatement);
        }
        return callableStatement;
    }

    public synchronized CallableStatement prepareMessageProc(String string) throws SqlException {
        this.checkForClosedConnection();
        CallableStatement callableStatement = this.prepareCallX(string, 1003, 1007, this.resultSetHoldability_);
        return callableStatement;
    }

    private int downgradeResultSetType(int n) {
        if (n == 1005) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, "Scroll sensitive result sets are not supported by server; remapping to forward-only cursor"));
            return 1004;
        }
        return n;
    }

    private int downgradeResultSetConcurrency(int n, int n2) {
        if (n == 1008 && n2 == 1004) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, "Insensitive updatable result sets are not supported by server; remapping to insensitive read-only cursor"));
            return 1007;
        }
        return n;
    }

    public Map getTypeMap() throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getTypeMap");
        }
        this.checkForClosedConnection();
        HashMap hashMap = new HashMap();
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getTypeMap", hashMap);
        }
        return hashMap;
    }

    public synchronized void setTypeMap(Map map) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setTypeMap", map);
        }
        this.checkForClosedConnection();
        throw new SqlException(this.agent_.logWriter_, "Connection.setTypeMap is not supported");
    }

    public synchronized void setHoldability(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setHoldability", n);
        }
        this.checkForClosedConnection();
        this.resultSetHoldability_ = n;
    }

    public int getHoldability() throws SqlException {
        this.checkForClosedConnection();
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getHoldability", this.resultSetHoldability_);
        }
        return this.resultSetHoldability_;
    }

    public synchronized java.sql.Savepoint setSavepoint() throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setSavepoint");
        }
        this.checkForClosedConnection();
        if (this.autoCommit_) {
            throw new SqlException(this.agent_.logWriter_, "Cannot set savepoint when in auto-commit mode.");
        }
        if (++this.dncGeneratedSavepointId_ < 0) {
            this.dncGeneratedSavepointId_ = 1;
        }
        Savepoint savepoint = this.setSavepointX(new Savepoint(this.agent_, this.dncGeneratedSavepointId_));
        return savepoint;
    }

    public synchronized java.sql.Savepoint setSavepoint(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setSavepoint", string);
        }
        this.checkForClosedConnection();
        if (string == null) {
            throw new SqlException(this.agent_.logWriter_, "Named savepoint needs a none-null name.");
        }
        if (this.autoCommit_) {
            throw new SqlException(this.agent_.logWriter_, "Cannot set savepoint when in auto-commit mode.");
        }
        Savepoint savepoint = this.setSavepointX(new Savepoint(this.agent_, string));
        return savepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Savepoint setSavepointX(Savepoint savepoint) throws SqlException {
        Statement statement = null;
        try {
            String string;
            statement = this.createStatementX(1003, 1007, this.resultSetHoldability_);
            try {
                string = savepoint.getSavepointName();
            }
            catch (SqlException sqlException) {
                string = dncGeneratedSavepointNamePrefix__ + savepoint.getSavepointId();
            }
            String string2 = "SAVEPOINT \"" + string + "\" ON ROLLBACK RETAIN CURSORS";
            statement.executeX(string2);
            Object var6_6 = null;
            if (statement == null) return savepoint;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (statement == null) throw throwable;
            try {
                statement.closeX();
                throw throwable;
            }
            catch (SqlException sqlException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            statement.closeX();
            return savepoint;
        }
        catch (SqlException sqlException) {}
        return savepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback(java.sql.Savepoint savepoint) throws SqlException {
        int n;
        block14: {
            n = this.xaState_;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "rollback", savepoint);
            }
            this.checkForClosedConnection();
            if (savepoint == null) {
                throw new SqlException(this.agent_.logWriter_, "Cannot rollback to a null savepoint.");
            }
            if (this.autoCommit_) {
                throw new SqlException(this.agent_.logWriter_, "Cannot rollback to a savepoint when in auto-commit mode.");
            }
            try {
                if (this != ((Savepoint)savepoint).agent_.connection_) {
                    throw new SqlException(this.agent_.logWriter_, "Rollback to a savepoint not created by this connection.");
                }
            }
            catch (ClassCastException classCastException) {
                throw new SqlException(this.agent_.logWriter_, "Rollback to a savepoint not created by this connection.");
            }
            Statement statement = null;
            try {
                String string;
                statement = this.createStatementX(1003, 1007, this.resultSetHoldability_);
                try {
                    string = ((Savepoint)savepoint).getSavepointName();
                }
                catch (SqlException sqlException) {
                    string = dncGeneratedSavepointNamePrefix__ + ((Savepoint)savepoint).getSavepointId();
                }
                String string2 = "ROLLBACK TO SAVEPOINT \"" + string + "\"";
                statement.executeX(string2);
                Object var7_8 = null;
                if (statement == null) break block14;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (statement != null) {
                    try {
                        statement.closeX();
                    }
                    catch (SqlException sqlException) {
                        // empty catch block
                    }
                }
                this.xaState_ = n;
                throw throwable;
            }
            try {
                statement.closeX();
                break block14;
            }
            catch (SqlException sqlException) {
                // empty catch block
            }
            {
            }
        }
        this.xaState_ = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void releaseSavepoint(java.sql.Savepoint savepoint) throws SqlException {
        int n;
        block14: {
            n = this.xaState_;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "releaseSavepoint", savepoint);
            }
            this.checkForClosedConnection();
            if (savepoint == null) {
                throw new SqlException(this.agent_.logWriter_, "Cannot release a null savepoint.");
            }
            if (this.autoCommit_) {
                throw new SqlException(this.agent_.logWriter_, "Cannot release a savepoint when in auto-commit mode.");
            }
            try {
                if (this != ((Savepoint)savepoint).agent_.connection_) {
                    throw new SqlException(this.agent_.logWriter_, "Cannot release a savepoint that was not created by this connection.");
                }
            }
            catch (ClassCastException classCastException) {
                throw new SqlException(this.agent_.logWriter_, "Cannot release a savepoint that was not created by this connection.");
            }
            Statement statement = null;
            try {
                String string;
                statement = this.createStatementX(1003, 1007, this.resultSetHoldability_);
                try {
                    string = ((Savepoint)savepoint).getSavepointName();
                }
                catch (SqlException sqlException) {
                    string = dncGeneratedSavepointNamePrefix__ + ((Savepoint)savepoint).getSavepointId();
                }
                String string2 = "RELEASE SAVEPOINT \"" + string + "\"";
                statement.executeX(string2);
                Object var7_8 = null;
                if (statement == null) break block14;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (statement != null) {
                    try {
                        statement.closeX();
                    }
                    catch (SqlException sqlException) {
                        // empty catch block
                    }
                }
                this.xaState_ = n;
                throw throwable;
            }
            try {
                statement.closeX();
                break block14;
            }
            catch (SqlException sqlException) {
                // empty catch block
            }
            {
            }
        }
        this.xaState_ = n;
    }

    public synchronized java.sql.Statement createStatement(int n, int n2, int n3) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "createStatement", n, n2, n3);
        }
        Statement statement = this.createStatementX(n, n2, n3);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "createStatement", statement);
        }
        return statement;
    }

    private Statement createStatementX(int n, int n2, int n3) throws SqlException {
        this.checkForClosedConnection();
        n = this.downgradeResultSetType(n);
        n2 = this.downgradeResultSetConcurrency(n2, n);
        Statement statement = this.newStatement_(n, n2, n3);
        statement.cursorAttributesToSendOnPrepare_ = statement.cacheCursorAttributesToSendOnPrepare();
        this.openStatements_.add(statement);
        return statement;
    }

    protected void resetStatement(Statement statement) throws SqlException {
        String string = statement.cursorAttributesToSendOnPrepare_;
        this.resetStatement_(statement, statement.resultSetType_, statement.resultSetConcurrency_, statement.resultSetHoldability_);
        statement.cursorAttributesToSendOnPrepare_ = string;
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "prepareStatement", (Object)string, n, n2, n3);
        }
        PreparedStatement preparedStatement = this.prepareStatementX(string, n, n2, n3, 2, null);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", preparedStatement);
        }
        return preparedStatement;
    }

    PreparedStatement prepareStatementX(String string, int n, int n2, int n3, int n4, String[] stringArray) throws SqlException {
        this.checkForClosedConnection();
        this.checkAutoGeneratedKeysParameters(n4, stringArray);
        n = this.downgradeResultSetType(n);
        n2 = this.downgradeResultSetConcurrency(n2, n);
        PreparedStatement preparedStatement = this.newPreparedStatement_(string, n, n2, n3, n4, stringArray);
        preparedStatement.cursorAttributesToSendOnPrepare_ = preparedStatement.cacheCursorAttributesToSendOnPrepare();
        preparedStatement.prepare();
        this.openStatements_.add(preparedStatement);
        return preparedStatement;
    }

    protected void resetPrepareStatement(PreparedStatement preparedStatement) throws SqlException {
        String string = preparedStatement.cursorAttributesToSendOnPrepare_;
        this.resetPreparedStatement_(preparedStatement, preparedStatement.sql_, preparedStatement.resultSetType_, preparedStatement.resultSetConcurrency_, preparedStatement.resultSetHoldability_, preparedStatement.autoGeneratedKeys_, preparedStatement.generatedKeysColumnNames_);
        preparedStatement.cursorAttributesToSendOnPrepare_ = string;
        preparedStatement.prepare();
    }

    public synchronized java.sql.CallableStatement prepareCall(String string, int n, int n2, int n3) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "prepareCall", (Object)string, n, n2, n3);
        }
        CallableStatement callableStatement = this.prepareCallX(string, n, n2, n3);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "prepareCall", callableStatement);
        }
        return callableStatement;
    }

    private CallableStatement prepareCallX(String string, int n, int n2, int n3) throws SqlException {
        this.checkForClosedConnection();
        n = this.downgradeResultSetType(n);
        n2 = this.downgradeResultSetConcurrency(n2, n);
        CallableStatement callableStatement = this.newCallableStatement_(string, n, n2, n3);
        callableStatement.cursorAttributesToSendOnPrepare_ = callableStatement.cacheCursorAttributesToSendOnPrepare();
        callableStatement.prepare();
        this.openStatements_.add(callableStatement);
        return callableStatement;
    }

    protected void resetPrepareCall(CallableStatement callableStatement) throws SqlException {
        String string = callableStatement.cursorAttributesToSendOnPrepare_;
        this.resetCallableStatement_(callableStatement, callableStatement.sql_, callableStatement.resultSetType_, callableStatement.resultSetConcurrency_, callableStatement.resultSetHoldability_);
        callableStatement.cursorAttributesToSendOnPrepare_ = string;
        callableStatement.prepare();
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "prepareStatement", (Object)string, n);
        }
        PreparedStatement preparedStatement = this.prepareStatementX(string, 1003, 1007, this.resultSetHoldability_, n, null);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", preparedStatement);
        }
        return preparedStatement;
    }

    public java.sql.PreparedStatement prepareStatement(String string, int[] nArray) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "prepareStatement", (Object)string, (Object)nArray);
        }
        this.checkForClosedConnection();
        throw new SqlException(this.agent_.logWriter_, "Driver not capable");
    }

    public java.sql.PreparedStatement prepareStatement(String string, String[] stringArray) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "prepareStatement", (Object)string, (Object)stringArray);
        }
        PreparedStatement preparedStatement = this.prepareStatementX(string, 1003, 1007, this.resultSetHoldability_, 1, stringArray);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", preparedStatement);
        }
        return preparedStatement;
    }

    protected abstract boolean allowCloseInUOW_();

    protected abstract boolean doCloseStatementsOnClose_();

    public abstract SectionManager newSectionManager(String var1, Agent var2, String var3);

    protected abstract Agent newAgent_(LogWriter var1, int var2, String var3, int var4) throws SqlException;

    protected abstract DatabaseMetaData newDatabaseMetaData_();

    protected abstract Statement newStatement_(int var1, int var2, int var3) throws SqlException;

    protected abstract void resetStatement_(Statement var1, int var2, int var3, int var4) throws SqlException;

    protected abstract PreparedStatement newPositionedUpdatePreparedStatement_(String var1, Section var2) throws SqlException;

    protected abstract PreparedStatement newPreparedStatement_(String var1, int var2, int var3, int var4, int var5, String[] var6) throws SqlException;

    protected abstract void resetPreparedStatement_(PreparedStatement var1, String var2, int var3, int var4, int var5, int var6, String[] var7) throws SqlException;

    protected abstract CallableStatement newCallableStatement_(String var1, int var2, int var3, int var4) throws SqlException;

    protected abstract void resetCallableStatement_(CallableStatement var1, String var2, int var3, int var4, int var5) throws SqlException;

    public void completeConnect() throws SqlException {
        this.open_ = true;
        this.databaseMetaData_ = this.newDatabaseMetaData_();
        this.agent_.sectionManager_ = this.newSectionManager("NULLID", this.agent_, this.databaseName_);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceConnectExit(this);
        }
    }

    public abstract void writeCommitSubstitute_() throws SqlException;

    public abstract void readCommitSubstitute_() throws SqlException;

    public abstract void writeLocalXAStart_() throws SqlException;

    public abstract void readLocalXAStart_() throws SqlException;

    public abstract void writeLocalXACommit_() throws SqlException;

    public abstract void readLocalXACommit_() throws SqlException;

    public abstract void writeLocalCommit_() throws SqlException;

    public abstract void readLocalCommit_() throws SqlException;

    public void completeLocalCommit() {
        Iterator iterator = this.CommitAndRollbackListeners_.iterator();
        while (iterator.hasNext()) {
            UnitOfWorkListener unitOfWorkListener = (UnitOfWorkListener)iterator.next();
            unitOfWorkListener.completeLocalCommit(iterator);
        }
        this.inUnitOfWork_ = false;
    }

    public abstract void writeLocalRollback_() throws SqlException;

    public abstract void readLocalRollback_() throws SqlException;

    public void completeLocalRollback() {
        UnitOfWorkListener unitOfWorkListener;
        Iterator iterator = this.CommitAndRollbackListeners_.iterator();
        while (iterator.hasNext()) {
            unitOfWorkListener = (UnitOfWorkListener)iterator.next();
            unitOfWorkListener.completeLocalRollback(iterator);
        }
        iterator = this.RollbackOnlyListeners_.iterator();
        while (iterator.hasNext()) {
            unitOfWorkListener = (UnitOfWorkListener)iterator.next();
            unitOfWorkListener.completeLocalRollback(iterator);
        }
        this.inUnitOfWork_ = false;
    }

    public abstract void writeLocalXARollback_() throws SqlException;

    public abstract void readLocalXARollback_() throws SqlException;

    public void writeTransactionStart(Statement statement) throws SqlException {
    }

    public void readTransactionStart() throws SqlException {
        this.completeTransactionStart();
    }

    void completeTransactionStart() {
        this.inUnitOfWork_ = true;
    }

    public void completeAbnormalUnitOfWork() {
        this.completeLocalRollback();
    }

    public void completeChainBreakingDisconnect() {
        this.open_ = false;
        this.completeLocalRollback();
        this.markStatementsClosed();
    }

    public void completeSqlca(Sqlca sqlca) {
        if (sqlca != null) {
            if (sqlca.getSqlCode() > 0) {
                this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
            } else if (sqlca.getSqlCode() < 0) {
                this.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, sqlca));
            }
        }
    }

    public abstract void addSpecialRegisters(String var1);

    public synchronized void reset(LogWriter logWriter, String string, String string2, ClientDataSource clientDataSource, boolean bl) throws SqlException {
        if (logWriter != null) {
            logWriter.traceConnectResetEntry(this, logWriter, string, clientDataSource != null ? clientDataSource : this.dataSource_);
        }
        try {
            this.reset_(logWriter, string, string2, clientDataSource, bl);
        }
        catch (SqlException sqlException) {
            DisconnectException disconnectException = new DisconnectException(this.agent_, "An error occurred during connect reset and the connection has been terminated.  See chained exceptions for details.");
            disconnectException.setNextException(sqlException);
            throw disconnectException;
        }
    }

    public synchronized void reset(LogWriter logWriter, ClientDataSource clientDataSource, boolean bl) throws SqlException {
        if (logWriter != null) {
            logWriter.traceConnectResetEntry(this, logWriter, null, clientDataSource != null ? clientDataSource : this.dataSource_);
        }
        try {
            this.reset_(logWriter, clientDataSource, bl);
        }
        catch (SqlException sqlException) {
            DisconnectException disconnectException = new DisconnectException(this.agent_, "An error occurred during connect reset and the connection has been terminated.  See chained exceptions for details.");
            disconnectException.setNextException(sqlException);
            throw disconnectException;
        }
    }

    public synchronized void lightReset() throws SqlException {
        if (!this.open_ && !this.availableForReuse_) {
            return;
        }
        this.open_ = true;
        this.availableForReuse_ = false;
    }

    protected abstract void reset_(LogWriter var1, String var2, String var3, ClientDataSource var4, boolean var5) throws SqlException;

    protected abstract void reset_(LogWriter var1, ClientDataSource var2, boolean var3) throws SqlException;

    protected void completeReset(boolean bl, boolean bl2) throws SqlException {
        this.open_ = true;
        this.completeLocalRollback();
        Iterator iterator = this.openStatements_.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            ((Statement)e).reset(bl2);
        }
        if (!bl && this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceConnectResetExit(this);
        }
    }

    protected void checkForClosedConnection() throws SqlException {
        if (!this.open_) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, "invalid operation: connection closed");
        }
        this.agent_.checkForDeferredExceptions();
    }

    void checkAutoGeneratedKeysParameters(int n, String[] stringArray) throws SqlException {
        if (n != 2 && n != 1) {
            throw new SqlException(this.agent_.logWriter_, "Invalid argument: Statement auto-generated keys value " + n + " is invalid.");
        }
        if (stringArray != null) {
            throw new SqlException(this.agent_.logWriter_, "Driver not capable");
        }
    }

    public boolean isXAConnection() {
        return this.isXAConnection_;
    }

    public int getXAState() {
        return this.xaState_;
    }

    public void setXAState(int n) {
        this.xaState_ = n;
    }

    public void accumulateWarning(SqlWarning sqlWarning) {
        if (this.warnings_ == null) {
            this.warnings_ = sqlWarning;
        } else {
            this.warnings_.setNextException(sqlWarning);
        }
    }

    public void accumulate440WarningForMessageProcFailure(SqlWarning sqlWarning) {
        if (!this.accumulated440ForMessageProcFailure_) {
            this.accumulateWarning(sqlWarning);
            this.accumulated440ForMessageProcFailure_ = true;
        }
    }

    public void accumulate444WarningForMessageProcFailure(SqlWarning sqlWarning) {
        if (!this.accumulated444ForMessageProcFailure_) {
            this.accumulateWarning(sqlWarning);
            this.accumulated444ForMessageProcFailure_ = true;
        }
    }

    public int getServerVersion() {
        return this.databaseMetaData_.productLevel_.versionLevel_;
    }

    public void setInUnitOfWork(boolean bl) {
        this.inUnitOfWork_ = bl;
    }
}

