/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.client;

import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.io.impl.Atom10Parser;
import com.sun.syndication.propono.atom.client.ClientEntry;
import com.sun.syndication.propono.atom.client.ClientMediaEntry;
import com.sun.syndication.propono.atom.client.ClientWorkspace;
import com.sun.syndication.propono.atom.common.AtomService;
import com.sun.syndication.propono.utils.ProponoException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class ClientAtomService
extends AtomService {
    private static Log logger = LogFactory.getLog((Class)(class$com$sun$syndication$propono$atom$client$ClientAtomService == null ? (class$com$sun$syndication$propono$atom$client$ClientAtomService = ClientAtomService.class$("com.sun.syndication.propono.atom.client.ClientAtomService")) : class$com$sun$syndication$propono$atom$client$ClientAtomService));
    private String uri = null;
    private String username = null;
    private String password = null;
    private String authString = null;
    private HttpClient httpClient = null;
    static /* synthetic */ Class class$com$sun$syndication$propono$atom$client$ClientAtomService;

    ClientAtomService(String uri, String username, String password) throws ProponoException {
        this.uri = uri;
        this.username = username;
        this.password = password;
        Document doc = this.getAtomServiceDocument();
        this.parseAtomServiceDocument(doc);
    }

    ClientAtomService(String uri, String authString) throws ProponoException {
        this.uri = uri;
        this.authString = authString;
        Document doc = this.getAtomServiceDocument();
        this.parseAtomServiceDocument(doc);
    }

    public ClientEntry getEntry(String uri) throws ProponoException {
        GetMethod method = new GetMethod(uri);
        this.addAuthentication((HttpMethodBase)method);
        try {
            this.httpClient.executeMethod((HttpMethod)method);
            if (method.getStatusCode() != 200) {
                throw new ProponoException("ERROR HTTP status code=" + method.getStatusCode());
            }
            Entry romeEntry = Atom10Parser.parseEntry((Reader)new InputStreamReader(method.getResponseBodyAsStream()), (String)uri);
            if (!romeEntry.isMediaEntry()) {
                ClientEntry clientEntry = new ClientEntry(this, null, romeEntry, false);
                return clientEntry;
            }
            ClientMediaEntry clientMediaEntry = new ClientMediaEntry(this, null, romeEntry, false);
            return clientMediaEntry;
        }
        catch (Exception e) {
            throw new ProponoException("ERROR: getting or parsing entry/media", e);
        }
        finally {
            method.releaseConnection();
        }
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    private Document getAtomServiceDocument() throws ProponoException {
        GetMethod method = null;
        int code = -1;
        try {
            this.httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
            method = new GetMethod(this.uri);
            this.addAuthentication((HttpMethodBase)method);
            this.httpClient.executeMethod((HttpMethod)method);
            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build(method.getResponseBodyAsStream());
            return document;
        }
        catch (Throwable t) {
            String msg = "ERROR retrieving Atom Service Document, code: " + code;
            logger.debug((Object)msg, t);
            throw new ProponoException(msg, t);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private void parseAtomServiceDocument(Document document) throws ProponoException {
        Element root = document.getRootElement();
        List spaces = root.getChildren("workspace", AtomService.ATOM_PROTOCOL);
        Iterator iter = spaces.iterator();
        while (iter.hasNext()) {
            Element e = (Element)iter.next();
            this.addWorkspace(new ClientWorkspace(e, this, this.uri));
        }
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    void addAuthentication(HttpMethodBase method) {
        if (this.authString != null) {
            method.setRequestHeader("Authorization", this.authString);
        } else if (this.username != null && this.password != null) {
            String pair = this.getUsername() + ":" + this.getPassword();
            String digest = new String(Base64.encodeBase64((byte[])pair.getBytes()));
            String header = "Basic " + digest;
            method.setRequestHeader("Authorization", header);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

