/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.client;

import com.sun.syndication.propono.atom.client.ClientCollection;
import com.sun.syndication.propono.atom.common.Categories;
import com.sun.syndication.propono.utils.ProponoException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ClientCategories
extends Categories {
    private ClientCollection clientCollection = null;

    public ClientCategories(Element e, ClientCollection clientCollection) throws ProponoException {
        this.clientCollection = clientCollection;
        this.parseCategoriesElement(e);
        if (this.getHref() != null) {
            this.fetchContents();
        }
    }

    public void fetchContents() throws ProponoException {
        GetMethod method = new GetMethod(this.getHrefResolved());
        this.clientCollection.addAuthentication((HttpMethodBase)method);
        try {
            this.clientCollection.getHttpClient().executeMethod((HttpMethod)method);
            if (method.getStatusCode() != 200) {
                throw new ProponoException("ERROR HTTP status code=" + method.getStatusCode());
            }
            SAXBuilder builder = new SAXBuilder();
            Document catsDoc = builder.build((Reader)new InputStreamReader(method.getResponseBodyAsStream()));
            this.parseCategoriesElement(catsDoc.getRootElement());
        }
        catch (IOException ioe) {
            throw new ProponoException("ERROR: reading out-of-line categories", ioe);
        }
        catch (JDOMException jde) {
            throw new ProponoException("ERROR: parsing out-of-line categories", jde);
        }
        finally {
            method.releaseConnection();
        }
    }
}

