/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.client;

import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.io.impl.Atom10Parser;
import com.sun.syndication.propono.atom.client.ClientAtomService;
import com.sun.syndication.propono.atom.client.ClientCategories;
import com.sun.syndication.propono.atom.client.ClientEntry;
import com.sun.syndication.propono.atom.client.ClientMediaEntry;
import com.sun.syndication.propono.atom.client.ClientWorkspace;
import com.sun.syndication.propono.atom.client.EntryIterator;
import com.sun.syndication.propono.atom.common.AtomService;
import com.sun.syndication.propono.atom.common.Collection;
import com.sun.syndication.propono.atom.common.Workspace;
import com.sun.syndication.propono.utils.ProponoException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;

public class ClientCollection
extends Collection {
    static final Log logger = LogFactory.getLog((Class)(class$com$sun$syndication$propono$atom$client$ClientCollection == null ? (class$com$sun$syndication$propono$atom$client$ClientCollection = ClientCollection.class$("com.sun.syndication.propono.atom.client.ClientCollection")) : class$com$sun$syndication$propono$atom$client$ClientCollection));
    private List categories = new ArrayList();
    private HttpClient httpClient = null;
    private String username = null;
    private String password = null;
    private String authString = null;
    private boolean writable = true;
    private ClientWorkspace workspace = null;
    private ClientAtomService service = null;
    static /* synthetic */ Class class$com$sun$syndication$propono$atom$client$ClientCollection;

    ClientCollection(Element e, ClientWorkspace workspace, String baseURI) throws ProponoException {
        super(e, baseURI);
        this.workspace = workspace;
        this.service = workspace.getAtomService();
        this.httpClient = workspace.getAtomService().getHttpClient();
        this.username = workspace.getAtomService().getUsername();
        this.password = workspace.getAtomService().getPassword();
        this.parseCollectionElement(e);
    }

    ClientCollection(String href, String username, String password) throws ProponoException {
        super("Standalone connection", "text", href);
        this.username = username;
        this.password = password;
        try {
            this.httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
        }
        catch (Throwable t) {
            throw new ProponoException("ERROR creating HTTPClient", t);
        }
    }

    ClientCollection(String href, String authString) throws ProponoException {
        this(href, null, null);
        this.authString = authString;
    }

    ClientCollection(String href) throws ProponoException {
        this(href, null, null);
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    void addAuthentication(HttpMethodBase method) {
        if (this.workspace != null) {
            this.workspace.getAtomService().addAuthentication(method);
        } else if (this.authString != null) {
            method.setRequestHeader("Authorization", this.authString);
        } else if (this.username != null && this.password != null) {
            this.httpClient.getParams().setAuthenticationPreemptive(true);
            String pair = this.username + ":" + this.password;
            String digest = new String(Base64.encodeBase64((byte[])pair.getBytes()));
            String header = "Basic " + digest;
            method.setRequestHeader("Authorization", header);
        }
    }

    public Iterator getEntries() throws ProponoException {
        return new EntryIterator(this);
    }

    public ClientEntry getEntry(String uri) throws ProponoException {
        GetMethod method = new GetMethod(uri);
        this.addAuthentication((HttpMethodBase)method);
        try {
            this.httpClient.executeMethod((HttpMethod)method);
            if (method.getStatusCode() != 200) {
                throw new ProponoException("ERROR HTTP status code=" + method.getStatusCode());
            }
            Entry romeEntry = Atom10Parser.parseEntry((Reader)new InputStreamReader(method.getResponseBodyAsStream()), (String)uri);
            if (!romeEntry.isMediaEntry()) {
                ClientEntry clientEntry = new ClientEntry(this.service, this, romeEntry, false);
                return clientEntry;
            }
            ClientMediaEntry clientMediaEntry = new ClientMediaEntry(this.service, this, romeEntry, false);
            return clientMediaEntry;
        }
        catch (Exception e) {
            throw new ProponoException("ERROR: getting or parsing entry/media, HTTP code: ", e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public ClientEntry createEntry() throws ProponoException {
        if (!this.isWritable()) {
            throw new ProponoException("Collection is not writable");
        }
        return new ClientEntry(this.service, this);
    }

    public ClientMediaEntry createMediaEntry(String title, String slug, String contentType, byte[] bytes) throws ProponoException {
        if (!this.isWritable()) {
            throw new ProponoException("Collection is not writable");
        }
        return new ClientMediaEntry(this.service, this, title, slug, contentType, bytes);
    }

    public ClientMediaEntry createMediaEntry(String title, String slug, String contentType, InputStream is) throws ProponoException {
        if (!this.isWritable()) {
            throw new ProponoException("Collection is not writable");
        }
        return new ClientMediaEntry(this.service, this, title, slug, contentType, is);
    }

    public void addEntry(ClientEntry entry) throws ProponoException {
        if (!this.isWritable()) {
            throw new ProponoException("Collection is not writable");
        }
        entry.addToCollection(this);
    }

    String getUsername() {
        return this.username;
    }

    void setUsername(String username) {
        this.username = username;
    }

    String getPassword() {
        return this.password;
    }

    void setPassword(String password) {
        this.password = password;
    }

    protected void parseCollectionElement(Element element) throws ProponoException {
        List acceptElems;
        if (this.workspace == null) {
            return;
        }
        this.setHref(element.getAttribute("href").getValue());
        Element titleElem = element.getChild("title", AtomService.ATOM_FORMAT);
        if (titleElem != null) {
            this.setTitle(titleElem.getText());
            if (titleElem.getAttribute("type", AtomService.ATOM_FORMAT) != null) {
                this.setTitleType(titleElem.getAttribute("type", AtomService.ATOM_FORMAT).getValue());
            }
        }
        if ((acceptElems = element.getChildren("accept", AtomService.ATOM_PROTOCOL)) != null && acceptElems.size() > 0) {
            Iterator it = acceptElems.iterator();
            while (it.hasNext()) {
                Element acceptElem = (Element)it.next();
                this.addAccept(acceptElem.getTextTrim());
            }
        }
        List catsElems = element.getChildren("categories", AtomService.ATOM_PROTOCOL);
        Iterator catsIter = catsElems.iterator();
        while (catsIter.hasNext()) {
            Element catsElem = (Element)catsIter.next();
            ClientCategories cats = new ClientCategories(catsElem, this);
            this.addCategories(cats);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

