/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.client;

import com.sun.syndication.feed.atom.Content;
import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Link;
import com.sun.syndication.io.impl.Atom10Generator;
import com.sun.syndication.io.impl.Atom10Parser;
import com.sun.syndication.propono.atom.client.ClientAtomService;
import com.sun.syndication.propono.atom.client.ClientCollection;
import com.sun.syndication.propono.utils.ProponoException;
import com.sun.syndication.propono.utils.Utilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientEntry
extends Entry {
    private static final Log logger = LogFactory.getLog((Class)(class$com$sun$syndication$propono$atom$client$ClientEntry == null ? (class$com$sun$syndication$propono$atom$client$ClientEntry = ClientEntry.class$("com.sun.syndication.propono.atom.client.ClientEntry")) : class$com$sun$syndication$propono$atom$client$ClientEntry));
    boolean partial = false;
    private ClientAtomService service = null;
    private ClientCollection collection = null;
    static /* synthetic */ Class class$com$sun$syndication$propono$atom$client$ClientEntry;

    public ClientEntry(ClientAtomService service, ClientCollection collection) {
        this.service = service;
        this.collection = collection;
    }

    public ClientEntry(ClientAtomService service, ClientCollection collection, Entry entry, boolean partial) throws ProponoException {
        this.service = service;
        this.collection = collection;
        this.partial = partial;
        try {
            BeanUtils.copyProperties((Object)((Object)this), (Object)entry);
        }
        catch (Exception e) {
            throw new ProponoException("ERROR: copying fields from ROME entry", e);
        }
    }

    public void setContent(String contentString, String type) {
        Content newContent = new Content();
        newContent.setType("html");
        newContent.setValue(contentString);
        ArrayList<Content> contents = new ArrayList<Content>();
        contents.add(newContent);
        this.setContents(contents);
    }

    public void setContent(Content c) {
        ArrayList<Content> contents = new ArrayList<Content>();
        contents.add(c);
        this.setContents(contents);
    }

    public Content getContent() {
        if (this.getContents() != null && this.getContents().size() > 0) {
            Content c = (Content)this.getContents().get(0);
            return c;
        }
        return null;
    }

    public boolean equals(Object o) {
        ClientEntry other;
        if (o instanceof ClientEntry && (other = (ClientEntry)((Object)o)).getEditURI() != null && this.getEditURI() != null) {
            return other.getEditURI().equals(this.getEditURI());
        }
        return false;
    }

    public void update() throws ProponoException {
        if (this.partial) {
            throw new ProponoException("ERROR: attempt to update partial entry");
        }
        PutMethod method = new PutMethod(this.getEditURI());
        this.addAuthentication((HttpMethodBase)method);
        StringWriter sw = new StringWriter();
        int code = -1;
        try {
            Atom10Generator.serializeEntry((Entry)this, (Writer)sw);
            method.setRequestEntity((RequestEntity)new StringRequestEntity(sw.toString()));
            method.setRequestHeader("Content-type", "application/atom+xml; charset=utf-8");
            this.getHttpClient().executeMethod((HttpMethod)method);
            InputStream is = method.getResponseBodyAsStream();
            if (method.getStatusCode() != 200 && method.getStatusCode() != 201) {
                throw new ProponoException("ERROR HTTP status=" + method.getStatusCode() + " : " + Utilities.streamToString(is));
            }
        }
        catch (Exception e) {
            String msg = "ERROR: updating entry, HTTP code: " + code;
            logger.debug((Object)msg, (Throwable)e);
            throw new ProponoException(msg, e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public void remove() throws ProponoException {
        if (this.getEditURI() == null) {
            throw new ProponoException("ERROR: cannot delete unsaved entry");
        }
        DeleteMethod method = new DeleteMethod(this.getEditURI());
        this.addAuthentication((HttpMethodBase)method);
        try {
            this.getHttpClient().executeMethod((HttpMethod)method);
        }
        catch (IOException ex) {
            throw new ProponoException("ERROR: removing entry, HTTP code", ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    void setCollection(ClientCollection collection) {
        this.collection = collection;
    }

    ClientCollection getCollection() {
        return this.collection;
    }

    public String getEditURI() {
        for (int i = 0; i < this.getOtherLinks().size(); ++i) {
            Link link = (Link)this.getOtherLinks().get(i);
            if (link.getRel() == null || !link.getRel().equals("edit")) continue;
            return link.getHrefResolved();
        }
        return null;
    }

    void addToCollection(ClientCollection col) throws ProponoException {
        this.setCollection(col);
        PostMethod method = new PostMethod(this.getCollection().getHrefResolved());
        this.addAuthentication((HttpMethodBase)method);
        StringWriter sw = new StringWriter();
        int code = -1;
        try {
            Atom10Generator.serializeEntry((Entry)this, (Writer)sw);
            method.setRequestEntity((RequestEntity)new StringRequestEntity(sw.toString()));
            method.setRequestHeader("Content-type", "application/atom+xml; charset=utf-8");
            this.getHttpClient().executeMethod((HttpMethod)method);
            InputStream is = method.getResponseBodyAsStream();
            code = method.getStatusCode();
            if (code != 200 && code != 201) {
                throw new ProponoException("ERROR HTTP status=" + code + " : " + Utilities.streamToString(is));
            }
            Entry romeEntry = Atom10Parser.parseEntry((Reader)new InputStreamReader(is), (String)this.getCollection().getHrefResolved());
            BeanUtils.copyProperties((Object)((Object)this), (Object)romeEntry);
        }
        catch (Exception e) {
            String msg = "ERROR: saving entry, HTTP code: " + code;
            logger.debug((Object)msg, (Throwable)e);
            throw new ProponoException(msg, e);
        }
        finally {
            method.releaseConnection();
        }
        Header locationHeader = method.getResponseHeader("Location");
        if (locationHeader == null) {
            logger.warn((Object)"WARNING added entry, but no location header returned");
        }
    }

    void addAuthentication(HttpMethodBase method) {
        if (this.service != null) {
            this.service.addAuthentication(method);
        } else if (this.collection != null) {
            this.collection.addAuthentication(method);
        }
    }

    HttpClient getHttpClient() {
        if (this.service != null) {
            return this.service.getHttpClient();
        }
        if (this.collection != null) {
            return this.collection.getHttpClient();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

