/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.client;

import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.feed.atom.Link;
import com.sun.syndication.io.WireFeedInput;
import com.sun.syndication.propono.atom.client.ClientCollection;
import com.sun.syndication.propono.atom.client.ClientEntry;
import com.sun.syndication.propono.atom.client.ClientMediaEntry;
import com.sun.syndication.propono.utils.ProponoException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;

public class EntryIterator
implements Iterator {
    static final Log logger = LogFactory.getLog((Class)(class$com$sun$syndication$propono$atom$client$EntryIterator == null ? (class$com$sun$syndication$propono$atom$client$EntryIterator = EntryIterator.class$("com.sun.syndication.propono.atom.client.EntryIterator")) : class$com$sun$syndication$propono$atom$client$EntryIterator));
    private final ClientCollection collection;
    int maxEntries = 20;
    int offset = 0;
    Iterator members = null;
    Feed col = null;
    String collectionURI;
    String nextURI;
    static /* synthetic */ Class class$com$sun$syndication$propono$atom$client$EntryIterator;

    EntryIterator(ClientCollection collection) throws ProponoException {
        this.collection = collection;
        this.nextURI = this.collectionURI = collection.getHrefResolved();
        this.getNextEntries();
    }

    public boolean hasNext() {
        if (!this.members.hasNext()) {
            try {
                this.getNextEntries();
            }
            catch (Exception ignored) {
                logger.error((Object)"ERROR getting next entries", (Throwable)ignored);
            }
        }
        return this.members.hasNext();
    }

    public Object next() {
        if (this.hasNext()) {
            Entry romeEntry = (Entry)this.members.next();
            try {
                if (!romeEntry.isMediaEntry()) {
                    return new ClientEntry(null, this.collection, romeEntry, true);
                }
                return new ClientMediaEntry(null, this.collection, romeEntry, true);
            }
            catch (ProponoException e) {
                throw new RuntimeException("Unexpected exception creating ClientEntry or ClientMedia", e);
            }
        }
        throw new NoSuchElementException();
    }

    public void remove() {
    }

    private void getNextEntries() throws ProponoException {
        if (this.nextURI == null) {
            return;
        }
        GetMethod colGet = new GetMethod(this.nextURI);
        this.collection.addAuthentication((HttpMethodBase)colGet);
        try {
            this.collection.getHttpClient().executeMethod((HttpMethod)colGet);
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(colGet.getResponseBodyAsStream());
            WireFeedInput feedInput = new WireFeedInput();
            this.col = (Feed)feedInput.build(doc);
        }
        catch (Exception e) {
            throw new ProponoException("ERROR: fetching or parsing next entries, HTTP code: " + colGet.getStatusCode(), e);
        }
        finally {
            colGet.releaseConnection();
        }
        this.members = this.col.getEntries().iterator();
        this.offset += this.col.getEntries().size();
        this.nextURI = null;
        List altLinks = this.col.getOtherLinks();
        if (altLinks != null) {
            Iterator iter = altLinks.iterator();
            while (iter.hasNext()) {
                Link link = (Link)iter.next();
                if (!"next".equals(link.getRel())) continue;
                this.nextURI = link.getHrefResolved();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

