/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.common;

import com.sun.syndication.propono.atom.common.Workspace;
import com.sun.syndication.propono.utils.ProponoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class AtomService {
    private List workspaces = new ArrayList();
    public static Namespace ATOM_FORMAT = Namespace.getNamespace((String)"atom", (String)"http://www.w3.org/2005/Atom");
    public static Namespace ATOM_PROTOCOL = Namespace.getNamespace((String)"app", (String)"http://www.w3.org/2007/app");

    public void addWorkspace(Workspace workspace) {
        this.workspaces.add(workspace);
    }

    public List getWorkspaces() {
        return this.workspaces;
    }

    public void setWorkspaces(List workspaces) {
        this.workspaces = workspaces;
    }

    public Workspace findWorkspace(String title) {
        Iterator it = this.workspaces.iterator();
        while (it.hasNext()) {
            Workspace ws = (Workspace)it.next();
            if (!title.equals(ws.getTitle())) continue;
            return ws;
        }
        return null;
    }

    public static AtomService documentToService(Document document) throws ProponoException {
        AtomService service = new AtomService();
        Element root = document.getRootElement();
        List spaces = root.getChildren("workspace", ATOM_PROTOCOL);
        Iterator iter = spaces.iterator();
        while (iter.hasNext()) {
            Element e = (Element)iter.next();
            service.addWorkspace(Workspace.elementToWorkspace(e));
        }
        return service;
    }

    public Document serviceToDocument() {
        AtomService service = this;
        Document doc = new Document();
        Element root = new Element("service", ATOM_PROTOCOL);
        doc.setRootElement(root);
        Iterator iter = service.getWorkspaces().iterator();
        while (iter.hasNext()) {
            Workspace space = (Workspace)iter.next();
            root.addContent((Content)space.workspaceToElement());
        }
        return doc;
    }
}

