/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.common;

import com.sun.syndication.feed.atom.Category;
import com.sun.syndication.io.impl.Atom10Parser;
import com.sun.syndication.propono.atom.common.AtomService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Parent;

public class Categories {
    private List categories = new ArrayList();
    private String baseURI = null;
    private Element categoriesElement = null;
    private String href = null;
    private String scheme = null;
    private boolean fixed = false;

    public Categories() {
    }

    public Categories(Element e, String baseURI) {
        this.categoriesElement = e;
        this.baseURI = baseURI;
        this.parseCategoriesElement(e);
    }

    public void addCategory(Category cat) {
        this.categories.add(cat);
    }

    public List getCategories() {
        return this.categories;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getHrefResolved() {
        if (Atom10Parser.isAbsoluteURI((String)this.href)) {
            return this.href;
        }
        if (this.baseURI != null && this.categoriesElement != null) {
            return Atom10Parser.resolveURI((String)this.baseURI, (Parent)this.categoriesElement, (String)this.href);
        }
        return null;
    }

    public Element categoriesToElement() {
        Categories cats = this;
        Element catsElem = new Element("categories", AtomService.ATOM_PROTOCOL);
        catsElem.setAttribute("fixed", cats.isFixed() ? "yes" : "no", AtomService.ATOM_PROTOCOL);
        if (cats.getScheme() != null) {
            catsElem.setAttribute("scheme", cats.getScheme(), AtomService.ATOM_PROTOCOL);
        }
        if (cats.getHref() != null) {
            catsElem.setAttribute("href", cats.getHref(), AtomService.ATOM_PROTOCOL);
        } else {
            Iterator catIter = cats.getCategories().iterator();
            while (catIter.hasNext()) {
                Category cat = (Category)catIter.next();
                Element catElem = new Element("category", AtomService.ATOM_FORMAT);
                catElem.setAttribute("term", cat.getTerm(), AtomService.ATOM_FORMAT);
                if (cat.getScheme() != null) {
                    catElem.setAttribute("scheme", cat.getScheme(), AtomService.ATOM_FORMAT);
                }
                if (cat.getLabel() != null) {
                    catElem.setAttribute("label", cat.getLabel(), AtomService.ATOM_FORMAT);
                }
                catsElem.addContent((Content)catElem);
            }
        }
        return catsElem;
    }

    protected void parseCategoriesElement(Element catsElem) {
        if (catsElem.getAttribute("href", AtomService.ATOM_PROTOCOL) != null) {
            this.setHref(catsElem.getAttribute("href", AtomService.ATOM_PROTOCOL).getValue());
        }
        if (catsElem.getAttribute("fixed", AtomService.ATOM_PROTOCOL) != null && "yes".equals(catsElem.getAttribute("fixed", AtomService.ATOM_PROTOCOL).getValue())) {
            this.setFixed(true);
        }
        if (catsElem.getAttribute("scheme", AtomService.ATOM_PROTOCOL) != null) {
            this.setScheme(catsElem.getAttribute("scheme", AtomService.ATOM_PROTOCOL).getValue());
        }
        List catElems = catsElem.getChildren("category", AtomService.ATOM_FORMAT);
        Iterator catIter = catElems.iterator();
        while (catIter.hasNext()) {
            Element catElem = (Element)catIter.next();
            Category cat = new Category();
            cat.setTerm(catElem.getAttributeValue("term", AtomService.ATOM_FORMAT));
            cat.setLabel(catElem.getAttributeValue("label", AtomService.ATOM_FORMAT));
            cat.setScheme(catElem.getAttributeValue("scheme", AtomService.ATOM_FORMAT));
            this.addCategory(cat);
        }
    }
}

