/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.common;

import com.sun.syndication.io.impl.Atom10Parser;
import com.sun.syndication.propono.atom.common.AtomService;
import com.sun.syndication.propono.atom.common.Categories;
import com.sun.syndication.propono.utils.ProponoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Parent;

public class Collection {
    public static final String ENTRY_TYPE = "application/atom+xml;type=entry";
    private Element collectionElement = null;
    private String baseURI = null;
    private String title = null;
    private String titleType = null;
    private List accepts = new ArrayList();
    private String listTemplate = null;
    private String href = null;
    private List categories = new ArrayList();

    public Collection(String title, String titleType, String href) {
        this.title = title;
        this.titleType = titleType;
        this.href = href;
    }

    public Collection(Element e) throws ProponoException {
        this.collectionElement = e;
        this.parseCollectionElement(e);
    }

    public Collection(Element e, String baseURI) throws ProponoException {
        this.collectionElement = e;
        this.baseURI = baseURI;
        this.parseCollectionElement(e);
    }

    public List getAccepts() {
        return this.accepts;
    }

    public void addAccept(String accept) {
        this.accepts.add(accept);
    }

    public void setAccepts(List accepts) {
        this.accepts = accepts;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getHrefResolved() {
        if (Atom10Parser.isAbsoluteURI((String)this.href)) {
            return this.href;
        }
        if (this.baseURI != null && this.collectionElement != null) {
            int lastslash = this.baseURI.lastIndexOf("/");
            return Atom10Parser.resolveURI((String)this.baseURI.substring(0, lastslash), (Parent)this.collectionElement, (String)this.href);
        }
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleType() {
        return this.titleType;
    }

    public void setTitleType(String titleType) {
        this.titleType = titleType;
    }

    public void addCategories(Categories cats) {
        this.categories.add(cats);
    }

    public List getCategories() {
        return this.categories;
    }

    public boolean accepts(String ct) {
        Iterator it = this.accepts.iterator();
        while (it.hasNext()) {
            String accept = (String)it.next();
            if (accept != null && accept.trim().equals("*/*")) {
                return true;
            }
            String entryType = "application/atom+xml";
            boolean entry = entryType.equals(ct);
            if (entry && null == accept) {
                return true;
            }
            if (entry && "entry".equals(accept)) {
                return true;
            }
            if (entry && entryType.equals(accept)) {
                return true;
            }
            String[] rules = this.accepts.toArray(new String[this.accepts.size()]);
            for (int i = 0; i < rules.length; ++i) {
                String rule = rules[i].trim();
                if (rule.equals(ct)) {
                    return true;
                }
                int slashstar = rule.indexOf("/*");
                if (slashstar <= 0 || !ct.startsWith(rule = rule.substring(0, slashstar + 1))) continue;
                return true;
            }
        }
        return false;
    }

    public Element collectionToElement() {
        Collection collection = this;
        Element element = new Element("collection", AtomService.ATOM_PROTOCOL);
        element.setAttribute("href", collection.getHref());
        Element title = new Element("title", AtomService.ATOM_FORMAT);
        title.setText(collection.getTitle());
        element.addContent((Content)title);
        if (collection.getTitleType() != null && !collection.getTitleType().equals("TEXT")) {
            element.setAttribute("type", collection.getTitleType(), AtomService.ATOM_FORMAT);
        }
        Iterator it = collection.getCategories().iterator();
        while (it.hasNext()) {
            Categories cats = (Categories)it.next();
            element.addContent((Content)cats.categoriesToElement());
        }
        it = collection.getAccepts().iterator();
        while (it.hasNext()) {
            String range = (String)it.next();
            Element acceptElem = new Element("accept", AtomService.ATOM_PROTOCOL);
            acceptElem.setText(range);
            element.addContent((Content)acceptElem);
        }
        return element;
    }

    public Collection elementToCollection(Element element) throws ProponoException {
        return new Collection(element);
    }

    protected void parseCollectionElement(Element element) throws ProponoException {
        List acceptElems;
        this.setHref(element.getAttribute("href").getValue());
        Element titleElem = element.getChild("title", AtomService.ATOM_FORMAT);
        if (titleElem != null) {
            this.setTitle(titleElem.getText());
            if (titleElem.getAttribute("type", AtomService.ATOM_FORMAT) != null) {
                this.setTitleType(titleElem.getAttribute("type", AtomService.ATOM_FORMAT).getValue());
            }
        }
        if ((acceptElems = element.getChildren("accept", AtomService.ATOM_PROTOCOL)) != null && acceptElems.size() > 0) {
            Iterator it = acceptElems.iterator();
            while (it.hasNext()) {
                Element acceptElem = (Element)it.next();
                this.addAccept(acceptElem.getTextTrim());
            }
        }
        List catsElems = element.getChildren("categories", AtomService.ATOM_PROTOCOL);
        Iterator catsIter = catsElems.iterator();
        while (catsIter.hasNext()) {
            Element catsElem = (Element)catsIter.next();
            Categories cats = new Categories(catsElem, this.baseURI);
            this.addCategories(cats);
        }
    }
}

