/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.common;

import com.sun.syndication.propono.atom.common.AtomService;
import com.sun.syndication.propono.atom.common.Collection;
import com.sun.syndication.propono.utils.ProponoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class Workspace {
    private String title = null;
    private String titleType = null;
    private List collections = new ArrayList();

    public Workspace(String title, String titleType) {
        this.title = title;
        this.titleType = titleType;
    }

    public Workspace(Element elem) throws ProponoException {
        this.parseWorkspaceElement(elem);
    }

    public List getCollections() {
        return this.collections;
    }

    public void addCollection(Collection col) {
        this.collections.add(col);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleType() {
        return this.titleType;
    }

    public void setTitleType(String titleType) {
        this.titleType = titleType;
    }

    public Collection findCollection(String title, String contentType) {
        Iterator it = this.collections.iterator();
        while (it.hasNext()) {
            Collection col = (Collection)it.next();
            if (title != null && col.accepts(contentType)) {
                return col;
            }
            if (!col.accepts(contentType)) continue;
            return col;
        }
        return null;
    }

    public static Workspace elementToWorkspace(Element element) throws ProponoException {
        return new Workspace(element);
    }

    public Element workspaceToElement() {
        Workspace space = this;
        Element element = new Element("workspace", AtomService.ATOM_PROTOCOL);
        Element title = new Element("title", AtomService.ATOM_FORMAT);
        title.setText(space.getTitle());
        element.addContent((Content)title);
        if (space.getTitleType() != null && !space.getTitleType().equals("TEXT")) {
            element.setAttribute("type", space.getTitleType(), AtomService.ATOM_FORMAT);
        }
        Iterator iter = space.getCollections().iterator();
        while (iter.hasNext()) {
            Collection col = (Collection)iter.next();
            element.addContent((Content)col.collectionToElement());
        }
        return element;
    }

    protected void parseWorkspaceElement(Element element) throws ProponoException {
        Element titleElem = element.getChild("title", AtomService.ATOM_FORMAT);
        this.setTitle(titleElem.getText());
        if (titleElem.getAttribute("type", AtomService.ATOM_FORMAT) != null) {
            this.setTitleType(titleElem.getAttribute("type", AtomService.ATOM_FORMAT).getValue());
        }
        List collections = element.getChildren("collection", AtomService.ATOM_PROTOCOL);
        Iterator iter = collections.iterator();
        while (iter.hasNext()) {
            Element e = (Element)iter.next();
            this.addCollection(new Collection(e));
        }
    }
}

