/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.server;

import com.sun.syndication.propono.atom.server.SecuritySupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

class FactoryFinder {
    private static boolean debug = false;
    static Properties cacheProps = new Properties();
    static SecuritySupport ss = new SecuritySupport();
    static boolean firstTime = true;
    static /* synthetic */ Class class$com$sun$syndication$propono$atom$server$FactoryFinder;

    FactoryFinder() {
    }

    private static void dPrint(String msg) {
        if (debug) {
            System.err.println("Propono: " + msg);
        }
    }

    private static Object newInstance(String className, ClassLoader cl, boolean doFallback) throws ConfigurationError {
        try {
            Class<?> providerClass;
            if (cl == null) {
                providerClass = Class.forName(className);
            } else {
                try {
                    providerClass = cl.loadClass(className);
                }
                catch (ClassNotFoundException x) {
                    if (doFallback) {
                        cl = (class$com$sun$syndication$propono$atom$server$FactoryFinder == null ? (class$com$sun$syndication$propono$atom$server$FactoryFinder = FactoryFinder.class$("com.sun.syndication.propono.atom.server.FactoryFinder")) : class$com$sun$syndication$propono$atom$server$FactoryFinder).getClassLoader();
                        providerClass = cl.loadClass(className);
                    }
                    throw x;
                }
            }
            Object instance = providerClass.newInstance();
            FactoryFinder.dPrint("created new instance of " + providerClass + " using ClassLoader: " + cl);
            return instance;
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object find(String factoryId, String fallbackClassName) throws ConfigurationError {
        Object provider;
        ClassLoader classLoader;
        block17: {
            classLoader = ss.getContextClassLoader();
            if (classLoader == null) {
                classLoader = (class$com$sun$syndication$propono$atom$server$FactoryFinder == null ? (class$com$sun$syndication$propono$atom$server$FactoryFinder = FactoryFinder.class$("com.sun.syndication.propono.atom.server.FactoryFinder")) : class$com$sun$syndication$propono$atom$server$FactoryFinder).getClassLoader();
            }
            FactoryFinder.dPrint("find factoryId =" + factoryId);
            try {
                String systemProp = ss.getSystemProperty(factoryId);
                if (systemProp != null) {
                    FactoryFinder.dPrint("found system property, value=" + systemProp);
                    return FactoryFinder.newInstance(systemProp, classLoader, true);
                }
            }
            catch (SecurityException se) {
                // empty catch block
            }
            try {
                String javah = ss.getSystemProperty("java.home");
                String configFile = "/propono.properties";
                String factoryClassName = null;
                if (firstTime) {
                    Properties properties = cacheProps;
                    synchronized (properties) {
                        if (firstTime) {
                            try {
                                InputStream is = (class$com$sun$syndication$propono$atom$server$FactoryFinder == null ? (class$com$sun$syndication$propono$atom$server$FactoryFinder = FactoryFinder.class$("com.sun.syndication.propono.atom.server.FactoryFinder")) : class$com$sun$syndication$propono$atom$server$FactoryFinder).getResourceAsStream(configFile);
                                firstTime = false;
                                if (is != null) {
                                    FactoryFinder.dPrint("Read properties file: " + configFile);
                                    cacheProps.load(is);
                                }
                            }
                            catch (Exception intentionallyIgnored) {
                                // empty catch block
                            }
                        }
                    }
                }
                if ((factoryClassName = cacheProps.getProperty(factoryId)) != null) {
                    FactoryFinder.dPrint("found in $java.home/propono.properties, value=" + factoryClassName);
                    return FactoryFinder.newInstance(factoryClassName, classLoader, true);
                }
            }
            catch (Exception ex) {
                if (!debug) break block17;
                ex.printStackTrace();
            }
        }
        if ((provider = FactoryFinder.findJarServiceProvider(factoryId)) != null) {
            return provider;
        }
        if (fallbackClassName == null) {
            throw new ConfigurationError("Provider for " + factoryId + " cannot be found", null);
        }
        FactoryFinder.dPrint("loaded from fallback value: " + fallbackClassName);
        return FactoryFinder.newInstance(fallbackClassName, classLoader, true);
    }

    private static Object findJarServiceProvider(String factoryId) throws ConfigurationError {
        BufferedReader rd;
        String serviceId = "META-INF/services/" + factoryId;
        InputStream is = null;
        ClassLoader cl = ss.getContextClassLoader();
        if (cl != null) {
            is = ss.getResourceAsStream(cl, serviceId);
            if (is == null) {
                cl = (class$com$sun$syndication$propono$atom$server$FactoryFinder == null ? (class$com$sun$syndication$propono$atom$server$FactoryFinder = FactoryFinder.class$("com.sun.syndication.propono.atom.server.FactoryFinder")) : class$com$sun$syndication$propono$atom$server$FactoryFinder).getClassLoader();
                is = ss.getResourceAsStream(cl, serviceId);
            }
        } else {
            cl = (class$com$sun$syndication$propono$atom$server$FactoryFinder == null ? (class$com$sun$syndication$propono$atom$server$FactoryFinder = FactoryFinder.class$("com.sun.syndication.propono.atom.server.FactoryFinder")) : class$com$sun$syndication$propono$atom$server$FactoryFinder).getClassLoader();
            is = ss.getResourceAsStream(cl, serviceId);
        }
        if (is == null) {
            return null;
        }
        FactoryFinder.dPrint("found jar resource=" + serviceId + " using ClassLoader: " + cl);
        try {
            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            rd = new BufferedReader(new InputStreamReader(is));
        }
        String factoryClassName = null;
        try {
            factoryClassName = rd.readLine();
            rd.close();
        }
        catch (IOException x) {
            return null;
        }
        if (factoryClassName != null && !"".equals(factoryClassName)) {
            FactoryFinder.dPrint("found in resource, value=" + factoryClassName);
            return FactoryFinder.newInstance(factoryClassName, cl, false);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

