/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.server.impl;

import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.propono.atom.common.AtomService;
import com.sun.syndication.propono.atom.common.Categories;
import com.sun.syndication.propono.atom.server.AtomException;
import com.sun.syndication.propono.atom.server.AtomHandler;
import com.sun.syndication.propono.atom.server.AtomMediaResource;
import com.sun.syndication.propono.atom.server.AtomRequest;
import com.sun.syndication.propono.atom.server.AtomServlet;
import com.sun.syndication.propono.atom.server.impl.FileBasedAtomService;
import com.sun.syndication.propono.atom.server.impl.FileBasedCollection;
import java.io.File;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileBasedAtomHandler
implements AtomHandler {
    private static Log log = LogFactory.getFactory().getInstance(class$com$sun$syndication$propono$atom$server$impl$FileBasedAtomHandler == null ? (class$com$sun$syndication$propono$atom$server$impl$FileBasedAtomHandler = FileBasedAtomHandler.class$("com.sun.syndication.propono.atom.server.impl.FileBasedAtomHandler")) : class$com$sun$syndication$propono$atom$server$impl$FileBasedAtomHandler);
    private static String fileStoreDir = null;
    private String userName = null;
    private String atomProtocolURL = null;
    private String contextURI = null;
    private String uploadurl = null;
    private FileBasedAtomService service = null;
    static /* synthetic */ Class class$com$sun$syndication$propono$atom$server$impl$FileBasedAtomHandler;

    public FileBasedAtomHandler(HttpServletRequest req) {
        this(req, AtomServlet.getContextDirPath());
    }

    public FileBasedAtomHandler(HttpServletRequest req, String uploaddir) {
        log.debug((Object)"ctor");
        this.userName = this.authenticateBASIC(req);
        this.atomProtocolURL = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath() + req.getServletPath();
        this.contextURI = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath();
        try {
            this.service = new FileBasedAtomService(this.userName, uploaddir, this.contextURI, req.getContextPath(), req.getServletPath());
        }
        catch (Throwable t) {
            throw new RuntimeException("ERROR creating FileBasedAtomService", t);
        }
    }

    public boolean validateUser(String login, String password) {
        return true;
    }

    public String getAuthenticatedUsername() {
        return this.userName;
    }

    public String getAtomProtocolURL() {
        if (this.atomProtocolURL == null) {
            return "app";
        }
        return this.atomProtocolURL;
    }

    public AtomService getAtomService(AtomRequest areq) throws AtomException {
        return this.service;
    }

    public Categories getCategories(AtomRequest areq) throws AtomException {
        log.debug((Object)"getCollection");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        return (Categories)col.getCategories(true).get(0);
    }

    public Feed getCollection(AtomRequest areq) throws AtomException {
        log.debug((Object)"getCollection");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        return col.getFeedDocument();
    }

    public String postEntry(AtomRequest areq, Entry entry) throws AtomException {
        log.debug((Object)"postEntry");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        try {
            return col.addEntry(entry);
        }
        catch (Exception fe) {
            fe.printStackTrace();
            throw new AtomException(fe);
        }
    }

    public Entry getEntry(AtomRequest areq) throws AtomException {
        log.debug((Object)"getEntry");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        String fileName = pathInfo[2];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        try {
            return col.getEntry(fileName);
        }
        catch (Exception re) {
            if (re instanceof AtomException) {
                throw (AtomException)re;
            }
            throw new AtomException("ERROR: getting entry", re);
        }
    }

    public void putEntry(AtomRequest areq, Entry entry) throws AtomException {
        log.debug((Object)"putEntry");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        String fileName = pathInfo[2];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        try {
            col.updateEntry(entry, fileName);
        }
        catch (Exception fe) {
            throw new AtomException(fe);
        }
    }

    public void deleteEntry(AtomRequest areq) throws AtomException {
        log.debug((Object)"deleteEntry");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        String fileName = pathInfo[2];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        try {
            col.deleteEntry(fileName);
        }
        catch (Exception e) {
            String msg = "ERROR in atom.deleteResource";
            log.error((Object)msg, (Throwable)e);
            throw new AtomException(msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String postMedia(AtomRequest areq, Entry entry) throws AtomException {
        String slug = areq.getHeader("Slug");
        if (log.isDebugEnabled()) {
            log.debug((Object)("postMedia - title: " + entry.getTitle() + " slug:" + slug));
        }
        try {
            File tempFile = null;
            String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
            String handle = pathInfo[0];
            String collection = pathInfo[1];
            FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
            try {
                String string = col.addMediaEntry(entry, slug, areq.getInputStream());
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                String msg = "ERROR reading posted file";
                log.error((Object)msg, (Throwable)e);
                throw new AtomException(msg, e);
            }
            finally {
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
        catch (Exception re) {
            throw new AtomException("ERROR: posting media");
        }
    }

    public void putMedia(AtomRequest areq) throws AtomException {
        log.debug((Object)"putMedia");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        String fileName = pathInfo[3];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        try {
            col.updateMediaEntry(fileName, areq.getContentType(), areq.getInputStream());
        }
        catch (Exception re) {
            throw new AtomException("ERROR: posting media");
        }
    }

    public AtomMediaResource getMediaResource(AtomRequest areq) throws AtomException {
        log.debug((Object)"putMedia");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        String fileName = pathInfo[3];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        try {
            return col.getMediaResource(fileName);
        }
        catch (Exception re) {
            throw new AtomException("ERROR: posting media");
        }
    }

    public boolean isAtomServiceURI(AtomRequest areq) {
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        return pathInfo.length == 0;
    }

    public boolean isCategoriesURI(AtomRequest areq) {
        log.debug((Object)"isCategoriesDocumentURI");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        return pathInfo.length == 3 && "categories".equals(pathInfo[2]);
    }

    public boolean isCollectionURI(AtomRequest areq) {
        String collection;
        String handle;
        log.debug((Object)"isCollectionURI");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        return pathInfo.length == 2 && this.service.findCollectionByHandle(handle = pathInfo[0], collection = pathInfo[1]) != null;
    }

    public boolean isEntryURI(AtomRequest areq) {
        String collection;
        String handle;
        log.debug((Object)"isEntryURI");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        return pathInfo.length == 3 && this.service.findCollectionByHandle(handle = pathInfo[0], collection = pathInfo[1]) != null;
    }

    public boolean isMediaEditURI(AtomRequest areq) {
        log.debug((Object)"isMediaEditURI");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        if (pathInfo.length == 4) {
            String handle = pathInfo[0];
            String collection = pathInfo[1];
            String media = pathInfo[2];
            String fsid = pathInfo[3];
            if (this.service.findCollectionByHandle(handle, collection) != null && media.equals("media")) {
                return true;
            }
        }
        return false;
    }

    public String authenticateBASIC(HttpServletRequest request) {
        log.debug((Object)"authenticateBASIC");
        boolean valid = false;
        String userID = null;
        String password = null;
        try {
            String credentials;
            String userPass;
            int p;
            String basic;
            StringTokenizer st;
            String authHeader = request.getHeader("Authorization");
            if (authHeader != null && (st = new StringTokenizer(authHeader)).hasMoreTokens() && (basic = st.nextToken()).equalsIgnoreCase("Basic") && (p = (userPass = new String(Base64.decodeBase64((byte[])(credentials = st.nextToken()).getBytes()))).indexOf(":")) != -1) {
                userID = userPass.substring(0, p);
                password = userPass.substring(p + 1);
                valid = this.validateUser(userID, password);
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
        if (valid) {
            return userID;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

