/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.blogclient;

import com.sun.syndication.propono.blogclient.BlogClientException;
import com.sun.syndication.propono.blogclient.BlogConnection;
import java.lang.reflect.Constructor;

public class BlogConnectionFactory {
    private static String ATOMPROTOCOL_IMPL_CLASS = "com.sun.syndication.propono.blogclient.atomprotocol.AtomConnection";
    private static String METAWEBLOG_IMPL_CLASS = "com.sun.syndication.propono.blogclient.metaweblog.MetaWeblogConnection";
    static /* synthetic */ Class class$java$lang$String;

    public static BlogConnection getBlogConnection(String type, String url, String username, String password) throws BlogClientException {
        BlogConnection blogConnection = null;
        if (type == null || type.equals("metaweblog")) {
            blogConnection = BlogConnectionFactory.createBlogConnection(METAWEBLOG_IMPL_CLASS, url, username, password);
        } else if (type.equals("atom")) {
            blogConnection = BlogConnectionFactory.createBlogConnection(ATOMPROTOCOL_IMPL_CLASS, url, username, password);
        } else {
            throw new BlogClientException("Type must be 'atom' or 'metaweblog'");
        }
        return blogConnection;
    }

    private static BlogConnection createBlogConnection(String className, String url, String username, String password) throws BlogClientException {
        Class<?> conClass;
        try {
            conClass = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new BlogClientException("BlogConnection impl. class not found: " + className, ex);
        }
        Class[] args = new Class[]{class$java$lang$String == null ? (class$java$lang$String = BlogConnectionFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = BlogConnectionFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = BlogConnectionFactory.class$("java.lang.String")) : class$java$lang$String};
        try {
            Constructor<?> ctor = conClass.getConstructor(args);
            return (BlogConnection)ctor.newInstance(url, username, password);
        }
        catch (Throwable t) {
            throw new BlogClientException("ERROR instantiating BlogConnection impl.", t);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

