/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.blogclient.metaweblog;

import com.sun.syndication.propono.blogclient.Blog;
import com.sun.syndication.propono.blogclient.BlogClientException;
import com.sun.syndication.propono.blogclient.BlogEntry;
import com.sun.syndication.propono.blogclient.BlogResource;
import com.sun.syndication.propono.blogclient.metaweblog.MetaWeblogEntry;
import com.sun.syndication.propono.blogclient.metaweblog.MetaWeblogResource;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class MetaWeblogBlog
implements Blog {
    private String blogid;
    private String name;
    private URL url;
    private String userName;
    private String password;
    private String appkey = "dummy";
    private Map collections;
    private XmlRpcClient xmlRpcClient = null;

    public String getName() {
        return this.name;
    }

    public String getToken() {
        return this.blogid;
    }

    public String toString() {
        return this.getName();
    }

    private XmlRpcClient getXmlRpcClient() {
        if (this.xmlRpcClient == null) {
            XmlRpcClientConfigImpl xmlrpcConfig = new XmlRpcClientConfigImpl();
            xmlrpcConfig.setServerURL(this.url);
            this.xmlRpcClient = new XmlRpcClient();
            this.xmlRpcClient.setConfig((XmlRpcClientConfig)xmlrpcConfig);
        }
        return this.xmlRpcClient;
    }

    MetaWeblogBlog(String blogid, String name, URL url, String userName, String password) {
        this.blogid = blogid;
        this.name = name;
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.collections = new TreeMap();
        this.collections.put("entries", new MetaWeblogBlogCollection(this, "entries", "Entries", "entry"));
        this.collections.put("resources", new MetaWeblogBlogCollection(this, "resources", "Resources", "*"));
    }

    MetaWeblogBlog(String blogId, String name, URL url, String userName, String password, String appkey) {
        this(blogId, name, url, userName, password);
        this.appkey = appkey;
    }

    public BlogEntry newEntry() {
        return new MetaWeblogEntry(this, new HashMap());
    }

    String saveEntry(BlogEntry entry) throws BlogClientException {
        Blog.Collection col = (Blog.Collection)this.collections.get("entries");
        return col.saveEntry(entry);
    }

    public BlogEntry getEntry(String id) throws BlogClientException {
        try {
            Map result = (Map)this.getXmlRpcClient().execute("metaWeblog.getPost", new Object[]{id, this.userName, this.password});
            return new MetaWeblogEntry(this, result);
        }
        catch (Exception e) {
            throw new BlogClientException("ERROR: XML-RPC error getting entry", e);
        }
    }

    void deleteEntry(String id) throws BlogClientException {
        try {
            this.getXmlRpcClient().execute("blogger.deletePost", new Object[]{this.appkey, id, this.userName, this.password, Boolean.FALSE});
        }
        catch (Exception e) {
            throw new BlogClientException("ERROR: XML-RPC error getting entry", e);
        }
    }

    public Iterator getEntries() throws BlogClientException {
        return new EntryIterator();
    }

    public BlogResource newResource(String name, String contentType, byte[] bytes) throws BlogClientException {
        return new MetaWeblogResource(this, name, contentType, bytes);
    }

    String saveResource(MetaWeblogResource resource) throws BlogClientException {
        Blog.Collection col = (Blog.Collection)this.collections.get("resources");
        return col.saveResource(resource);
    }

    BlogResource getResource(String token) throws BlogClientException {
        return null;
    }

    public Iterator getResources() throws BlogClientException {
        return new NoOpIterator();
    }

    void deleteResource(BlogResource resource) throws BlogClientException {
    }

    public List getCategories() throws BlogClientException {
        ArrayList<BlogEntry.Category> ret = new ArrayList<BlogEntry.Category>();
        try {
            Object result = this.getXmlRpcClient().execute("metaWeblog.getCategories", new Object[]{this.blogid, this.userName, this.password});
            if (result != null && result instanceof HashMap) {
                Map catsmap = (Map)result;
                Iterator keys = catsmap.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    Map catmap = (Map)catsmap.get(key);
                    BlogEntry.Category category = new BlogEntry.Category(key);
                    category.setName((String)catmap.get("description"));
                    ret.add(category);
                }
            } else if (result != null && result instanceof Object[]) {
                Object[] resultArray = (Object[])result;
                for (int i = 0; i < resultArray.length; ++i) {
                    Map catmap = (Map)resultArray[i];
                    String categoryId = (String)catmap.get("categoryId");
                    String categoryName = (String)catmap.get("categoryName");
                    BlogEntry.Category category = new BlogEntry.Category(categoryId);
                    category.setName(categoryName);
                    ret.add(category);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private HashMap createPostStructure(BlogEntry entry) {
        return ((MetaWeblogEntry)entry).toPostStructure();
    }

    public List getCollections() throws BlogClientException {
        return new ArrayList(this.collections.values());
    }

    public Blog.Collection getCollection(String token) throws BlogClientException {
        return (Blog.Collection)this.collections.get(token);
    }

    public class NoOpIterator
    implements Iterator {
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    }

    public class EntryIterator
    implements Iterator {
        private int pos = 0;
        private boolean eod = false;
        private static final int BUFSIZE = 30;
        private List results = null;

        public EntryIterator() throws BlogClientException {
            this.getNextEntries();
        }

        public boolean hasNext() {
            if (this.pos == this.results.size() && !this.eod) {
                try {
                    this.getNextEntries();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.pos < this.results.size();
        }

        public Object next() {
            Map entryHash = (Map)this.results.get(this.pos++);
            return new MetaWeblogEntry(MetaWeblogBlog.this, entryHash);
        }

        public void remove() {
        }

        private void getNextEntries() throws BlogClientException {
            int requestSize = this.pos + 30;
            try {
                Object[] resultsArray = (Object[])MetaWeblogBlog.this.getXmlRpcClient().execute("metaWeblog.getRecentPosts", new Object[]{MetaWeblogBlog.this.blogid, MetaWeblogBlog.this.userName, MetaWeblogBlog.this.password, new Integer(requestSize)});
                this.results = Arrays.asList(resultsArray);
            }
            catch (Exception e) {
                throw new BlogClientException("ERROR: XML-RPC error getting entry", e);
            }
            if (this.results.size() < requestSize) {
                this.eod = true;
            }
        }
    }

    public class MetaWeblogBlogCollection
    implements Blog.Collection {
        private String accept = null;
        private String title = null;
        private String token = null;
        private Blog blog = null;

        public MetaWeblogBlogCollection(Blog blog, String token, String title, String accept) {
            this.blog = blog;
            this.accept = accept;
            this.title = title;
            this.token = token;
        }

        public String getTitle() {
            return this.title;
        }

        public String getToken() {
            return this.token;
        }

        public List getAccepts() {
            return Collections.singletonList(this.accept);
        }

        public BlogResource newResource(String name, String contentType, byte[] bytes) throws BlogClientException {
            return this.blog.newResource(name, contentType, bytes);
        }

        public BlogEntry newEntry() throws BlogClientException {
            return this.blog.newEntry();
        }

        public boolean accepts(String ct) {
            if (this.accept.equals("*")) {
                return true;
            }
            return this.accept.equals("entry") && ct.equals("application/metaweblog+xml");
        }

        public Iterator getEntries() throws BlogClientException {
            Iterator ret = null;
            ret = this.accept.equals("entry") ? MetaWeblogBlog.this.getEntries() : MetaWeblogBlog.this.getResources();
            return ret;
        }

        public String saveEntry(BlogEntry entry) throws BlogClientException {
            String ret = entry.getId();
            if (entry.getId() == null) {
                try {
                    ret = (String)MetaWeblogBlog.this.getXmlRpcClient().execute("metaWeblog.newPost", new Object[]{MetaWeblogBlog.this.blogid, MetaWeblogBlog.this.userName, MetaWeblogBlog.this.password, MetaWeblogBlog.this.createPostStructure(entry), new Boolean(!entry.getDraft())});
                }
                catch (Exception e) {
                    throw new BlogClientException("ERROR: XML-RPC error saving new entry", e);
                }
            }
            try {
                MetaWeblogBlog.this.getXmlRpcClient().execute("metaWeblog.editPost", new Object[]{entry.getId(), MetaWeblogBlog.this.userName, MetaWeblogBlog.this.password, MetaWeblogBlog.this.createPostStructure(entry), new Boolean(!entry.getDraft())});
            }
            catch (Exception e) {
                throw new BlogClientException("ERROR: XML-RPC error updating entry", e);
            }
            return ret;
        }

        public String saveResource(BlogResource res) throws BlogClientException {
            MetaWeblogResource resource = (MetaWeblogResource)res;
            try {
                HashMap<String, Object> resmap = new HashMap<String, Object>();
                resmap.put("name", resource.getName());
                resmap.put("type", resource.getContent().getType());
                resmap.put("bits", resource.getBytes());
                Map result = (Map)MetaWeblogBlog.this.getXmlRpcClient().execute("metaWeblog.newMediaObject", new Object[]{MetaWeblogBlog.this.blogid, MetaWeblogBlog.this.userName, MetaWeblogBlog.this.password, resmap});
                String url = (String)result.get("url");
                res.getContent().setSrc(url);
                return url;
            }
            catch (Exception e) {
                throw new BlogClientException("ERROR: loading or uploading file", e);
            }
        }

        public List getCategories() throws BlogClientException {
            return MetaWeblogBlog.this.getCategories();
        }

        public Blog getBlog() {
            return this.blog;
        }
    }
}

