/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.blogclient.metaweblog;

import com.sun.syndication.propono.blogclient.Blog;
import com.sun.syndication.propono.blogclient.BlogClientException;
import com.sun.syndication.propono.blogclient.BlogConnection;
import com.sun.syndication.propono.blogclient.metaweblog.MetaWeblogBlog;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class MetaWeblogConnection
implements BlogConnection {
    private URL url = null;
    private String userName = null;
    private String password = null;
    private String appkey = "null";
    private Map blogs = null;
    private XmlRpcClient xmlRpcClient = null;

    public MetaWeblogConnection(String url, String userName, String password) throws BlogClientException {
        this.userName = userName;
        this.password = password;
        try {
            this.url = new URL(url);
            this.blogs = this.createBlogMap();
        }
        catch (Throwable t) {
            throw new BlogClientException("ERROR connecting to server", t);
        }
    }

    private XmlRpcClient getXmlRpcClient() {
        if (this.xmlRpcClient == null) {
            XmlRpcClientConfigImpl xmlrpcConfig = new XmlRpcClientConfigImpl();
            xmlrpcConfig.setServerURL(this.url);
            this.xmlRpcClient = new XmlRpcClient();
            this.xmlRpcClient.setConfig((XmlRpcClientConfig)xmlrpcConfig);
        }
        return this.xmlRpcClient;
    }

    public List getBlogs() {
        return new ArrayList(this.blogs.values());
    }

    private Map createBlogMap() throws XmlRpcException, IOException {
        HashMap<String, MetaWeblogBlog> blogMap = new HashMap<String, MetaWeblogBlog>();
        Object[] results = (Object[])this.getXmlRpcClient().execute("blogger.getUsersBlogs", new Object[]{this.appkey, this.userName, this.password});
        for (int i = 0; i < results.length; ++i) {
            Map blog = (Map)results[i];
            String blogid = (String)blog.get("blogid");
            String name = (String)blog.get("blogName");
            blogMap.put(blogid, new MetaWeblogBlog(blogid, name, this.url, this.userName, this.password));
        }
        return blogMap;
    }

    public Blog getBlog(String token) {
        return (Blog)this.blogs.get(token);
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }
}

