/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.id.serial;

import org.apache.commons.id.serial.AlphanumericGenerator;

public class PrefixedAlphanumericGenerator
extends AlphanumericGenerator {
    private final String prefix;

    public PrefixedAlphanumericGenerator(String prefix, boolean wrap, int size) {
        super(wrap, size - (prefix == null ? 0 : prefix.length()));
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        if (size <= prefix.length()) {
            throw new IllegalArgumentException("size less prefix length must be at least one");
        }
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public long maxLength() {
        return super.maxLength() + (long)this.prefix.length();
    }

    public long minLength() {
        return super.minLength() + (long)this.prefix.length();
    }

    public int getSize() {
        return super.getSize() + this.prefix.length();
    }

    public String nextStringIdentifier() {
        StringBuffer sb = new StringBuffer(this.prefix);
        sb.append(super.nextStringIdentifier());
        return sb.toString();
    }
}

