/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.id.uuid.state;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.id.uuid.state.Node;
import org.apache.commons.id.uuid.state.State;
import org.apache.commons.id.uuid.state.StateHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ReadOnlyResourceStateImpl
implements State {
    static long synchronizeInterval = Long.MAX_VALUE;
    static HashSet nodes = new HashSet();
    public static final String CONFIG_FILENAME_KEY = "org.apache.commons.id.uuid.config.resource.filename";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws Exception {
        String resourceName = System.getProperty(CONFIG_FILENAME_KEY);
        if (resourceName == null) {
            throw new IllegalStateException("No value set for system property: org.apache.commons.id.uuid.config.resource.filename");
        }
        InputStream in = null;
        try {
            in = ClassLoader.getSystemResourceAsStream(resourceName);
            if (in == null) {
                throw new IllegalStateException(resourceName + " loaded as system resource is null");
            }
            this.parse(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public long getSynchInterval() {
        return Long.MAX_VALUE;
    }

    public Set getNodes() {
        return nodes;
    }

    public void store(Set nodeSet) throws IOException {
    }

    public void store(Set nodeSet, long timestamp) {
    }

    protected void parse(InputStream in) throws Exception {
        StateConfigHandler handler = new StateConfigHandler();
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setValidating(true);
        SAXParser parser = saxFactory.newSAXParser();
        parser.parse(in, (DefaultHandler)handler);
    }

    class StateConfigHandler
    extends DefaultHandler {
        static final short UUID_STATE_TAG = 1;
        static final String UUID_STATE_TAG_STR = "uuidstate";
        static final String SYNCH_INTERVAL_STR = "synchinterval";
        static final short NODE_TAG = 2;
        static final String NODE_TAG_STR = "node";
        static final String ATTR_ID_STR = "id";
        static final String ATTR_CLOCKSEQ_STR = "clocksequence";
        static final String ATTR_LASTIMESTAMP_STR = "timestamp";

        StateConfigHandler() {
        }

        public void startElement(String namespaceURI, String simpleName, String qualifiedName, Attributes attributes) throws SAXException {
            int currentTag = 0;
            String element = simpleName;
            if ("".equals(simpleName)) {
                element = qualifiedName;
            }
            if (element.equalsIgnoreCase(UUID_STATE_TAG_STR)) {
                currentTag = 1;
            } else if (element.equalsIgnoreCase(NODE_TAG_STR)) {
                currentTag = 2;
            }
            if (attributes != null) {
                switch (currentTag) {
                    case 1: {
                        this.processBodyTag(attributes);
                        break;
                    }
                    case 2: {
                        this.processNodeTag(attributes);
                        break;
                    }
                }
            }
        }

        private void processBodyTag(Attributes attributes) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attributeName = attributes.getLocalName(i);
                if ("".equals(attributeName)) {
                    attributeName = attributes.getQName(i);
                }
                String attributeValue = attributes.getValue(i);
                if (!attributeName.equalsIgnoreCase(SYNCH_INTERVAL_STR)) continue;
                try {
                    synchronizeInterval = Long.parseLong(attributeValue);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    synchronizeInterval = 0L;
                }
            }
        }

        private void processNodeTag(Attributes attributes) {
            byte[] node = null;
            long lastTS = 0L;
            short lastClockSeq = 0;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attributeName = attributes.getLocalName(i);
                if ("".equals(attributeName)) {
                    attributeName = attributes.getQName(i);
                }
                String attributeValue = attributes.getValue(i);
                if (attributeName.equalsIgnoreCase(ATTR_ID_STR)) {
                    node = StateHelper.decodeMACAddress(attributeValue);
                    continue;
                }
                if (attributeName.equalsIgnoreCase(ATTR_CLOCKSEQ_STR)) {
                    try {
                        lastClockSeq = Short.parseShort(attributeValue);
                    }
                    catch (NumberFormatException nfe) {
                        lastClockSeq = 0;
                    }
                    continue;
                }
                if (!attributeName.equalsIgnoreCase(ATTR_LASTIMESTAMP_STR)) continue;
                try {
                    lastTS = Long.parseLong(attributeValue);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    lastTS = 0L;
                }
            }
            if (node != null) {
                if (lastClockSeq != 0) {
                    nodes.add(new Node(node, lastTS, lastClockSeq));
                } else {
                    nodes.add(new Node(node));
                }
            }
        }
    }
}

