/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components.template;

import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.struts2.components.template.Template;
import org.apache.struts2.components.template.TemplateEngine;

public class TemplateEngineManager {
    public static final String DEFAULT_TEMPLATE_TYPE_CONFIG_KEY = "struts.ui.templateSuffix";
    public static final String DEFAULT_TEMPLATE_TYPE = "ftl";
    Map<String, EngineFactory> templateEngines = new HashMap<String, EngineFactory>();
    Container container;
    String defaultTemplateType;

    @Inject(value="struts.ui.templateSuffix")
    public void setDefaultTemplateType(String type) {
        this.defaultTemplateType = type;
    }

    @Inject
    public void setContainer(Container container) {
        this.container = container;
        HashMap<String, LazyEngineFactory> map = new HashMap<String, LazyEngineFactory>();
        Set prefixes = container.getInstanceNames(TemplateEngine.class);
        for (String prefix : prefixes) {
            map.put(prefix, new LazyEngineFactory(prefix));
        }
        this.templateEngines = Collections.unmodifiableMap(map);
    }

    public void registerTemplateEngine(String templateExtension, final TemplateEngine templateEngine) {
        this.templateEngines.put(templateExtension, new EngineFactory(){

            public TemplateEngine create() {
                return templateEngine;
            }
        });
    }

    public TemplateEngine getTemplateEngine(Template template, String templateTypeOverride) {
        String templateType = DEFAULT_TEMPLATE_TYPE;
        String templateName = template.toString();
        if (templateName.indexOf(".") > 0) {
            templateType = templateName.substring(templateName.indexOf(".") + 1);
        } else if (templateTypeOverride != null && templateTypeOverride.length() > 0) {
            templateType = templateTypeOverride;
        } else {
            String type = this.defaultTemplateType;
            if (type != null) {
                templateType = type;
            }
        }
        return this.templateEngines.get(templateType).create();
    }

    class LazyEngineFactory
    implements EngineFactory {
        private String name;

        public LazyEngineFactory(String name) {
            this.name = name;
        }

        public TemplateEngine create() {
            TemplateEngine engine = (TemplateEngine)TemplateEngineManager.this.container.getInstance(TemplateEngine.class, this.name);
            if (engine == null) {
                throw new ConfigurationException("Unable to locate template engine: " + this.name);
            }
            return engine;
        }
    }

    static interface EngineFactory {
        public TemplateEngine create();
    }
}

