/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import com.opensymphony.xwork2.ActionInvocation;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.StrutsResultSupport;

public class StreamResult
extends StrutsResultSupport {
    private static final long serialVersionUID = -1468409635999059850L;
    protected static final Log log = LogFactory.getLog(StreamResult.class);
    public static final String DEFAULT_PARAM = "inputName";
    protected String contentType = "text/plain";
    protected String contentLength;
    protected String contentDisposition = "inline";
    protected String inputName = "inputStream";
    protected InputStream inputStream;
    protected int bufferSize = 1024;

    public StreamResult() {
    }

    public StreamResult(InputStream in) {
        this.inputStream = in;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(String contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        OutputStream oOutput = null;
        try {
            int iSize;
            if (this.inputStream == null) {
                this.inputStream = (InputStream)invocation.getStack().findValue(this.conditionalParse(this.inputName, invocation));
            }
            if (this.inputStream == null) {
                String msg = "Can not find a java.io.InputStream with the name [" + this.inputName + "] in the invocation stack. " + "Check the <param name=\"inputName\"> tag specified for this action.";
                log.error((Object)msg);
                throw new IllegalArgumentException(msg);
            }
            HttpServletResponse oResponse = (HttpServletResponse)invocation.getInvocationContext().get((Object)"com.opensymphony.xwork2.dispatcher.HttpServletResponse");
            oResponse.setContentType(this.conditionalParse(this.contentType, invocation));
            if (this.contentLength != null) {
                String _contentLength = this.conditionalParse(this.contentLength, invocation);
                int _contentLengthAsInt = -1;
                try {
                    _contentLengthAsInt = Integer.parseInt(_contentLength);
                    if (_contentLengthAsInt >= 0) {
                        oResponse.setContentLength(_contentLengthAsInt);
                    }
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("failed to recongnize " + _contentLength + " as a number, contentLength header will not be set"), (Throwable)e);
                }
            }
            if (this.contentDisposition != null) {
                oResponse.addHeader("Content-disposition", this.conditionalParse(this.contentDisposition, invocation));
            }
            oOutput = oResponse.getOutputStream();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Streaming result [" + this.inputName + "] type=[" + this.contentType + "] length=[" + this.contentLength + "] content-disposition=[" + this.contentDisposition + "]"));
            }
            log.debug((Object)"Streaming to output buffer +++ START +++");
            byte[] oBuff = new byte[this.bufferSize];
            while (-1 != (iSize = this.inputStream.read(oBuff))) {
                oOutput.write(oBuff, 0, iSize);
            }
            log.debug((Object)"Streaming to output buffer +++ END +++");
            oOutput.flush();
        }
        finally {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (oOutput != null) {
                oOutput.close();
            }
        }
    }
}

