/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.mapper;

import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.RequestUtils;
import org.apache.struts2.dispatcher.ServletRedirectResult;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.util.PrefixTrie;

public class DefaultActionMapper
implements ActionMapper {
    static final String METHOD_PREFIX = "method:";
    static final String ACTION_PREFIX = "action:";
    static final String REDIRECT_PREFIX = "redirect:";
    static final String REDIRECT_ACTION_PREFIX = "redirect-action:";
    private boolean allowDynamicMethodCalls = true;
    private boolean allowSlashesInActionNames = false;
    private boolean alwaysSelectFullNamespace = false;
    private PrefixTrie prefixTrie = null;
    List extensions = new ArrayList(){
        {
            this.add("action");
        }
    };
    private Container container;

    public DefaultActionMapper() {
        this.prefixTrie = new PrefixTrie(){
            {
                this.put(DefaultActionMapper.METHOD_PREFIX, new ParameterAction(){

                    public void execute(String key, ActionMapping mapping) {
                        mapping.setMethod(key.substring(DefaultActionMapper.METHOD_PREFIX.length()));
                    }
                });
                this.put(DefaultActionMapper.ACTION_PREFIX, new ParameterAction(){

                    public void execute(String key, ActionMapping mapping) {
                        int bang;
                        String name = key.substring(DefaultActionMapper.ACTION_PREFIX.length());
                        if (DefaultActionMapper.this.allowDynamicMethodCalls && (bang = name.indexOf(33)) != -1) {
                            String method = name.substring(bang + 1);
                            mapping.setMethod(method);
                            name = name.substring(0, bang);
                        }
                        mapping.setName(name);
                    }
                });
                this.put(DefaultActionMapper.REDIRECT_PREFIX, new ParameterAction(){

                    public void execute(String key, ActionMapping mapping) {
                        ServletRedirectResult redirect = new ServletRedirectResult();
                        DefaultActionMapper.this.container.inject((Object)redirect);
                        redirect.setLocation(key.substring(DefaultActionMapper.REDIRECT_PREFIX.length()));
                        mapping.setResult(redirect);
                    }
                });
                this.put(DefaultActionMapper.REDIRECT_ACTION_PREFIX, new ParameterAction(){

                    public void execute(String key, ActionMapping mapping) {
                        String location = key.substring(DefaultActionMapper.REDIRECT_ACTION_PREFIX.length());
                        ServletRedirectResult redirect = new ServletRedirectResult();
                        DefaultActionMapper.this.container.inject((Object)redirect);
                        String extension = DefaultActionMapper.this.getDefaultExtension();
                        if (extension != null) {
                            location = location + "." + extension;
                        }
                        redirect.setLocation(location);
                        mapping.setResult(redirect);
                    }
                });
            }
        };
    }

    @Inject(value="struts.enable.DynamicMethodInvocation")
    public void setAllowDynamicMethodCalls(String allow) {
        this.allowDynamicMethodCalls = "true".equals(allow);
    }

    @Inject(value="struts.enable.SlashesInActionNames")
    public void setSlashesInActionNames(String allow) {
        this.allowSlashesInActionNames = "true".equals(allow);
    }

    @Inject(value="struts.mapper.alwaysSelectFullNamespace")
    public void setAlwaysSelectFullNamespace(String val) {
        this.alwaysSelectFullNamespace = "true".equals(val);
    }

    @Inject
    public void setContainer(Container container) {
        this.container = container;
    }

    public ActionMapping getMapping(HttpServletRequest request, ConfigurationManager configManager) {
        String name;
        int exclamation;
        ActionMapping mapping = new ActionMapping();
        String uri = this.getUri(request);
        if ((uri = this.dropExtension(uri)) == null) {
            return null;
        }
        this.parseNameAndNamespace(uri, mapping, configManager);
        this.handleSpecialParameters(request, mapping);
        if (mapping.getName() == null) {
            return null;
        }
        if (this.allowDynamicMethodCalls && (exclamation = (name = mapping.getName()).lastIndexOf("!")) != -1) {
            mapping.setName(name.substring(0, exclamation));
            mapping.setMethod(name.substring(exclamation + 1));
        }
        return mapping;
    }

    public void handleSpecialParameters(HttpServletRequest request, ActionMapping mapping) {
        HashSet<String> uniqueParameters = new HashSet<String>();
        Map parameterMap = request.getParameterMap();
        for (String key : parameterMap.keySet()) {
            ParameterAction parameterAction;
            if (key.endsWith(".x") || key.endsWith(".y")) {
                key = key.substring(0, key.length() - 2);
            }
            if (uniqueParameters.contains(key) || (parameterAction = (ParameterAction)this.prefixTrie.get(key)) == null) continue;
            parameterAction.execute(key, mapping);
            uniqueParameters.add(key);
            break;
        }
    }

    void parseNameAndNamespace(String uri, ActionMapping mapping, ConfigurationManager configManager) {
        int pos;
        String name;
        String namespace;
        int lastSlash = uri.lastIndexOf("/");
        if (lastSlash == -1) {
            namespace = "";
            name = uri;
        } else if (lastSlash == 0) {
            namespace = "/";
            name = uri.substring(lastSlash + 1);
        } else if (this.alwaysSelectFullNamespace) {
            namespace = uri.substring(0, lastSlash);
            name = uri.substring(lastSlash + 1);
        } else {
            Configuration config = configManager.getConfiguration();
            String prefix = uri.substring(0, lastSlash);
            namespace = "";
            Iterator i = config.getPackageConfigs().values().iterator();
            while (i.hasNext()) {
                String ns = ((PackageConfig)i.next()).getNamespace();
                if (ns == null || !prefix.startsWith(ns) || prefix.length() != ns.length() && prefix.charAt(ns.length()) != '/' || ns.length() <= namespace.length()) continue;
                namespace = ns;
            }
            name = uri.substring(namespace.length() + 1);
        }
        if (!this.allowSlashesInActionNames && name != null && (pos = name.lastIndexOf(47)) > -1 && pos < name.length() - 1) {
            name = name.substring(pos + 1);
        }
        mapping.setNamespace(namespace);
        mapping.setName(name);
    }

    String dropExtension(String name) {
        if (this.extensions == null) {
            return name;
        }
        Iterator it = this.extensions.iterator();
        while (it.hasNext()) {
            String extension = "." + (String)it.next();
            if (!name.endsWith(extension)) continue;
            name = name.substring(0, name.length() - extension.length());
            return name;
        }
        return null;
    }

    String getDefaultExtension() {
        if (this.extensions == null) {
            return null;
        }
        return (String)this.extensions.get(0);
    }

    @Inject(value="struts.action.extension")
    public void setExtensions(String extensions) {
        this.extensions = !"".equals(extensions) ? Arrays.asList(extensions.split(",")) : null;
    }

    String getUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (uri != null) {
            return uri;
        }
        uri = RequestUtils.getServletPath(request);
        if (uri != null && !"".equals(uri)) {
            return uri;
        }
        uri = request.getRequestURI();
        return uri.substring(request.getContextPath().length());
    }

    public String getUriFromActionMapping(ActionMapping mapping) {
        String extension;
        StringBuffer uri = new StringBuffer();
        uri.append(mapping.getNamespace());
        if (!"/".equals(mapping.getNamespace())) {
            uri.append("/");
        }
        String name = mapping.getName();
        String params = "";
        if (name.indexOf(63) != -1) {
            params = name.substring(name.indexOf(63));
            name = name.substring(0, name.indexOf(63));
        }
        uri.append(name);
        if (null != mapping.getMethod() && !"".equals(mapping.getMethod())) {
            uri.append("!").append(mapping.getMethod());
        }
        if ((extension = this.getDefaultExtension()) != null && uri.indexOf('.' + extension) == -1) {
            uri.append(".").append(extension);
            if (params.length() > 0) {
                uri.append(params);
            }
        }
        return uri.toString();
    }

    public boolean isSlashesInActionNames() {
        return this.allowSlashesInActionNames;
    }

    static interface ParameterAction {
        public void execute(String var1, ActionMapping var2);
    }
}

