/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.synd;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.impl.CopyFromHelper;
import com.sun.syndication.feed.impl.ObjectBean;
import com.sun.syndication.feed.module.DCModule;
import com.sun.syndication.feed.module.DCModuleImpl;
import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.impl.ModuleUtils;
import com.sun.syndication.feed.synd.Converter;
import com.sun.syndication.feed.synd.SyndCategoryListFacade;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndImage;
import com.sun.syndication.feed.synd.impl.Converters;
import com.sun.syndication.feed.synd.impl.URINormalizer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SyndFeedImpl
implements Serializable,
SyndFeed {
    private ObjectBean _objBean;
    private String _encoding;
    private String _uri;
    private SyndContent _title;
    private SyndContent _description;
    private String _feedType;
    private String _link;
    private List _links;
    private SyndImage _image;
    private List _entries;
    private List _modules;
    private List _authors;
    private List _contributors;
    private List _foreignMarkup;
    private static final Converters CONVERTERS = new Converters();
    private static final Set IGNORE_PROPERTIES = new HashSet();
    public static final Set CONVENIENCE_PROPERTIES = Collections.unmodifiableSet(IGNORE_PROPERTIES);
    private static final CopyFromHelper COPY_FROM_HELPER;
    static /* synthetic */ Class class$com$sun$syndication$feed$synd$SyndFeed;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$syndication$feed$synd$SyndImage;
    static /* synthetic */ Class class$com$sun$syndication$feed$synd$SyndEntry;
    static /* synthetic */ Class class$com$sun$syndication$feed$module$Module;
    static /* synthetic */ Class class$com$sun$syndication$feed$synd$SyndEntryImpl;
    static /* synthetic */ Class class$com$sun$syndication$feed$synd$SyndImageImpl;
    static /* synthetic */ Class class$com$sun$syndication$feed$module$DCModule;
    static /* synthetic */ Class class$com$sun$syndication$feed$module$DCModuleImpl;
    static /* synthetic */ Class class$com$sun$syndication$feed$module$SyModule;
    static /* synthetic */ Class class$com$sun$syndication$feed$module$SyModuleImpl;

    public List getSupportedFeedTypes() {
        return CONVERTERS.getSupportedFeedTypes();
    }

    protected SyndFeedImpl(Class beanClass, Set convenienceProperties) {
        this._objBean = new ObjectBean(beanClass, this, convenienceProperties);
    }

    public SyndFeedImpl() {
        this(null);
    }

    public SyndFeedImpl(WireFeed feed) {
        this(class$com$sun$syndication$feed$synd$SyndFeed == null ? (class$com$sun$syndication$feed$synd$SyndFeed = SyndFeedImpl.class$("com.sun.syndication.feed.synd.SyndFeed")) : class$com$sun$syndication$feed$synd$SyndFeed, IGNORE_PROPERTIES);
        if (feed != null) {
            this._feedType = feed.getFeedType();
            Converter converter = CONVERTERS.getConverter(this._feedType);
            if (converter == null) {
                throw new IllegalArgumentException("Invalid feed type [" + this._feedType + "]");
            }
            converter.copyInto(feed, this);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return this._objBean.clone();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        Object fm = this.getForeignMarkup();
        this.setForeignMarkup(((SyndFeedImpl)other).getForeignMarkup());
        boolean ret = this._objBean.equals(other);
        this.setForeignMarkup(fm);
        return ret;
    }

    public int hashCode() {
        return this._objBean.hashCode();
    }

    public String toString() {
        return this._objBean.toString();
    }

    public WireFeed createWireFeed() {
        return this.createWireFeed(this._feedType);
    }

    public WireFeed createWireFeed(String feedType) {
        if (feedType == null) {
            throw new IllegalArgumentException("Feed type cannot be null");
        }
        Converter converter = CONVERTERS.getConverter(feedType);
        if (converter == null) {
            throw new IllegalArgumentException("Invalid feed type [" + feedType + "]");
        }
        return converter.createRealFeed(this);
    }

    public String getFeedType() {
        return this._feedType;
    }

    public void setFeedType(String feedType) {
        this._feedType = feedType;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public String getUri() {
        return this._uri;
    }

    public void setUri(String uri) {
        this._uri = URINormalizer.normalize(uri);
    }

    public String getTitle() {
        if (this._title != null) {
            return this._title.getValue();
        }
        return null;
    }

    public void setTitle(String title) {
        if (this._title == null) {
            this._title = new SyndContentImpl();
        }
        this._title.setValue(title);
    }

    public SyndContent getTitleEx() {
        return this._title;
    }

    public void setTitleEx(SyndContent title) {
        this._title = title;
    }

    public String getLink() {
        return this._link;
    }

    public void setLink(String link) {
        this._link = link;
    }

    public String getDescription() {
        if (this._description != null) {
            return this._description.getValue();
        }
        return null;
    }

    public void setDescription(String description) {
        if (this._description == null) {
            this._description = new SyndContentImpl();
        }
        this._description.setValue(description);
    }

    public SyndContent getDescriptionEx() {
        return this._description;
    }

    public void setDescriptionEx(SyndContent description) {
        this._description = description;
    }

    public Date getPublishedDate() {
        return this.getDCModule().getDate();
    }

    public void setPublishedDate(Date publishedDate) {
        this.getDCModule().setDate(publishedDate);
    }

    public String getCopyright() {
        return this.getDCModule().getRights();
    }

    public void setCopyright(String copyright) {
        this.getDCModule().setRights(copyright);
    }

    public SyndImage getImage() {
        return this._image;
    }

    public void setImage(SyndImage image) {
        this._image = image;
    }

    public List getCategories() {
        return new SyndCategoryListFacade(this.getDCModule().getSubjects());
    }

    public void setCategories(List categories) {
        this.getDCModule().setSubjects(SyndCategoryListFacade.convertElementsSyndCategoryToSubject(categories));
    }

    public List getEntries() {
        return this._entries == null ? (this._entries = new ArrayList()) : this._entries;
    }

    public void setEntries(List entries) {
        this._entries = entries;
    }

    public String getLanguage() {
        return this.getDCModule().getLanguage();
    }

    public void setLanguage(String language) {
        this.getDCModule().setLanguage(language);
    }

    public List getModules() {
        if (this._modules == null) {
            this._modules = new ArrayList();
        }
        if (ModuleUtils.getModule(this._modules, "http://purl.org/dc/elements/1.1/") == null) {
            this._modules.add(new DCModuleImpl());
        }
        return this._modules;
    }

    public void setModules(List modules) {
        this._modules = modules;
    }

    public Module getModule(String uri) {
        return ModuleUtils.getModule(this.getModules(), uri);
    }

    private DCModule getDCModule() {
        return (DCModule)this.getModule("http://purl.org/dc/elements/1.1/");
    }

    public Class getInterface() {
        return class$com$sun$syndication$feed$synd$SyndFeed == null ? (class$com$sun$syndication$feed$synd$SyndFeed = SyndFeedImpl.class$("com.sun.syndication.feed.synd.SyndFeed")) : class$com$sun$syndication$feed$synd$SyndFeed;
    }

    public void copyFrom(Object obj) {
        COPY_FROM_HELPER.copy(this, obj);
    }

    public List getLinks() {
        return this._links;
    }

    public void setLinks(List links) {
        this._links = links;
    }

    public List getAuthors() {
        return this._authors;
    }

    public void setAuthors(List authors) {
        this._authors = authors;
    }

    public String getAuthor() {
        return this.getDCModule().getCreator();
    }

    public void setAuthor(String author) {
        this.getDCModule().setCreator(author);
    }

    public List getContributors() {
        return this._contributors;
    }

    public void setContributors(List contributors) {
        this._contributors = contributors;
    }

    public Object getForeignMarkup() {
        return this._foreignMarkup == null ? (this._foreignMarkup = new ArrayList()) : this._foreignMarkup;
    }

    public void setForeignMarkup(Object foreignMarkup) {
        this._foreignMarkup = (List)foreignMarkup;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        IGNORE_PROPERTIES.add("publishedDate");
        IGNORE_PROPERTIES.add("author");
        IGNORE_PROPERTIES.add("copyright");
        IGNORE_PROPERTIES.add("categories");
        IGNORE_PROPERTIES.add("language");
        HashMap<String, Class> basePropInterfaceMap = new HashMap<String, Class>();
        basePropInterfaceMap.put("feedType", class$java$lang$String == null ? (class$java$lang$String = SyndFeedImpl.class$("java.lang.String")) : class$java$lang$String);
        basePropInterfaceMap.put("encoding", class$java$lang$String == null ? (class$java$lang$String = SyndFeedImpl.class$("java.lang.String")) : class$java$lang$String);
        basePropInterfaceMap.put("uri", class$java$lang$String == null ? (class$java$lang$String = SyndFeedImpl.class$("java.lang.String")) : class$java$lang$String);
        basePropInterfaceMap.put("title", class$java$lang$String == null ? (class$java$lang$String = SyndFeedImpl.class$("java.lang.String")) : class$java$lang$String);
        basePropInterfaceMap.put("link", class$java$lang$String == null ? (class$java$lang$String = SyndFeedImpl.class$("java.lang.String")) : class$java$lang$String);
        basePropInterfaceMap.put("description", class$java$lang$String == null ? (class$java$lang$String = SyndFeedImpl.class$("java.lang.String")) : class$java$lang$String);
        basePropInterfaceMap.put("image", class$com$sun$syndication$feed$synd$SyndImage == null ? (class$com$sun$syndication$feed$synd$SyndImage = SyndFeedImpl.class$("com.sun.syndication.feed.synd.SyndImage")) : class$com$sun$syndication$feed$synd$SyndImage);
        basePropInterfaceMap.put("entries", class$com$sun$syndication$feed$synd$SyndEntry == null ? (class$com$sun$syndication$feed$synd$SyndEntry = SyndFeedImpl.class$("com.sun.syndication.feed.synd.SyndEntry")) : class$com$sun$syndication$feed$synd$SyndEntry);
        basePropInterfaceMap.put("modules", class$com$sun$syndication$feed$module$Module == null ? (class$com$sun$syndication$feed$module$Module = SyndFeedImpl.class$("com.sun.syndication.feed.module.Module")) : class$com$sun$syndication$feed$module$Module);
        HashMap<Class, Class> basePropClassImplMap = new HashMap<Class, Class>();
        basePropClassImplMap.put(class$com$sun$syndication$feed$synd$SyndEntry == null ? (class$com$sun$syndication$feed$synd$SyndEntry = SyndFeedImpl.class$("com.sun.syndication.feed.synd.SyndEntry")) : class$com$sun$syndication$feed$synd$SyndEntry, class$com$sun$syndication$feed$synd$SyndEntryImpl == null ? (class$com$sun$syndication$feed$synd$SyndEntryImpl = SyndFeedImpl.class$("com.sun.syndication.feed.synd.SyndEntryImpl")) : class$com$sun$syndication$feed$synd$SyndEntryImpl);
        basePropClassImplMap.put(class$com$sun$syndication$feed$synd$SyndImage == null ? (class$com$sun$syndication$feed$synd$SyndImage = SyndFeedImpl.class$("com.sun.syndication.feed.synd.SyndImage")) : class$com$sun$syndication$feed$synd$SyndImage, class$com$sun$syndication$feed$synd$SyndImageImpl == null ? (class$com$sun$syndication$feed$synd$SyndImageImpl = SyndFeedImpl.class$("com.sun.syndication.feed.synd.SyndImageImpl")) : class$com$sun$syndication$feed$synd$SyndImageImpl);
        basePropClassImplMap.put(class$com$sun$syndication$feed$module$DCModule == null ? (class$com$sun$syndication$feed$module$DCModule = SyndFeedImpl.class$("com.sun.syndication.feed.module.DCModule")) : class$com$sun$syndication$feed$module$DCModule, class$com$sun$syndication$feed$module$DCModuleImpl == null ? (class$com$sun$syndication$feed$module$DCModuleImpl = SyndFeedImpl.class$("com.sun.syndication.feed.module.DCModuleImpl")) : class$com$sun$syndication$feed$module$DCModuleImpl);
        basePropClassImplMap.put(class$com$sun$syndication$feed$module$SyModule == null ? (class$com$sun$syndication$feed$module$SyModule = SyndFeedImpl.class$("com.sun.syndication.feed.module.SyModule")) : class$com$sun$syndication$feed$module$SyModule, class$com$sun$syndication$feed$module$SyModuleImpl == null ? (class$com$sun$syndication$feed$module$SyModuleImpl = SyndFeedImpl.class$("com.sun.syndication.feed.module.SyModuleImpl")) : class$com$sun$syndication$feed$module$SyModuleImpl);
        COPY_FROM_HELPER = new CopyFromHelper(class$com$sun$syndication$feed$synd$SyndFeed == null ? (class$com$sun$syndication$feed$synd$SyndFeed = SyndFeedImpl.class$("com.sun.syndication.feed.synd.SyndFeed")) : class$com$sun$syndication$feed$synd$SyndFeed, basePropInterfaceMap, basePropClassImplMap);
    }
}

