/*
 * Decompiled with CFR 0.152.
 */
package net.sf.textile4j;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.textile4j.TextileConstants;

public class Textile
implements TextileConstants {
    public final String process(String origionalContent) {
        String content = origionalContent;
        content = content.replaceAll("&(?![#a-zA-Z0-9]+;)", "x%x%");
        content = Textile.replace(content, "&gt;", ">");
        content = Textile.replace(content, "&lt;", "<");
        content = Textile.replace(content, "&amp;", "&");
        content = Textile.replace(content, "\r\n", "\n");
        content = Textile.replace(content, "\t", "");
        content = Textile.replace(content, "\n\n", "\n \n");
        StringBuffer splitBuffer = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(content, "\n", false);
        while (tokenizer.hasMoreTokens()) {
            splitBuffer.append(tokenizer.nextToken().trim());
            splitBuffer.append("\n");
        }
        content = splitBuffer.toString();
        content = content.replaceAll("(^|\\s)==(.*)==([^[:alnum:]]{0,2})(\\s|$)", "$1<notextile>$2</notextile>$3$4");
        content = content.replaceAll("!([^\\s\\(=^!]+?)\\s?(\\(([^\\)]+?)\\))?!", "<img src=\"$1\" alt=\"$3\" />");
        content = content.replaceAll("(<img.+ \\/>):(\\S+)", "<a href=\"$2\">$1</a>");
        content = content.replaceAll("\"([^\"\\(]+)\\s?(\\(([^\\)]+)\\))?\":(\\S+)(\\/?)(\\.)?([^\\w\\s\\/;]|[1-9]*?)(\\s|$)", "<a href=\\\"$4\\\" title=\\\"$3\\\">$1</a>");
        for (int x = 0; x < TextileConstants.EXP_PHRASE_MODIFIER_SOURCETAGS.length; ++x) {
            String prefix = "(^|\\s|>)" + TextileConstants.EXP_PHRASE_MODIFIER_SOURCETAGS[x] + "(.+?)([^\\w\\s]*?)" + TextileConstants.EXP_PHRASE_MODIFIER_SOURCETAGS[x];
            String suffix = "$1<" + TextileConstants.EXP_PHRASE_MODIFIER_REPLACETAGS[x] + ">$2$3</" + TextileConstants.EXP_PHRASE_MODIFIER_REPLACETAGS[x] + ">";
            content = content.replaceAll(prefix, suffix);
        }
        content = content.replaceAll("(^|\\s)__(.*?)__([^\\w\\s]{0,2})(\\s|$)?", "$1<i>$2</i>$4");
        content = content.replaceAll("(^|\\s)_(.*?)_([^\\w\\s]{0,2})(\\s|$)?", "$1<em>$2</em>$4");
        content = content.replaceAll("(^|\\s)\\^(.*?)\\^(\\s|$)?", "$1<sup>$2</sup>$3");
        content = content.replaceAll("\"$", " ");
        String[] glyphMatches = new String[]{"\"([^\\\\']*)\\\\'([^\\\\']*)\"", "\\'", "([^\\']*)\\\"([^\\\"]*)", "\"", "\\b( )?\\.{3}", "\\b([A-Z][A-Z0-9]{2,})\\b(\\(([^\\)]+)\\))", "(^|[^\"][>\\s])([A-Z][A-Z0-9 ]{2,})([^<a-z0-9]|$)", "\\s?--\\s?", "\\s-\\s", "(\\d+)-(\\d+)", "(\\d+) ?x ?(\\d+)", "\\b ?(\\((tm|TM)\\))", "\\b ?(\\([rR]\\))", "\\b ?(\\([cC]\\))"};
        String[] glyphReplacement = new String[]{"$1&#8217;$2", "&#8216;", "$1&#8221;$2", "&#8220;", "$1&#8230;", "<acronym title=\"$3\">$1</acronym>", "$1<span class=\"caps\">$2</span>$3", " &#8212; ", " &#8211; ", "$1&#8211;$2", "$1&#215;$2", "&#8482;", "&#174;", "&#169;"};
        boolean ishtml = Pattern.compile("<.*>", 8).matcher(content).find();
        boolean inpreservation = false;
        if (!ishtml) {
            content = this.arrayReplaceAll(content, glyphMatches, glyphReplacement);
        } else {
            String[] segments = this.splitContent("<.*>", content);
            StringBuffer segmentBuffer = new StringBuffer();
            for (int x = 0; x < segments.length; ++x) {
                if (segments[x].toLowerCase().matches("<(code|pre|kbd|notextile)>")) {
                    inpreservation = true;
                } else if (segments[x].toLowerCase().matches("</(code|pre|kbd|notextile)>")) {
                    inpreservation = false;
                }
                if (!Pattern.compile("<.*>", 8).matcher(segments[x]).find() && !inpreservation) {
                    segments[x] = this.arrayReplaceAll(segments[x], glyphMatches, glyphReplacement);
                }
                if (inpreservation) {
                    segments[x] = this.htmlSpecialChars(segments[x], 2);
                    segments[x] = Textile.replace(segments[x], "&lt;pre&gt;", "<pre>");
                    segments[x] = Textile.replace(segments[x], "&lt;code&gt;", "<code>");
                    segments[x] = Textile.replace(segments[x], "&lt;notextile&gt;", "<notextile>");
                }
                segmentBuffer.append(segments[x]);
            }
            content = segmentBuffer.toString();
        }
        content = content.replaceAll("(\\S)(_*)([:punct:]*) *\\n([^#*\\s])", "$1$2$3<br />$4");
        content = Textile.replace(content, "l><br />", "l>\n");
        String[] blockMatches = new String[]{"^\\s?\\*\\s(.*)$", "^\\s?#\\s(.*)$", "^bq\\. (.*)", "^h(\\d)\\(([\\w]+)\\)\\.\\s(.*)", "^h(\\d)\\. (.*)", "^p\\(([\\w]+)\\)\\.\\s(.*)", "^p\\. (.*)", "^([^\\t ]+.*)"};
        String[] blockReplace = new String[]{"\t<liu>$1</liu>", "\t<lio>$1</lio>", "\t<blockquote>$1</blockquote>", "\t<h$1 class=\"$2\">$3</h$1>", "\t<h$1>$2</h$1>", "\t<p class=\"$1\">$2</p>", "\t<p>$1</p>", "\t<p>$1</p>"};
        StringBuffer blockBuffer = new StringBuffer();
        String list = "";
        content = content + "\n";
        boolean inpre = false;
        String[] tokens = content.split("\n");
        int tokenCount = tokens.length;
        for (int x = 0; x < tokenCount; ++x) {
            String line = tokens[x];
            if (!line.matches("^$")) {
                if (line.toLowerCase().indexOf("<pre>") > -1) {
                    inpre = true;
                }
                if (!inpre) {
                    line = this.arrayReplaceAll(line, blockMatches, blockReplace);
                }
                if (inpre) {
                    line = Textile.replace(line, "<br />", "\n");
                    line = Textile.replace(line, "<br/>", "\n");
                }
                if (line.toLowerCase().indexOf("</pre>") > -1) {
                    inpre = false;
                }
                boolean islist = Pattern.compile("\\t<li", 8).matcher(line).find();
                boolean islistline = Pattern.compile("\\t<li" + list, 8).matcher(line).find();
                if (list.length() == 0 && islist) {
                    line = line.replaceAll("^(\\t<li)(o|u)", "\n<$2l>\n$1$2");
                    list = line.substring(2, 3);
                } else if (list.length() > 0 && !islistline) {
                    line = line.replaceAll("^(.*)$", "</" + list + "l>\n$1");
                    list = "";
                }
            }
            blockBuffer.append(line);
            blockBuffer.append("\n");
        }
        if (!list.equals("")) {
            blockBuffer.append("</" + list + "l>\n");
            list = "";
        }
        if ((content = blockBuffer.toString()).endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        content = content.replaceAll("<\\/?notextile>", "");
        content = content.replaceAll("<(\\/?)li(u|o)>", "<$1li>");
        content = Textile.replace(content, "x%x%", "&#38;");
        content = Textile.replace(content, "<br />", "<br />\n");
        return content;
    }

    private String htmlSpecialChars(String origContent, int mode) {
        String content = origContent;
        content = Textile.replace(content, "&", "&amp;");
        if (mode != 2) {
            content = Textile.replace(content, "\"", "&quot;");
        }
        if (mode == 3) {
            content = Textile.replace(content, "'", "&#039;");
        }
        content = Textile.replace(content, "<", "&lt;");
        content = Textile.replace(content, ">", "&gt;");
        return content;
    }

    private String[] splitContent(String matchexp, String content) {
        int startAt = 0;
        ArrayList<String> tempList = new ArrayList<String>();
        Pattern pattern = Pattern.compile(matchexp, 8);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            tempList.add(content.substring(startAt, matcher.start()));
            tempList.add(matcher.group());
            startAt = matcher.end();
        }
        tempList.add(content.substring(startAt));
        String[] result = new String[tempList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)tempList.get(i);
        }
        return result;
    }

    private String arrayReplaceAll(String content, String[] matches, String[] replaces) {
        String result = content;
        for (int x = 0; x < matches.length; ++x) {
            String match = matches[x];
            String replace = replaces[x];
            result = result.replaceAll(match, replace);
        }
        return result;
    }

    private static String replace(String str, String pattern, String replace) {
        if (str == null || "".equals(str)) {
            return str;
        }
        if (replace == null) {
            return str;
        }
        if ("".equals(pattern)) {
            return str;
        }
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }
}

