/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.business;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.apache.roller.planet.business.Planet;
import org.apache.roller.planet.business.PlanetProvider;
import org.apache.roller.planet.config.PlanetConfig;

public class GuicePlanetProvider
implements PlanetProvider {
    private final Injector injector;
    private Planet planetInstance = null;

    public GuicePlanetProvider() {
        String moduleClassname = PlanetConfig.getProperty("guice.backend.module");
        if (moduleClassname == null) {
            throw new NullPointerException("unable to lookup default guice module via property 'guice.backend.module'");
        }
        try {
            Class<?> moduleClass = Class.forName(moduleClassname);
            Module module = (Module)moduleClass.newInstance();
            this.injector = Guice.createInjector((Module[])new Module[]{module});
        }
        catch (Throwable e) {
            throw new RuntimeException("Error instantiating backend module " + moduleClassname, e);
        }
    }

    public GuicePlanetProvider(String moduleClassname) {
        if (moduleClassname == null) {
            throw new NullPointerException("moduleClassname cannot be null");
        }
        try {
            Class<?> moduleClass = Class.forName(moduleClassname);
            Module module = (Module)moduleClass.newInstance();
            this.injector = Guice.createInjector((Module[])new Module[]{module});
        }
        catch (Throwable e) {
            throw new RuntimeException("Error instantiating backend module " + moduleClassname, e);
        }
    }

    public void bootstrap() {
        this.planetInstance = (Planet)this.injector.getInstance(Planet.class);
    }

    public Planet getPlanet() {
        return this.planetInstance;
    }
}

