/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.business;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.planet.business.BootstrapException;
import org.apache.roller.planet.business.Planet;
import org.apache.roller.planet.business.PlanetProvider;
import org.apache.roller.planet.business.startup.PlanetStartup;
import org.apache.roller.planet.config.PlanetConfig;

public abstract class PlanetFactory {
    private static Log log = LogFactory.getLog(PlanetFactory.class);
    private static PlanetProvider planetProvider = null;

    private PlanetFactory() {
    }

    public static Planet getPlanet() {
        if (planetProvider == null) {
            throw new IllegalStateException("Roller Planet has not been bootstrapped yet");
        }
        return planetProvider.getPlanet();
    }

    public static boolean isBootstrapped() {
        return planetProvider != null;
    }

    public static final void bootstrap() throws BootstrapException {
        PlanetProvider defaultProvider;
        if (!PlanetStartup.isPrepared()) {
            throw new IllegalStateException("Cannot bootstrap until application has been properly prepared");
        }
        String providerClassname = PlanetConfig.getProperty("planet.provider.class");
        if (providerClassname != null) {
            try {
                Class<?> providerClass = Class.forName(providerClassname);
                defaultProvider = (PlanetProvider)providerClass.newInstance();
            }
            catch (Exception ex) {
                throw new BootstrapException("Error instantiating default provider: " + providerClassname, ex);
            }
        } else {
            throw new NullPointerException("No provider specified in config property 'planet.provider.class'");
        }
        PlanetFactory.bootstrap(defaultProvider);
    }

    public static final void bootstrap(PlanetProvider provider) throws BootstrapException {
        if (!PlanetStartup.isPrepared()) {
            throw new IllegalStateException("Cannot bootstrap until application has been properly prepared");
        }
        if (provider == null) {
            throw new NullPointerException("PlanetProvider is null");
        }
        log.info((Object)"Bootstrapping Roller Planet business tier");
        log.info((Object)("Planet Provider = " + provider.getClass().getName()));
        planetProvider = provider;
        planetProvider.bootstrap();
        if (planetProvider.getPlanet() == null) {
            throw new BootstrapException("Bootstrapping failed, Planet instance is null");
        }
        log.info((Object)"Roller Planet business tier successfully bootstrapped");
    }
}

