/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.business.fetcher;

import com.sun.syndication.feed.module.DCModule;
import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.fetcher.impl.FeedFetcherCache;
import com.sun.syndication.fetcher.impl.HttpURLFeedFetcher;
import com.sun.syndication.fetcher.impl.SyndFeedInfo;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.planet.business.fetcher.FeedFetcher;
import org.apache.roller.planet.business.fetcher.FetcherException;
import org.apache.roller.planet.config.PlanetConfig;
import org.apache.roller.planet.pojos.Subscription;
import org.apache.roller.planet.pojos.SubscriptionEntry;
import org.apache.roller.planet.util.rome.DiskFeedInfoCache;

public class RomeFeedFetcher
implements FeedFetcher {
    private static Log log = LogFactory.getLog(RomeFeedFetcher.class);

    public Subscription fetchSubscription(String feedURL) throws FetcherException {
        return this.fetchSubscription(feedURL, null);
    }

    public Subscription fetchSubscription(String feedURL, Date lastModified) throws FetcherException {
        SyndFeed feed;
        if (feedURL == null) {
            throw new IllegalArgumentException("feed url cannot be null");
        }
        com.sun.syndication.fetcher.FeedFetcher feedFetcher = this.getRomeFetcher();
        log.debug((Object)("Fetching feed: " + feedURL));
        try {
            feed = feedFetcher.retrieveFeed(new URL(feedURL));
        }
        catch (Exception ex) {
            throw new FetcherException("Error fetching subscription - " + feedURL, ex);
        }
        log.debug((Object)"Feed pulled, extracting data into Subscription");
        Subscription newSub = new Subscription();
        newSub.setFeedURL(feedURL);
        newSub.setSiteURL(feed.getLink());
        newSub.setTitle(feed.getTitle());
        newSub.setAuthor(feed.getAuthor());
        newSub.setLastUpdated(feed.getPublishedDate());
        if (newSub.getSiteURL() == null) {
            newSub.setSiteURL(newSub.getFeedURL());
        }
        if (newSub.getAuthor() == null) {
            newSub.setAuthor(newSub.getTitle());
        }
        if (newSub.getLastUpdated() == null) {
            FeedFetcherCache feedCache = this.getRomeFetcherCache();
            try {
                long lastUpdatedLong;
                SyndFeedInfo feedInfo = feedCache.getFeedInfo(new URL(newSub.getFeedURL()));
                if (feedInfo.getLastModified() != null && (lastUpdatedLong = ((Long)feedInfo.getLastModified()).longValue()) != 0L) {
                    newSub.setLastUpdated(new Date(lastUpdatedLong));
                }
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
        }
        if (lastModified != null && newSub.getLastUpdated() != null && !newSub.getLastUpdated().after(lastModified)) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Subscription is: " + newSub.toString()));
        }
        Calendar cal = Calendar.getInstance();
        if (newSub.getLastUpdated() != null) {
            cal.setTime(newSub.getLastUpdated());
        } else {
            cal.setTime(new Date());
            cal.add(5, -1);
        }
        List feedEntries = feed.getEntries();
        for (SyndEntry feedEntry : feedEntries) {
            SubscriptionEntry newEntry = this.buildEntry(feedEntry);
            if (newEntry.getPubTime() == null) {
                log.debug((Object)("No published date, assigning fake date for " + feedURL));
                newEntry.setPubTime(new Timestamp(cal.getTimeInMillis()));
                cal.add(5, -1);
            }
            if (newEntry == null) continue;
            newSub.addEntry(newEntry);
        }
        log.debug((Object)(feedEntries.size() + " entries included"));
        return newSub;
    }

    private SubscriptionEntry buildEntry(SyndEntry romeEntry) {
        if (romeEntry.getLink() == null) {
            return null;
        }
        SubscriptionEntry newEntry = new SubscriptionEntry();
        newEntry.setTitle(romeEntry.getTitle());
        newEntry.setPermalink(romeEntry.getLink());
        DCModule entrydc = (DCModule)romeEntry.getModule("http://purl.org/dc/elements/1.1/");
        if (romeEntry.getAuthor() != null) {
            newEntry.setAuthor(romeEntry.getAuthor());
        } else {
            newEntry.setAuthor(entrydc.getCreator());
        }
        if (romeEntry.getUpdatedDate() != null) {
            newEntry.setUpdateTime(new Timestamp(romeEntry.getUpdatedDate().getTime()));
        }
        if (romeEntry.getPublishedDate() != null) {
            newEntry.setPubTime(new Timestamp(romeEntry.getPublishedDate().getTime()));
        } else if (entrydc != null && entrydc.getDate() != null) {
            newEntry.setPubTime(new Timestamp(entrydc.getDate().getTime()));
        } else {
            newEntry.setPubTime(newEntry.getUpdateTime());
        }
        if (romeEntry.getContents().size() > 0) {
            SyndContent content = (SyndContent)romeEntry.getContents().get(0);
            if (content != null && content.getType().equals("text/plain")) {
                newEntry.setText(StringEscapeUtils.unescapeHtml((String)content.getValue()));
            } else if (content != null) {
                newEntry.setText(content.getValue());
            }
        }
        if ((newEntry.getText() == null || newEntry.getText().trim().length() == 0) && romeEntry.getDescription() != null) {
            newEntry.setText(romeEntry.getDescription().getValue());
        }
        if (romeEntry.getCategories().size() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (SyndCategory cat : romeEntry.getCategories()) {
                list.add(cat.getName());
            }
            newEntry.setCategoriesString(list);
        }
        return newEntry;
    }

    private FeedFetcherCache getRomeFetcherCache() {
        String cacheDirPath = PlanetConfig.getProperty("cache.dir");
        if (cacheDirPath == null) {
            log.warn((Object)"Planet cache directory not set, feeds cannot be cached.");
            return null;
        }
        String cacheDirName = cacheDirPath.replaceFirst("\\$\\{user.home}", System.getProperty("user.home"));
        if (System.getProperty("catalina.home") != null) {
            cacheDirName = cacheDirName.replaceFirst("\\$\\{catalina.home}", System.getProperty("catalina.home"));
        }
        File cacheDir = null;
        try {
            cacheDir = new File(cacheDirName);
            if (!cacheDir.exists()) {
                cacheDir.mkdirs();
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to create planet cache directory: " + cacheDir.getPath()), (Throwable)e);
            return null;
        }
        if (!cacheDir.canWrite()) {
            log.error((Object)("Planet cache directory is not writable: " + cacheDir.getPath()));
            return null;
        }
        return new DiskFeedInfoCache(cacheDirName);
    }

    private com.sun.syndication.fetcher.FeedFetcher getRomeFetcher() {
        FeedFetcherCache feedCache = this.getRomeFetcherCache();
        HttpURLFeedFetcher feedFetcher = null;
        feedFetcher = feedCache != null ? new HttpURLFeedFetcher(feedCache) : new HttpURLFeedFetcher();
        feedFetcher.setUsingDeltaEncoding(false);
        feedFetcher.setUserAgent("RollerPlanetAggregator");
        return feedFetcher;
    }
}

