/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.business.jpa;

import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.planet.PlanetException;
import org.apache.roller.planet.business.DatabaseProvider;
import org.apache.roller.planet.business.startup.PlanetStartup;
import org.apache.roller.planet.config.PlanetConfig;

@Singleton
public class JPAPersistenceStrategy {
    private static Log logger = LogFactory.getFactory().getInstance(JPAPersistenceStrategy.class);
    private final ThreadLocal threadLocalEntityManager = new ThreadLocal();
    protected EntityManagerFactory emf;

    protected JPAPersistenceStrategy() throws PlanetException {
        String jpaConfigurationType = PlanetConfig.getProperty("jpa.configurationType");
        if ("jndi".equals(jpaConfigurationType)) {
            String emfJndiName = "java:comp/env/" + PlanetConfig.getProperty("jpa.emf.jndi.name");
            try {
                this.emf = (EntityManagerFactory)new InitialContext().lookup(emfJndiName);
            }
            catch (NamingException e) {
                throw new PlanetException("Could not look up EntityManagerFactory in jndi at " + emfJndiName, e);
            }
        }
        DatabaseProvider dbProvider = PlanetStartup.getDatabaseProvider();
        Properties emfProps = JPAPersistenceStrategy.loadPropertiesFromResourceName("JPAEMF.properties", JPAPersistenceStrategy.getContextClassLoader());
        Enumeration keys = PlanetConfig.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith("openjpa.") && !key.startsWith("toplink.")) continue;
            String value = PlanetConfig.getProperty(key);
            logger.info((Object)(key + ": " + value));
            emfProps.setProperty(key, value);
        }
        if (dbProvider.getType() == DatabaseProvider.ConfigurationType.JNDI_NAME) {
            String jndiName = "java:comp/env/" + dbProvider.getJndiName();
            emfProps.setProperty("openjpa.ConnectionFactoryName", jndiName);
        } else {
            emfProps.setProperty("openjpa.ConnectionDriverName", dbProvider.getJdbcDriverClass());
            emfProps.setProperty("openjpa.ConnectionURL", dbProvider.getJdbcConnectionURL());
            emfProps.setProperty("openjpa.ConnectionUserName", dbProvider.getJdbcUsername());
            emfProps.setProperty("openjpa.ConnectionPassword", dbProvider.getJdbcPassword());
            emfProps.setProperty("toplink.jdbc.driver", dbProvider.getJdbcDriverClass());
            emfProps.setProperty("toplink.jdbc.url", dbProvider.getJdbcConnectionURL());
            emfProps.setProperty("toplink.jdbc.user", dbProvider.getJdbcUsername());
            emfProps.setProperty("toplink.jdbc.password", dbProvider.getJdbcPassword());
            emfProps.setProperty("hibernate.connection.driver_class", dbProvider.getJdbcDriverClass());
            emfProps.setProperty("hibernate.connection.url", dbProvider.getJdbcConnectionURL());
            emfProps.setProperty("hibernate.connection.username", dbProvider.getJdbcUsername());
            emfProps.setProperty("hibernate.connection.password", dbProvider.getJdbcPassword());
        }
        try {
            this.emf = Persistence.createEntityManagerFactory((String)"PlanetPU", (Map)emfProps);
        }
        catch (PersistenceException pe) {
            logger.error((Object)"ERROR: creating entity manager", (Throwable)pe);
            throw new PlanetException(pe);
        }
    }

    public void flush() throws PlanetException {
        try {
            EntityManager em = this.getEntityManager(true);
            em.getTransaction().commit();
        }
        catch (PersistenceException pe) {
            throw new PlanetException(pe);
        }
    }

    public void release() {
        EntityManager em = this.getEntityManager(false);
        if (this.isTransactionActive(em)) {
            em.getTransaction().rollback();
        }
        em.close();
        this.setThreadLocalEntityManager(null);
    }

    public Object store(Object obj) throws PlanetException {
        EntityManager em = this.getEntityManager(true);
        if (!em.contains(obj)) {
            em.persist(obj);
        }
        return obj;
    }

    public void remove(Class clazz, String id) throws PlanetException {
        EntityManager em = this.getEntityManager(true);
        Object po = em.find(clazz, (Object)id);
        em.remove(po);
    }

    public void remove(Object po) throws PlanetException {
        EntityManager em = this.getEntityManager(true);
        em.remove(po);
    }

    public void removeAll(Collection pos) throws PlanetException {
        EntityManager em = this.getEntityManager(true);
        for (Object obj : pos) {
            em.remove(obj);
        }
    }

    public Object load(Class clazz, String id) throws PlanetException {
        EntityManager em = this.getEntityManager(false);
        return em.find(clazz, (Object)id);
    }

    private boolean isTransactionActive(EntityManager em) {
        if (em == null) {
            return false;
        }
        return em.getTransaction().isActive();
    }

    private EntityManager getEntityManager(boolean isTransactionRequired) {
        EntityManager em = this.getThreadLocalEntityManager();
        if (isTransactionRequired && !em.getTransaction().isActive()) {
            em.getTransaction().begin();
        }
        return em;
    }

    private EntityManager getThreadLocalEntityManager() {
        EntityManager em = (EntityManager)this.threadLocalEntityManager.get();
        if (em == null) {
            em = this.emf.createEntityManager();
            this.threadLocalEntityManager.set(em);
        }
        return em;
    }

    private void setThreadLocalEntityManager(Object em) {
        this.threadLocalEntityManager.set(em);
    }

    public Query getNamedQuery(String queryName) throws PlanetException {
        EntityManager em = this.getEntityManager(false);
        Query q = em.createNamedQuery(queryName);
        q.setFlushMode(FlushModeType.COMMIT);
        return q;
    }

    public Query getDynamicQuery(String queryString) throws PlanetException {
        EntityManager em = this.getEntityManager(false);
        Query q = em.createQuery(queryString);
        q.setFlushMode(FlushModeType.COMMIT);
        return q;
    }

    public Query getNamedUpdate(String queryName) throws PlanetException {
        EntityManager em = this.getEntityManager(true);
        Query q = em.createNamedQuery(queryName);
        return q;
    }

    protected static Properties loadPropertiesFromResourceName(String resourceName, ClassLoader cl) throws PlanetException {
        Properties props = new Properties();
        InputStream in = null;
        in = cl.getResourceAsStream(resourceName);
        if (in == null) {
            throw new PlanetException("Could not locate properties to load " + resourceName);
        }
        try {
            props.load(in);
        }
        catch (IOException ioe) {
            throw new PlanetException("Could not load properties from " + resourceName);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
        return props;
    }

    protected static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

