/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.business.jpa;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.planet.PlanetException;
import org.apache.roller.planet.business.AbstractManagerImpl;
import org.apache.roller.planet.business.InitializationException;
import org.apache.roller.planet.business.Planet;
import org.apache.roller.planet.business.PlanetManager;
import org.apache.roller.planet.business.PropertiesManager;
import org.apache.roller.planet.business.URLStrategy;
import org.apache.roller.planet.business.fetcher.FeedFetcher;
import org.apache.roller.planet.business.jpa.JPAPersistenceStrategy;

@Singleton
public class JPAPlanetImpl
extends AbstractManagerImpl
implements Planet {
    private static Log log = LogFactory.getLog(JPAPlanetImpl.class);
    private final JPAPersistenceStrategy strategy;
    private final PlanetManager planetManager;
    private final PropertiesManager propertiesManager;
    private final URLStrategy urlStrategy;
    private final FeedFetcher feedFetcher;

    @Inject
    protected JPAPlanetImpl(JPAPersistenceStrategy strategy, PlanetManager planetManager, PropertiesManager propertiesManager, URLStrategy urlStrategy, FeedFetcher feedFetcher) throws PlanetException {
        this.strategy = strategy;
        this.propertiesManager = propertiesManager;
        this.planetManager = planetManager;
        this.urlStrategy = urlStrategy;
        this.feedFetcher = feedFetcher;
    }

    public void initialize() throws InitializationException {
        log.info((Object)"Initializing Roller Planet business tier");
        this.getPropertiesManager().initialize();
        this.getPlanetManager().initialize();
        try {
            this.flush();
        }
        catch (PlanetException ex) {
            throw new InitializationException("Error flushing after initialization", (Throwable)((Object)ex));
        }
        log.info((Object)"Roller Planet business tier successfully initialized");
    }

    public void flush() throws PlanetException {
        this.strategy.flush();
    }

    public void release() {
        this.strategy.release();
    }

    public void shutdown() {
        this.release();
    }

    public PlanetManager getPlanetManager() {
        return this.planetManager;
    }

    public PropertiesManager getPropertiesManager() {
        return this.propertiesManager;
    }

    public URLStrategy getURLStrategy() {
        return this.urlStrategy;
    }

    public FeedFetcher getFeedFetcher() {
        return this.feedFetcher;
    }
}

