/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.business.updater;

import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.planet.PlanetException;
import org.apache.roller.planet.business.PlanetFactory;
import org.apache.roller.planet.business.PlanetManager;
import org.apache.roller.planet.business.fetcher.FeedFetcher;
import org.apache.roller.planet.business.fetcher.FetcherException;
import org.apache.roller.planet.business.updater.FeedUpdater;
import org.apache.roller.planet.business.updater.UpdaterException;
import org.apache.roller.planet.config.PlanetRuntimeConfig;
import org.apache.roller.planet.pojos.PlanetGroup;
import org.apache.roller.planet.pojos.Subscription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleThreadedFeedUpdater
implements FeedUpdater {
    private static Log log = LogFactory.getLog(SingleThreadedFeedUpdater.class);

    @Override
    public void updateSubscription(Subscription sub) throws UpdaterException {
        Subscription updatedSub;
        if (sub == null) {
            throw new IllegalArgumentException("cannot update null subscription");
        }
        this.updateProxySettings();
        log.debug((Object)("updating feed: " + sub.getFeedURL()));
        long subStartTime = System.currentTimeMillis();
        try {
            FeedFetcher fetcher = PlanetFactory.getPlanet().getFeedFetcher();
            updatedSub = fetcher.fetchSubscription(sub.getFeedURL(), sub.getLastUpdated());
        }
        catch (FetcherException ex) {
            throw new UpdaterException("Error fetching updated subscription", (Throwable)((Object)ex));
        }
        if (updatedSub == null) {
            return;
        }
        if (sub.getLastUpdated() != null && updatedSub.getLastUpdated() != null && !updatedSub.getLastUpdated().after(sub.getLastUpdated())) {
            log.debug((Object)("Skipping update, feed hasn't changed - " + sub.getFeedURL()));
        }
        sub.setSiteURL(updatedSub.getSiteURL());
        sub.setTitle(updatedSub.getTitle());
        sub.setAuthor(updatedSub.getAuthor());
        sub.setLastUpdated(updatedSub.getLastUpdated());
        int entries = 0;
        Set newEntries = updatedSub.getEntries();
        if (newEntries.size() > 0) {
            try {
                PlanetManager pmgr = PlanetFactory.getPlanet().getPlanetManager();
                pmgr.deleteEntries(sub);
                sub.getEntries().clear();
                sub.addEntries(newEntries);
                pmgr.saveSubscription(sub);
                PlanetFactory.getPlanet().flush();
            }
            catch (PlanetException ex) {
                throw new UpdaterException("Error persisting updated subscription", (Throwable)((Object)ex));
            }
        }
        long subEndTime = System.currentTimeMillis();
        log.debug((Object)("updated feed -- " + sub.getFeedURL() + " -- in " + (double)(subEndTime - subStartTime) / 1000.0 + " seconds.  " + entries + " entries updated."));
    }

    @Override
    public void updateSubscriptions() throws UpdaterException {
        this.updateProxySettings();
        log.debug((Object)"--- BEGIN --- Updating all subscriptions");
        long startTime = System.currentTimeMillis();
        try {
            PlanetManager pmgr = PlanetFactory.getPlanet().getPlanetManager();
            this.updateSubscriptions(pmgr.getSubscriptions());
        }
        catch (PlanetException ex) {
            throw new UpdaterException("Error getting subscriptions list", (Throwable)((Object)ex));
        }
        long endTime = System.currentTimeMillis();
        log.info((Object)("--- DONE --- Updated subscriptions in " + (double)(endTime - startTime) / 1000.0 + " seconds"));
    }

    @Override
    public void updateSubscriptions(PlanetGroup group) throws UpdaterException {
        if (group == null) {
            throw new IllegalArgumentException("cannot update null group");
        }
        this.updateProxySettings();
        log.debug((Object)("--- BEGIN --- Updating subscriptions in group = " + group.getHandle()));
        long startTime = System.currentTimeMillis();
        this.updateSubscriptions(group.getSubscriptions());
        long endTime = System.currentTimeMillis();
        log.info((Object)("--- DONE --- Updated subscriptions in " + (double)(endTime - startTime) / 1000.0 + " seconds"));
    }

    private void updateSubscriptions(Collection<Subscription> subscriptions) {
        PlanetManager pmgr = PlanetFactory.getPlanet().getPlanetManager();
        for (Subscription sub : subscriptions) {
            try {
                sub = pmgr.getSubscriptionById(sub.getId());
            }
            catch (PlanetException ex) {
                log.warn((Object)("Subscription went missing while doing update: " + ex.getMessage()));
            }
            try {
                this.updateSubscription(sub);
            }
            catch (UpdaterException ex) {
                Object cause = ex;
                if (ex.getRootCause() != null) {
                    cause = ex.getRootCause();
                }
                if (((Throwable)cause).getCause() != null) {
                    cause = ((Throwable)cause).getCause();
                }
                log.warn((Object)("Error updating subscription - " + sub.getFeedURL()), (Throwable)cause);
            }
            catch (Exception ex) {
                log.warn((Object)("Error updating subscription - " + sub.getFeedURL()), (Throwable)ex);
            }
        }
    }

    private void updateProxySettings() {
        String proxyHost = PlanetRuntimeConfig.getProperty("site.proxyhost");
        int proxyPort = PlanetRuntimeConfig.getIntProperty("site.proxyport");
        if (proxyHost != null && proxyPort > 0) {
            System.setProperty("proxySet", "true");
            System.setProperty("http.proxyHost", proxyHost);
            System.setProperty("http.proxyPort", Integer.toString(proxyPort));
        }
        System.setProperty("sun.net.client.defaultConnectTimeout", "15000");
        System.setProperty("sun.net.client.defaultReadTimeout", "15000");
    }
}

