/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.tasks;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.planet.PlanetException;
import org.apache.roller.planet.business.Planet;
import org.apache.roller.planet.business.PlanetFactory;
import org.apache.roller.planet.business.PlanetManager;
import org.apache.roller.planet.pojos.PlanetGroup;
import org.apache.roller.planet.pojos.Subscription;

public class StaticPlanetModel {
    private static Log logger = LogFactory.getFactory().getInstance(StaticPlanetModel.class);
    PlanetManager planetManager = null;

    public StaticPlanetModel() throws PlanetException {
        Planet planet = PlanetFactory.getPlanet();
        this.planetManager = planet.getPlanetManager();
    }

    public Subscription getSubscription(String feedUrl) throws Exception {
        return this.planetManager.getSubscription(feedUrl);
    }

    public List getFeedEntries(String feedUrl, int maxEntries) throws Exception {
        try {
            Subscription sub = this.planetManager.getSubscription(feedUrl);
            if (sub != null) {
                return this.planetManager.getEntries(sub, 0, maxEntries);
            }
            return Collections.EMPTY_LIST;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List getAggregation(PlanetGroup group, int maxEntries) throws PlanetException {
        return this.planetManager.getEntries(group, 0, maxEntries);
    }

    public Iterator getAllSubscriptions() throws PlanetException {
        return this.planetManager.getSubscriptions().iterator();
    }

    public int getSubscriptionCount() throws PlanetException {
        return this.planetManager.getSubscriptionCount();
    }
}

