/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.roller.planet.business.PlanetFactory;
import org.apache.roller.planet.business.PlanetManager;
import org.apache.roller.planet.config.PlanetRuntimeConfig;

public final class URLUtilities {
    private URLUtilities() {
    }

    public static final String getPlanetURL(String planet) {
        if (planet == null) {
            return null;
        }
        StringBuffer url = new StringBuffer();
        PlanetManager mgr = PlanetFactory.getPlanet().getPlanetManager();
        url.append(PlanetRuntimeConfig.getProperty("site.absoluteurl"));
        url.append("/").append(planet).append("/");
        return url.toString();
    }

    public static final String getPlanetGroupURL(String planet, String group) {
        if (planet == null || group == null) {
            return null;
        }
        StringBuffer url = new StringBuffer();
        url.append(URLUtilities.getPlanetURL(planet));
        url.append("group/").append(group).append("/");
        return url.toString();
    }

    public static final String getPlanetGroupFeedURL(String planet, String group, String format) {
        if (planet == null || group == null) {
            return null;
        }
        StringBuffer url = new StringBuffer();
        url.append(URLUtilities.getPlanetGroupURL(planet, group));
        url.append("feed/").append(format);
        return url.toString();
    }

    public static final String getQueryString(Map params) {
        if (params == null) {
            return null;
        }
        StringBuffer queryString = new StringBuffer();
        for (String key : params.keySet()) {
            String value = (String)params.get(key);
            if (queryString.length() == 0) {
                queryString.append("?");
            } else {
                queryString.append("&");
            }
            queryString.append(key);
            queryString.append("=");
            queryString.append(value);
        }
        return queryString.toString();
    }

    public static final String encode(String str) {
        String encodedStr = str;
        try {
            encodedStr = URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encodedStr;
    }

    public static final String decode(String str) {
        String decodedStr = str;
        try {
            decodedStr = URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decodedStr;
    }

    public static final String getEncodedTagsString(List tags) {
        StringBuffer tagsString = new StringBuffer();
        if (tags != null && tags.size() > 0) {
            String tag = null;
            Iterator tagsIT = tags.iterator();
            tag = (String)tagsIT.next();
            tagsString.append(URLUtilities.encode(tag));
            while (tagsIT.hasNext()) {
                tag = (String)tagsIT.next();
                tagsString.append("+");
                tagsString.append(URLUtilities.encode(tag));
            }
        }
        return tagsString.toString();
    }
}

