/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.util.RegexUtil;

public class Utilities {
    private static Log mLogger = LogFactory.getLog(Utilities.class);
    public static final String TAG_SPLIT_CHARS = " ,\n\r\f\t";

    public static String stripJsessionId(String url) {
        int startPos = url.indexOf(";jsessionid=");
        if (startPos != -1) {
            int endPos = url.indexOf("?", startPos);
            url = endPos == -1 ? url.substring(0, startPos) : url.substring(0, startPos) + url.substring(endPos, url.length());
        }
        return url;
    }

    public static String escapeHTML(String s) {
        return Utilities.escapeHTML(s, true);
    }

    public static String escapeHTML(String s, boolean escapeAmpersand) {
        if (escapeAmpersand) {
            s = StringUtils.replace((String)s, (String)"&", (String)"&amp;");
        }
        s = StringUtils.replace((String)s, (String)"&nbsp;", (String)" ");
        s = StringUtils.replace((String)s, (String)"\"", (String)"&quot;");
        s = StringUtils.replace((String)s, (String)"<", (String)"&lt;");
        s = StringUtils.replace((String)s, (String)">", (String)"&gt;");
        return s;
    }

    public static String unescapeHTML(String str) {
        return StringEscapeUtils.unescapeHtml((String)str);
    }

    public static String removeHTML(String str) {
        return Utilities.removeHTML(str, true);
    }

    public static String removeHTML(String str, boolean addSpace) {
        if (str == null) {
            return "";
        }
        StringBuffer ret = new StringBuffer(str.length());
        int start = 0;
        int beginTag = str.indexOf("<");
        int endTag = 0;
        if (beginTag == -1) {
            return str;
        }
        while (beginTag >= start) {
            if (beginTag > 0) {
                ret.append(str.substring(start, beginTag));
                if (addSpace) {
                    ret.append(" ");
                }
            }
            if ((endTag = str.indexOf(">", beginTag)) > -1) {
                start = endTag + 1;
                beginTag = str.indexOf("<", start);
                continue;
            }
            ret.append(str.substring(beginTag));
            break;
        }
        if (endTag > -1 && endTag + 1 < str.length()) {
            ret.append(str.substring(endTag + 1));
        }
        return ret.toString().trim();
    }

    public static String removeAndEscapeHTML(String s) {
        if (s == null) {
            return "";
        }
        return Utilities.escapeHTML(Utilities.removeHTML(s));
    }

    public static String autoformat(String s) {
        String ret = StringUtils.replace((String)s, (String)"\n", (String)"<br />");
        return ret;
    }

    public static String replaceNonAlphanumeric(String str) {
        return Utilities.replaceNonAlphanumeric(str, '_');
    }

    public static String replaceNonAlphanumeric(String str, char subst) {
        StringBuffer ret = new StringBuffer(str.length());
        char[] testChars = str.toCharArray();
        for (int i = 0; i < testChars.length; ++i) {
            if (Character.isLetterOrDigit(testChars[i])) {
                ret.append(testChars[i]);
                continue;
            }
            ret.append(subst);
        }
        return ret.toString();
    }

    public static String removeNonAlphanumeric(String str) {
        StringBuffer ret = new StringBuffer(str.length());
        char[] testChars = str.toCharArray();
        for (int i = 0; i < testChars.length; ++i) {
            if (!Character.isLetterOrDigit(testChars[i]) && testChars[i] != '.') continue;
            ret.append(testChars[i]);
        }
        return ret.toString();
    }

    public static String stringArrayToString(String[] stringArray, String delim) {
        String ret = "";
        for (int i = 0; i < stringArray.length; ++i) {
            ret = ret.length() > 0 ? ret + delim + stringArray[i] : stringArray[i];
        }
        return ret;
    }

    public static String[] stringToStringArray(String instr, String delim) throws NoSuchElementException, NumberFormatException {
        StringTokenizer toker = new StringTokenizer(instr, delim);
        String[] stringArray = new String[toker.countTokens()];
        int i = 0;
        while (toker.hasMoreTokens()) {
            stringArray[i++] = toker.nextToken();
        }
        return stringArray;
    }

    public static int[] stringToIntArray(String instr, String delim) throws NoSuchElementException, NumberFormatException {
        StringTokenizer toker = new StringTokenizer(instr, delim);
        int[] intArray = new int[toker.countTokens()];
        int i = 0;
        while (toker.hasMoreTokens()) {
            String sInt = toker.nextToken();
            int nInt = Integer.parseInt(sInt);
            intArray[i++] = new Integer(nInt);
        }
        return intArray;
    }

    public static String intArrayToString(int[] intArray) {
        String ret = "";
        for (int i = 0; i < intArray.length; ++i) {
            ret = ret.length() > 0 ? ret + "," + Integer.toString(intArray[i]) : Integer.toString(intArray[i]);
        }
        return ret;
    }

    public static void copyFile(File from, File to) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(from);
        }
        catch (IOException ex) {
            throw new IOException("Utilities.copyFile: opening input stream '" + from.getPath() + "', " + ex.getMessage());
        }
        try {
            out = new FileOutputStream(to);
        }
        catch (Exception ex) {
            try {
                ((InputStream)in).close();
            }
            catch (IOException ex1) {
                // empty catch block
            }
            throw new IOException("Utilities.copyFile: opening output stream '" + to.getPath() + "', " + ex.getMessage());
        }
        Utilities.copyInputToOutput(in, out, from.length());
    }

    public static void copyInputToOutput(InputStream input, OutputStream output, long byteCount) throws IOException {
        int bytes;
        BufferedInputStream in = new BufferedInputStream(input);
        BufferedOutputStream out = new BufferedOutputStream(output);
        byte[] buffer = new byte[8192];
        for (long length = byteCount; length > 0L; length -= (long)bytes) {
            bytes = (int)(length > 8192L ? 8192L : length);
            try {
                bytes = in.read(buffer, 0, bytes);
            }
            catch (IOException ex) {
                try {
                    in.close();
                    out.close();
                }
                catch (IOException ex1) {
                    // empty catch block
                }
                throw new IOException("Reading input stream, " + ex.getMessage());
            }
            if (bytes < 0) break;
            try {
                out.write(buffer, 0, bytes);
                continue;
            }
            catch (IOException ex) {
                try {
                    in.close();
                    out.close();
                }
                catch (IOException ex1) {
                    // empty catch block
                }
                throw new IOException("Writing output stream, " + ex.getMessage());
            }
        }
        try {
            in.close();
            out.close();
        }
        catch (IOException ex) {
            throw new IOException("Closing file streams, " + ex.getMessage());
        }
    }

    public static void copyInputToOutput(InputStream input, OutputStream output) throws IOException {
        BufferedInputStream in = new BufferedInputStream(input);
        BufferedOutputStream out = new BufferedOutputStream(output);
        byte[] buffer = new byte[8192];
        int count = 0;
        while (count != -1) {
            count = in.read(buffer, 0, 8192);
            if (count == -1) continue;
            out.write(buffer, 0, count);
        }
        try {
            in.close();
            out.close();
        }
        catch (IOException ex) {
            throw new IOException("Closing file streams, " + ex.getMessage());
        }
    }

    public static String encodePassword(String password, String algorithm) {
        byte[] unencodedPassword = password.getBytes();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (Exception e) {
            mLogger.error((Object)("Exception: " + e));
            return password;
        }
        md.reset();
        md.update(unencodedPassword);
        byte[] encodedPassword = md.digest();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < encodedPassword.length; ++i) {
            if ((encodedPassword[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(encodedPassword[i] & 0xFF, 16));
        }
        return buf.toString();
    }

    public static String encodeString(String str) throws IOException {
        String encodedStr = new String(Base64.encodeBase64((byte[])str.getBytes()));
        return encodedStr.trim();
    }

    public static String decodeString(String str) throws IOException {
        String value = new String(Base64.decodeBase64((byte[])str.getBytes()));
        return value;
    }

    public static String truncate(String str, int lower, int upper, String appendToEnd) {
        String str2 = Utilities.removeHTML(str, false);
        if (upper < lower) {
            upper = lower;
        }
        if (str2.length() > upper) {
            int loc = str2.lastIndexOf(32, upper);
            if (loc >= lower) {
                str2 = str2.substring(0, loc);
            } else {
                str2 = str2.substring(0, upper);
                loc = upper;
            }
            str2 = str2 + appendToEnd;
        }
        return str2;
    }

    public static String truncateNicely(String str, int lower, int upper, String appendToEnd) {
        boolean diff;
        String str2 = Utilities.removeHTML(str, false);
        boolean bl = diff = str2.length() < str.length();
        if (upper < lower) {
            upper = lower;
        }
        if (str2.length() > upper) {
            int loc = str2.lastIndexOf(32, upper);
            if (loc >= lower) {
                str2 = str2.substring(0, loc);
            } else {
                str2 = str2.substring(0, upper);
                loc = upper;
            }
            if (diff) {
                loc = str2.lastIndexOf(32, loc);
                String str3 = str2.substring(loc + 1);
                loc = str.indexOf(str3, loc) + str3.length();
                str2 = str.substring(0, loc);
                str3 = Utilities.extractHTML(str.substring(loc));
                str = str2 + appendToEnd + str3;
            } else {
                str = str2 + appendToEnd;
            }
        }
        return str;
    }

    public static String truncateText(String str, int lower, int upper, String appendToEnd) {
        boolean diff;
        String str2 = Utilities.removeHTML(str, false);
        boolean bl = diff = str2.length() < str.length();
        if (upper < lower) {
            upper = lower;
        }
        if (str2.length() > upper) {
            int loc = str2.lastIndexOf(32, upper);
            if (loc >= lower) {
                str2 = str2.substring(0, loc);
            } else {
                str2 = str2.substring(0, upper);
                loc = upper;
            }
            str = str2 + appendToEnd;
        }
        return str;
    }

    private static String stripLineBreaks(String str) {
        str = str.replaceAll("<br>", "");
        str = str.replaceAll("<br/>", "");
        str = str.replaceAll("<br />", "");
        str = str.replaceAll("<p></p>", "");
        str = str.replaceAll("<p/>", "");
        str = str.replaceAll("<p />", "");
        return str;
    }

    private static String removeVisibleHTMLTags(String str) {
        int stringIndex;
        str = Utilities.stripLineBreaks(str);
        StringBuffer result = new StringBuffer(str);
        StringBuffer lcresult = new StringBuffer(str.toLowerCase());
        String[] visibleTags = new String[]{"<img"};
        for (int j = 0; j < visibleTags.length; ++j) {
            while ((stringIndex = lcresult.indexOf(visibleTags[j])) != -1) {
                if (visibleTags[j].endsWith(">")) {
                    result.delete(stringIndex, stringIndex + visibleTags[j].length());
                    lcresult.delete(stringIndex, stringIndex + visibleTags[j].length());
                    continue;
                }
                int endIndex = result.indexOf(">", stringIndex);
                if (endIndex <= -1) continue;
                result.delete(stringIndex, endIndex + 1);
                lcresult.delete(stringIndex, endIndex + 1);
            }
        }
        String[] openCloseTags = new String[]{"li", "a", "div", "h1", "h2", "h3", "h4"};
        for (int j = 0; j < openCloseTags.length; ++j) {
            String closeTag = "</" + openCloseTags[j] + ">";
            int lastStringIndex = 0;
            while ((stringIndex = lcresult.indexOf("<" + openCloseTags[j], lastStringIndex)) > -1) {
                lastStringIndex = stringIndex;
                int endIndex = lcresult.indexOf(closeTag, stringIndex);
                if (endIndex > -1) {
                    result.delete(stringIndex, endIndex + closeTag.length());
                    lcresult.delete(stringIndex, endIndex + closeTag.length());
                    continue;
                }
                endIndex = lcresult.indexOf(">", stringIndex);
                int nextStart = lcresult.indexOf("<", stringIndex + 1);
                if (endIndex <= stringIndex || lcresult.charAt(endIndex - 1) != '/' || endIndex >= nextStart && nextStart != -1) continue;
                result.delete(stringIndex, endIndex + 1);
                lcresult.delete(stringIndex, endIndex + 1);
            }
        }
        return result.toString();
    }

    public static String extractHTML(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer ret = new StringBuffer(str.length());
        int start = 0;
        int beginTag = str.indexOf("<");
        int endTag = 0;
        if (beginTag == -1) {
            return str;
        }
        while (beginTag >= start && (endTag = str.indexOf(">", beginTag)) > -1) {
            ret.append(str.substring(beginTag, endTag + 1));
            start = endTag + 1;
            beginTag = str.indexOf("<", start);
        }
        return ret.toString();
    }

    public static String hexEncode(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        return RegexUtil.encode((String)str);
    }

    public static String encodeEmail(String str) {
        return str != null ? RegexUtil.encodeEmail((String)str) : null;
    }

    public static final String encode(String s) {
        try {
            if (s != null) {
                return URLEncoder.encode(s, "UTF-8");
            }
            return s;
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public static final String decode(String s) {
        try {
            if (s != null) {
                return URLDecoder.decode(s, "UTF-8");
            }
            return s;
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public static int stringToInt(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            mLogger.debug((Object)("Invalid Integer:" + string));
            return 0;
        }
    }

    public static String toBase64(byte[] aValue) {
        String m_strBase64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        int iByteLen = aValue.length;
        StringBuffer tt = new StringBuffer();
        for (int i = 0; i < iByteLen; i += 3) {
            boolean bByte2 = i + 1 < iByteLen;
            boolean bByte3 = i + 2 < iByteLen;
            int byte1 = aValue[i] & 0xFF;
            int byte2 = bByte2 ? aValue[i + 1] & 0xFF : 0;
            int byte3 = bByte3 ? aValue[i + 2] & 0xFF : 0;
            tt.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(byte1 / 4));
            tt.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(byte2 / 16 + (byte1 & 3) * 16));
            tt.append(bByte2 ? "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(byte3 / 64 + (byte2 & 0xF) * 4) : (char)'=');
            tt.append(bByte3 ? "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(byte3 & 0x3F) : (char)'=');
        }
        return tt.toString();
    }

    public static String stripInvalidTagCharacters(String tag) {
        if (tag == null) {
            throw new NullPointerException();
        }
        StringBuffer sb = new StringBuffer();
        char[] charArray = tag.toCharArray();
        block3: for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            switch (c) {
                case '\"': 
                case ',': {
                    continue block3;
                }
                default: {
                    if (('!' > c || c > '~') && !Character.isUnicodeIdentifierPart(c) && !Character.isUnicodeIdentifierStart(c)) continue block3;
                    sb.append(charArray[i]);
                }
            }
        }
        return sb.toString();
    }

    public static String normalizeTag(String tag, Locale locale) {
        tag = Utilities.stripInvalidTagCharacters(tag);
        return locale == null ? tag.toLowerCase() : tag.toLowerCase(locale);
    }

    public static List splitStringAsTags(String tags) {
        String[] tagsarr = StringUtils.split((String)tags, (String)TAG_SPLIT_CHARS);
        if (tagsarr == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(tagsarr);
    }
}

