/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.planet.util.Utilities;
import org.apache.roller.util.DateUtil;
import org.apache.roller.util.RegexUtil;

public class OldUtilities {
    private static Log mLogger = LogFactory.getLog(OldUtilities.class);
    private static Pattern mLinkPattern = Pattern.compile("<a href=.*?>", 2);
    private static final Pattern OPENING_B_TAG_PATTERN = Pattern.compile("&lt;b&gt;", 2);
    private static final Pattern CLOSING_B_TAG_PATTERN = Pattern.compile("&lt;/b&gt;", 2);
    private static final Pattern OPENING_I_TAG_PATTERN = Pattern.compile("&lt;i&gt;", 2);
    private static final Pattern CLOSING_I_TAG_PATTERN = Pattern.compile("&lt;/i&gt;", 2);
    private static final Pattern OPENING_BLOCKQUOTE_TAG_PATTERN = Pattern.compile("&lt;blockquote&gt;", 2);
    private static final Pattern CLOSING_BLOCKQUOTE_TAG_PATTERN = Pattern.compile("&lt;/blockquote&gt;", 2);
    private static final Pattern BR_TAG_PATTERN = Pattern.compile("&lt;br */*&gt;", 2);
    private static final Pattern OPENING_P_TAG_PATTERN = Pattern.compile("&lt;p&gt;", 2);
    private static final Pattern CLOSING_P_TAG_PATTERN = Pattern.compile("&lt;/p&gt;", 2);
    private static final Pattern OPENING_PRE_TAG_PATTERN = Pattern.compile("&lt;pre&gt;", 2);
    private static final Pattern CLOSING_PRE_TAG_PATTERN = Pattern.compile("&lt;/pre&gt;", 2);
    private static final Pattern OPENING_UL_TAG_PATTERN = Pattern.compile("&lt;ul&gt;", 2);
    private static final Pattern CLOSING_UL_TAG_PATTERN = Pattern.compile("&lt;/ul&gt;", 2);
    private static final Pattern OPENING_OL_TAG_PATTERN = Pattern.compile("&lt;ol&gt;", 2);
    private static final Pattern CLOSING_OL_TAG_PATTERN = Pattern.compile("&lt;/ol&gt;", 2);
    private static final Pattern OPENING_LI_TAG_PATTERN = Pattern.compile("&lt;li&gt;", 2);
    private static final Pattern CLOSING_LI_TAG_PATTERN = Pattern.compile("&lt;/li&gt;", 2);
    private static final Pattern CLOSING_A_TAG_PATTERN = Pattern.compile("&lt;/a&gt;", 2);
    private static final Pattern OPENING_A_TAG_PATTERN = Pattern.compile("&lt;a href=.*?&gt;", 2);
    private static final Pattern QUOTE_PATTERN = Pattern.compile("&quot;", 2);

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        return "".equals(str.trim());
    }

    public static boolean isNotEmpty(String str) {
        return !OldUtilities.isEmpty(str);
    }

    public static String[] split(String str1, String str2) {
        return StringUtils.split((String)str1, (String)str2);
    }

    public static String replace(String src, String target, String rWith) {
        return StringUtils.replace((String)src, (String)target, (String)rWith);
    }

    public static String replace(String src, String target, String rWith, int maxCount) {
        return StringUtils.replace((String)src, (String)target, (String)rWith, (int)maxCount);
    }

    public static boolean equals(String str1, String str2) {
        return StringUtils.equals((String)str1, (String)str2);
    }

    public static boolean isAlphanumeric(String str) {
        return StringUtils.isAlphanumeric((String)str);
    }

    public static String[] stripAll(String[] strs) {
        return StringUtils.stripAll((String[])strs);
    }

    public static String left(String str, int length) {
        return StringUtils.left((String)str, (int)length);
    }

    public static String escapeHTML(String str) {
        return StringEscapeUtils.escapeHtml((String)str);
    }

    public static String unescapeHTML(String str) {
        return StringEscapeUtils.unescapeHtml((String)str);
    }

    public static String removeHTML(String str) {
        return OldUtilities.removeHTML(str, true);
    }

    public static String removeHTML(String str, boolean addSpace) {
        return Utilities.removeHTML(str, addSpace);
    }

    public static String autoformat(String s) {
        String ret = StringUtils.replace((String)s, (String)"\n", (String)"<br />");
        return ret;
    }

    public static Date getNow() {
        return new Date();
    }

    public static String formatDate(Date d, String fmt) {
        SimpleDateFormat format = new SimpleDateFormat(fmt);
        return format.format(d);
    }

    public static String formatIso8601Date(Date d) {
        return DateUtil.formatIso8601((Date)d);
    }

    public static String formatIso8601Day(Date d) {
        return DateUtil.formatIso8601Day((Date)d);
    }

    public static String formatRfc822Date(Date date) {
        return DateUtil.formatRfc822((Date)date);
    }

    public static String format8charsDate(Date date) {
        return DateUtil.format8chars((Date)date);
    }

    public static String truncate(String str, int lower, int upper, String appendToEnd) {
        String str2 = OldUtilities.removeHTML(str, false);
        if (upper < lower) {
            upper = lower;
        }
        if (str2.length() > upper) {
            int loc = str2.lastIndexOf(32, upper);
            if (loc >= lower) {
                str2 = str2.substring(0, loc);
            } else {
                str2 = str2.substring(0, upper);
                loc = upper;
            }
            str2 = str2 + appendToEnd;
        }
        return str2;
    }

    public static String truncateNicely(String str, int lower, int upper, String appendToEnd) {
        return Utilities.truncateNicely(str, lower, upper, appendToEnd);
    }

    public static String truncateText(String str, int lower, int upper, String appendToEnd) {
        boolean diff;
        String str2 = OldUtilities.removeHTML(str, false);
        boolean bl = diff = str2.length() < str.length();
        if (upper < lower) {
            upper = lower;
        }
        if (str2.length() > upper) {
            int loc = str2.lastIndexOf(32, upper);
            if (loc >= lower) {
                str2 = str2.substring(0, loc);
            } else {
                str2 = str2.substring(0, upper);
                loc = upper;
            }
            str = str2 + appendToEnd;
        }
        return str;
    }

    public static String hexEncode(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        return RegexUtil.encode((String)str);
    }

    public static String encodeEmail(String str) {
        return str != null ? RegexUtil.encodeEmail((String)str) : null;
    }

    public static final String encode(String s) {
        try {
            if (s != null) {
                return URLEncoder.encode(s, "UTF-8");
            }
            return s;
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public static final String decode(String s) {
        try {
            if (s != null) {
                return URLDecoder.decode(s, "UTF-8");
            }
            return s;
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public static String addNofollow(String html) {
        if (html == null || html.length() == 0) {
            return html;
        }
        Matcher m = mLinkPattern.matcher(html);
        StringBuffer buf = new StringBuffer();
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            String link = html.substring(start, end);
            buf.append(html.substring(0, start));
            if (link.indexOf("rel=\"nofollow\"") == -1) {
                buf.append(link.substring(0, link.length() - 1) + " rel=\"nofollow\">");
            } else {
                buf.append(link);
            }
            html = html.substring(end, html.length());
            m = mLinkPattern.matcher(html);
        }
        buf.append(html);
        return buf.toString();
    }

    public static String transformToHTMLSubset(String s) {
        if (s == null) {
            return null;
        }
        s = OldUtilities.replace(s, OPENING_B_TAG_PATTERN, "<b>");
        s = OldUtilities.replace(s, CLOSING_B_TAG_PATTERN, "</b>");
        s = OldUtilities.replace(s, OPENING_I_TAG_PATTERN, "<i>");
        s = OldUtilities.replace(s, CLOSING_I_TAG_PATTERN, "</i>");
        s = OldUtilities.replace(s, OPENING_BLOCKQUOTE_TAG_PATTERN, "<blockquote>");
        s = OldUtilities.replace(s, CLOSING_BLOCKQUOTE_TAG_PATTERN, "</blockquote>");
        s = OldUtilities.replace(s, BR_TAG_PATTERN, "<br />");
        s = OldUtilities.replace(s, OPENING_P_TAG_PATTERN, "<p>");
        s = OldUtilities.replace(s, CLOSING_P_TAG_PATTERN, "</p>");
        s = OldUtilities.replace(s, OPENING_PRE_TAG_PATTERN, "<pre>");
        s = OldUtilities.replace(s, CLOSING_PRE_TAG_PATTERN, "</pre>");
        s = OldUtilities.replace(s, OPENING_UL_TAG_PATTERN, "<ul>");
        s = OldUtilities.replace(s, CLOSING_UL_TAG_PATTERN, "</ul>");
        s = OldUtilities.replace(s, OPENING_OL_TAG_PATTERN, "<ol>");
        s = OldUtilities.replace(s, CLOSING_OL_TAG_PATTERN, "</ol>");
        s = OldUtilities.replace(s, OPENING_LI_TAG_PATTERN, "<li>");
        s = OldUtilities.replace(s, CLOSING_LI_TAG_PATTERN, "</li>");
        s = OldUtilities.replace(s, QUOTE_PATTERN, "\"");
        s = OldUtilities.replace(s, CLOSING_A_TAG_PATTERN, "</a>");
        Matcher m = OPENING_A_TAG_PATTERN.matcher(s);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            String link = s.substring(start, end);
            link = "<" + link.substring(4, link.length() - 4) + ">";
            s = s.substring(0, start) + link + s.substring(end, s.length());
            m = OPENING_A_TAG_PATTERN.matcher(s);
        }
        s = s.replaceAll("&amp;lt;", "&lt;");
        s = s.replaceAll("&amp;gt;", "&gt;");
        s = s.replaceAll("&amp;#", "&#");
        return s;
    }

    private static String replace(String string, Pattern pattern, String replacement) {
        Matcher m = pattern.matcher(string);
        return m.replaceAll(replacement);
    }

    public static String toBase64(byte[] aValue) {
        String m_strBase64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        int iByteLen = aValue.length;
        StringBuffer tt = new StringBuffer();
        for (int i = 0; i < iByteLen; i += 3) {
            boolean bByte2 = i + 1 < iByteLen;
            boolean bByte3 = i + 2 < iByteLen;
            int byte1 = aValue[i] & 0xFF;
            int byte2 = bByte2 ? aValue[i + 1] & 0xFF : 0;
            int byte3 = bByte3 ? aValue[i + 2] & 0xFF : 0;
            tt.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(byte1 / 4));
            tt.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(byte2 / 16 + (byte1 & 3) * 16));
            tt.append(bByte2 ? "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(byte3 / 64 + (byte2 & 0xF) * 4) : (char)'=');
            tt.append(bByte3 ? "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(byte3 & 0x3F) : (char)'=');
        }
        return tt.toString();
    }

    public static String escapeHTML(String s, boolean escapeAmpersand) {
        return Utilities.escapeHTML(s, escapeAmpersand);
    }

    public static String stringReplace(String str, String str1, String str2) {
        String ret = StringUtils.replace((String)str, (String)str1, (String)str2);
        return ret;
    }

    public static String stringReplace(String str, String str1, String str2, int maxCount) {
        String ret = StringUtils.replace((String)str, (String)str1, (String)str2, (int)maxCount);
        return ret;
    }

    public static String encodeString(String str) throws IOException {
        String encodedStr = new String(Base64.encodeBase64((byte[])str.getBytes()));
        return encodedStr.trim();
    }

    public static String decodeString(String str) throws IOException {
        String value = new String(Base64.decodeBase64((byte[])str.getBytes()));
        return value;
    }

    private static String stripLineBreaks(String str) {
        str = str.replaceAll("<br>", "");
        str = str.replaceAll("<br/>", "");
        str = str.replaceAll("<br />", "");
        str = str.replaceAll("<p></p>", "");
        str = str.replaceAll("<p/>", "");
        str = str.replaceAll("<p />", "");
        return str;
    }

    private static String removeVisibleHTMLTags(String str) {
        int stringIndex;
        str = OldUtilities.stripLineBreaks(str);
        StringBuffer result = new StringBuffer(str);
        StringBuffer lcresult = new StringBuffer(str.toLowerCase());
        String[] visibleTags = new String[]{"<img"};
        for (int j = 0; j < visibleTags.length; ++j) {
            while ((stringIndex = lcresult.indexOf(visibleTags[j])) != -1) {
                if (visibleTags[j].endsWith(">")) {
                    result.delete(stringIndex, stringIndex + visibleTags[j].length());
                    lcresult.delete(stringIndex, stringIndex + visibleTags[j].length());
                    continue;
                }
                int endIndex = result.indexOf(">", stringIndex);
                if (endIndex <= -1) continue;
                result.delete(stringIndex, endIndex + 1);
                lcresult.delete(stringIndex, endIndex + 1);
            }
        }
        String[] openCloseTags = new String[]{"li", "a", "div", "h1", "h2", "h3", "h4"};
        for (int j = 0; j < openCloseTags.length; ++j) {
            String closeTag = "</" + openCloseTags[j] + ">";
            int lastStringIndex = 0;
            while ((stringIndex = lcresult.indexOf("<" + openCloseTags[j], lastStringIndex)) > -1) {
                lastStringIndex = stringIndex;
                int endIndex = lcresult.indexOf(closeTag, stringIndex);
                if (endIndex > -1) {
                    result.delete(stringIndex, endIndex + closeTag.length());
                    lcresult.delete(stringIndex, endIndex + closeTag.length());
                    continue;
                }
                endIndex = lcresult.indexOf(">", stringIndex);
                int nextStart = lcresult.indexOf("<", stringIndex + 1);
                if (endIndex <= stringIndex || lcresult.charAt(endIndex - 1) != '/' || endIndex >= nextStart && nextStart != -1) continue;
                result.delete(stringIndex, endIndex + 1);
                lcresult.delete(stringIndex, endIndex + 1);
            }
        }
        return result.toString();
    }

    public static final String charToHTML(char ch, boolean xml) {
        if (ch == '<') {
            return "&lt;";
        }
        if (ch == '>') {
            return "&gt;";
        }
        if (ch == '&') {
            return "&amp;";
        }
        if (xml && ch == '\"') {
            return "&quot;";
        }
        if (xml && ch == '\'') {
            return "&#39;";
        }
        return String.valueOf(ch);
    }

    public static final String textToHTML(String text, boolean xml) {
        if (text == null) {
            return "null";
        }
        StringBuffer html = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            html.append(OldUtilities.charToHTML(text.charAt(i), xml));
        }
        return html.toString();
    }

    public static final String textToHTML(String text) {
        return OldUtilities.textToHTML(text, false);
    }

    public static final String textToXML(String text) {
        return OldUtilities.textToHTML(text, true);
    }

    public static final String textToCDATA(String text) {
        if (text == null) {
            return "null";
        }
        StringBuffer html = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            html.append(OldUtilities.charToCDATA(text.charAt(i)));
        }
        return html.toString();
    }

    public static final String charToCDATA(char ch) {
        if (ch >= '\u0080') {
            char c = ch;
            return "&#" + c + ';';
        }
        return String.valueOf(ch);
    }
}

