/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.planet.util.Utilities;
import org.apache.roller.util.DateUtil;
import org.apache.roller.util.RegexUtil;

public class UtilitiesModel {
    private static Log log = LogFactory.getLog(UtilitiesModel.class);
    private static Pattern mLinkPattern = Pattern.compile("<a href=.*?>", 2);
    private static final Pattern OPENING_B_TAG_PATTERN = Pattern.compile("&lt;b&gt;", 2);
    private static final Pattern CLOSING_B_TAG_PATTERN = Pattern.compile("&lt;/b&gt;", 2);
    private static final Pattern OPENING_I_TAG_PATTERN = Pattern.compile("&lt;i&gt;", 2);
    private static final Pattern CLOSING_I_TAG_PATTERN = Pattern.compile("&lt;/i&gt;", 2);
    private static final Pattern OPENING_BLOCKQUOTE_TAG_PATTERN = Pattern.compile("&lt;blockquote&gt;", 2);
    private static final Pattern CLOSING_BLOCKQUOTE_TAG_PATTERN = Pattern.compile("&lt;/blockquote&gt;", 2);
    private static final Pattern BR_TAG_PATTERN = Pattern.compile("&lt;br */*&gt;", 2);
    private static final Pattern OPENING_P_TAG_PATTERN = Pattern.compile("&lt;p&gt;", 2);
    private static final Pattern CLOSING_P_TAG_PATTERN = Pattern.compile("&lt;/p&gt;", 2);
    private static final Pattern OPENING_PRE_TAG_PATTERN = Pattern.compile("&lt;pre&gt;", 2);
    private static final Pattern CLOSING_PRE_TAG_PATTERN = Pattern.compile("&lt;/pre&gt;", 2);
    private static final Pattern OPENING_UL_TAG_PATTERN = Pattern.compile("&lt;ul&gt;", 2);
    private static final Pattern CLOSING_UL_TAG_PATTERN = Pattern.compile("&lt;/ul&gt;", 2);
    private static final Pattern OPENING_OL_TAG_PATTERN = Pattern.compile("&lt;ol&gt;", 2);
    private static final Pattern CLOSING_OL_TAG_PATTERN = Pattern.compile("&lt;/ol&gt;", 2);
    private static final Pattern OPENING_LI_TAG_PATTERN = Pattern.compile("&lt;li&gt;", 2);
    private static final Pattern CLOSING_LI_TAG_PATTERN = Pattern.compile("&lt;/li&gt;", 2);
    private static final Pattern CLOSING_A_TAG_PATTERN = Pattern.compile("&lt;/a&gt;", 2);
    private static final Pattern OPENING_A_TAG_PATTERN = Pattern.compile("&lt;a href=.*?&gt;", 2);
    private static final Pattern QUOTE_PATTERN = Pattern.compile("&quot;", 2);
    private TimeZone tz = null;

    public String getModelName() {
        return "utils";
    }

    public static Date getNow() {
        return new Date();
    }

    public String formatDate(Date d, String fmt) {
        if (d == null || fmt == null) {
            return fmt;
        }
        SimpleDateFormat format = new SimpleDateFormat(fmt);
        if (this.tz != null) {
            format.setTimeZone(this.tz);
        }
        return format.format(d);
    }

    public static String formatDate(Date d, String fmt, TimeZone tzOverride) {
        if (d == null || fmt == null) {
            return fmt;
        }
        SimpleDateFormat format = new SimpleDateFormat(fmt);
        format.setTimeZone(tzOverride);
        return format.format(d);
    }

    public static String formatIso8601Date(Date d) {
        return DateUtil.formatIso8601((Date)d);
    }

    public static String formatIso8601Day(Date d) {
        return DateUtil.formatIso8601Day((Date)d);
    }

    public static String formatRfc822Date(Date date) {
        return DateUtil.formatRfc822((Date)date);
    }

    public static String format8charsDate(Date date) {
        return DateUtil.format8chars((Date)date);
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        return "".equals(str.trim());
    }

    public static boolean isNotEmpty(String str) {
        return !UtilitiesModel.isEmpty(str);
    }

    public static String[] split(String str1, String str2) {
        return StringUtils.split((String)str1, (String)str2);
    }

    public static boolean equals(String str1, String str2) {
        return StringUtils.equals((String)str1, (String)str2);
    }

    public static boolean isAlphanumeric(String str) {
        return StringUtils.isAlphanumeric((String)str);
    }

    public static String[] stripAll(String[] strs) {
        return StringUtils.stripAll((String[])strs);
    }

    public static String left(String str, int length) {
        return StringUtils.left((String)str, (int)length);
    }

    public static String escapeHTML(String str) {
        return StringEscapeUtils.escapeHtml((String)str);
    }

    public static String unescapeHTML(String str) {
        return StringEscapeUtils.unescapeHtml((String)str);
    }

    public static String escapeXML(String str) {
        return StringEscapeUtils.escapeXml((String)str);
    }

    public static String unescapeXML(String str) {
        return StringEscapeUtils.unescapeXml((String)str);
    }

    public static String replace(String src, String target, String rWith) {
        return StringUtils.replace((String)src, (String)target, (String)rWith);
    }

    public static String replace(String src, String target, String rWith, int maxCount) {
        return StringUtils.replace((String)src, (String)target, (String)rWith, (int)maxCount);
    }

    private static String replace(String string, Pattern pattern, String replacement) {
        Matcher m = pattern.matcher(string);
        return m.replaceAll(replacement);
    }

    public static String removeHTML(String str) {
        return UtilitiesModel.removeHTML(str, true);
    }

    public static String removeHTML(String str, boolean addSpace) {
        return Utilities.removeHTML(str, addSpace);
    }

    public static String autoformat(String s) {
        String ret = StringUtils.replace((String)s, (String)"\n", (String)"<br />");
        return ret;
    }

    public static String truncate(String str, int lower, int upper, String appendToEnd) {
        String str2 = UtilitiesModel.removeHTML(str, false);
        if (upper < lower) {
            upper = lower;
        }
        if (str2.length() > upper) {
            int loc = str2.lastIndexOf(32, upper);
            if (loc >= lower) {
                str2 = str2.substring(0, loc);
            } else {
                str2 = str2.substring(0, upper);
                loc = upper;
            }
            str2 = str2 + appendToEnd;
        }
        return str2;
    }

    public static String truncateNicely(String str, int lower, int upper, String appendToEnd) {
        return Utilities.truncateNicely(str, lower, upper, appendToEnd);
    }

    public static String truncateText(String str, int lower, int upper, String appendToEnd) {
        boolean diff;
        String str2 = UtilitiesModel.removeHTML(str, false);
        boolean bl = diff = str2.length() < str.length();
        if (upper < lower) {
            upper = lower;
        }
        if (str2.length() > upper) {
            int loc = str2.lastIndexOf(32, upper);
            if (loc >= lower) {
                str2 = str2.substring(0, loc);
            } else {
                str2 = str2.substring(0, upper);
                loc = upper;
            }
            str = str2 + appendToEnd;
        }
        return str;
    }

    public static String hexEncode(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        return RegexUtil.encode((String)str);
    }

    public static String encodeEmail(String str) {
        return str != null ? RegexUtil.encodeEmail((String)str) : null;
    }

    public static final String encode(String s) {
        try {
            if (s != null) {
                return URLEncoder.encode(s, "UTF-8");
            }
            return s;
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public static final String decode(String s) {
        try {
            if (s != null) {
                return URLDecoder.decode(s, "UTF-8");
            }
            return s;
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public static String addNofollow(String html) {
        if (html == null || html.length() == 0) {
            return html;
        }
        Matcher m = mLinkPattern.matcher(html);
        StringBuffer buf = new StringBuffer();
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            String link = html.substring(start, end);
            buf.append(html.substring(0, start));
            if (link.indexOf("rel=\"nofollow\"") == -1) {
                buf.append(link.substring(0, link.length() - 1) + " rel=\"nofollow\">");
            } else {
                buf.append(link);
            }
            html = html.substring(end, html.length());
            m = mLinkPattern.matcher(html);
        }
        buf.append(html);
        return buf.toString();
    }

    public static String transformToHTMLSubset(String s) {
        if (s == null) {
            return null;
        }
        s = UtilitiesModel.replace(s, OPENING_B_TAG_PATTERN, "<b>");
        s = UtilitiesModel.replace(s, CLOSING_B_TAG_PATTERN, "</b>");
        s = UtilitiesModel.replace(s, OPENING_I_TAG_PATTERN, "<i>");
        s = UtilitiesModel.replace(s, CLOSING_I_TAG_PATTERN, "</i>");
        s = UtilitiesModel.replace(s, OPENING_BLOCKQUOTE_TAG_PATTERN, "<blockquote>");
        s = UtilitiesModel.replace(s, CLOSING_BLOCKQUOTE_TAG_PATTERN, "</blockquote>");
        s = UtilitiesModel.replace(s, BR_TAG_PATTERN, "<br />");
        s = UtilitiesModel.replace(s, OPENING_P_TAG_PATTERN, "<p>");
        s = UtilitiesModel.replace(s, CLOSING_P_TAG_PATTERN, "</p>");
        s = UtilitiesModel.replace(s, OPENING_PRE_TAG_PATTERN, "<pre>");
        s = UtilitiesModel.replace(s, CLOSING_PRE_TAG_PATTERN, "</pre>");
        s = UtilitiesModel.replace(s, OPENING_UL_TAG_PATTERN, "<ul>");
        s = UtilitiesModel.replace(s, CLOSING_UL_TAG_PATTERN, "</ul>");
        s = UtilitiesModel.replace(s, OPENING_OL_TAG_PATTERN, "<ol>");
        s = UtilitiesModel.replace(s, CLOSING_OL_TAG_PATTERN, "</ol>");
        s = UtilitiesModel.replace(s, OPENING_LI_TAG_PATTERN, "<li>");
        s = UtilitiesModel.replace(s, CLOSING_LI_TAG_PATTERN, "</li>");
        s = UtilitiesModel.replace(s, QUOTE_PATTERN, "\"");
        s = UtilitiesModel.replace(s, CLOSING_A_TAG_PATTERN, "</a>");
        Matcher m = OPENING_A_TAG_PATTERN.matcher(s);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            String link = s.substring(start, end);
            link = "<" + link.substring(4, link.length() - 4) + ">";
            s = s.substring(0, start) + link + s.substring(end, s.length());
            m = OPENING_A_TAG_PATTERN.matcher(s);
        }
        s = s.replaceAll("&amp;lt;", "&lt;");
        s = s.replaceAll("&amp;gt;", "&gt;");
        s = s.replaceAll("&amp;#", "&#");
        return s;
    }

    public static String toBase64(byte[] aValue) {
        String m_strBase64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        int iByteLen = aValue.length;
        StringBuffer tt = new StringBuffer();
        for (int i = 0; i < iByteLen; i += 3) {
            boolean bByte2 = i + 1 < iByteLen;
            boolean bByte3 = i + 2 < iByteLen;
            int byte1 = aValue[i] & 0xFF;
            int byte2 = bByte2 ? aValue[i + 1] & 0xFF : 0;
            int byte3 = bByte3 ? aValue[i + 2] & 0xFF : 0;
            tt.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(byte1 / 4));
            tt.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(byte2 / 16 + (byte1 & 3) * 16));
            tt.append(bByte2 ? "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(byte3 / 64 + (byte2 & 0xF) * 4) : (char)'=');
            tt.append(bByte3 ? "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(byte3 & 0x3F) : (char)'=');
        }
        return tt.toString();
    }
}

