/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.ejb;

import com.mockrunner.base.VerifyFailedException;
import com.mockrunner.mock.ejb.EJBMockObjectFactory;
import com.mockrunner.mock.ejb.MockUserTransaction;
import com.mockrunner.util.common.ClassUtil;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mockejb.BasicEjbDescriptor;
import org.mockejb.EntityBeanDescriptor;
import org.mockejb.MDBDescriptor;
import org.mockejb.SessionBeanDescriptor;
import org.mockejb.TransactionManager;
import org.mockejb.TransactionPolicy;
import org.mockejb.interceptor.AspectSystemFactory;
import org.mockejb.interceptor.ClassPointcut;
import org.mockejb.interceptor.Interceptor;
import org.mockejb.interceptor.Pointcut;

public class EJBTestModule {
    private static final Log log = LogFactory.getLog((Class)(class$com$mockrunner$ejb$EJBTestModule == null ? (class$com$mockrunner$ejb$EJBTestModule = EJBTestModule.class$("com.mockrunner.ejb.EJBTestModule")) : class$com$mockrunner$ejb$EJBTestModule));
    private EJBMockObjectFactory mockFactory;
    private String impSuffix;
    private String homeInterfaceSuffix;
    private String businessInterfaceSuffix;
    private String homeInterfacePackage;
    private String businessInterfacePackage;
    static /* synthetic */ Class class$com$mockrunner$ejb$EJBTestModule;
    static /* synthetic */ Class class$javax$ejb$EJBHome;
    static /* synthetic */ Class class$javax$ejb$EJBLocalHome;

    public EJBTestModule(EJBMockObjectFactory eJBMockObjectFactory) {
        this.mockFactory = eJBMockObjectFactory;
        this.impSuffix = "Bean";
        this.homeInterfaceSuffix = "Home";
        this.businessInterfaceSuffix = "";
    }

    public void setImplementationSuffix(String string) {
        this.impSuffix = string;
    }

    public void setBusinessInterfaceSuffix(String string) {
        this.businessInterfaceSuffix = string;
    }

    public void setHomeInterfaceSuffix(String string) {
        this.homeInterfaceSuffix = string;
    }

    public void setInterfacePackage(String string) {
        this.setHomeInterfacePackage(string);
        this.setBusinessInterfacePackage(string);
    }

    public void setHomeInterfacePackage(String string) {
        this.homeInterfacePackage = string;
    }

    public void setBusinessInterfacePackage(String string) {
        this.businessInterfacePackage = string;
    }

    public void deploy(BasicEjbDescriptor basicEjbDescriptor) {
        this.deploy(basicEjbDescriptor, TransactionPolicy.SUPPORTS);
    }

    public void deploy(BasicEjbDescriptor basicEjbDescriptor, TransactionPolicy transactionPolicy) {
        try {
            if (basicEjbDescriptor instanceof SessionBeanDescriptor) {
                this.mockFactory.getMockContainer().deploy((SessionBeanDescriptor)basicEjbDescriptor);
            } else if (basicEjbDescriptor instanceof EntityBeanDescriptor) {
                this.mockFactory.getMockContainer().deploy((EntityBeanDescriptor)basicEjbDescriptor);
            } else if (basicEjbDescriptor instanceof MDBDescriptor) {
                this.mockFactory.getMockContainer().deploy((MDBDescriptor)basicEjbDescriptor);
            }
            AspectSystemFactory.getAspectSystem().add((Pointcut)new ClassPointcut(basicEjbDescriptor.getIfaceClass(), false), (Interceptor)new TransactionManager(transactionPolicy));
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public void deploySessionBean(String string, Class clazz) {
        this.deploySessionBean(string, clazz, false, TransactionPolicy.SUPPORTS);
    }

    public void deploySessionBean(String string, Class clazz, boolean bl) {
        this.deploySessionBean(string, clazz, bl, TransactionPolicy.SUPPORTS);
    }

    public void deploySessionBean(String string, Class clazz, TransactionPolicy transactionPolicy) {
        this.deploySessionBean(string, clazz, false, transactionPolicy);
    }

    public void deploySessionBean(String string, Class clazz, boolean bl, TransactionPolicy transactionPolicy) {
        SessionBeanDescriptor sessionBeanDescriptor = new SessionBeanDescriptor(string, this.getHomeClass(clazz), this.getRemoteClass(clazz), clazz);
        sessionBeanDescriptor.setStateful(bl);
        this.deploy((BasicEjbDescriptor)sessionBeanDescriptor, transactionPolicy);
    }

    public void deploySessionBean(String string, Object object) {
        this.deploySessionBean(string, object, false, TransactionPolicy.SUPPORTS);
    }

    public void deploySessionBean(String string, Object object, boolean bl) {
        this.deploySessionBean(string, object, bl, TransactionPolicy.SUPPORTS);
    }

    public void deploySessionBean(String string, Object object, TransactionPolicy transactionPolicy) {
        this.deploySessionBean(string, object, false, transactionPolicy);
    }

    public void deploySessionBean(String string, Object object, boolean bl, TransactionPolicy transactionPolicy) {
        SessionBeanDescriptor sessionBeanDescriptor = new SessionBeanDescriptor(string, this.getHomeClass(object.getClass()), this.getRemoteClass(object.getClass()), object);
        sessionBeanDescriptor.setStateful(bl);
        this.deploy((BasicEjbDescriptor)sessionBeanDescriptor, transactionPolicy);
    }

    public void deployEntityBean(String string, Class clazz) {
        this.deployEntityBean(string, clazz, TransactionPolicy.SUPPORTS);
    }

    public void deployEntityBean(String string, Class clazz, TransactionPolicy transactionPolicy) {
        EntityBeanDescriptor entityBeanDescriptor = new EntityBeanDescriptor(string, this.getHomeClass(clazz), this.getRemoteClass(clazz), clazz);
        this.deploy((BasicEjbDescriptor)entityBeanDescriptor, transactionPolicy);
    }

    public void deployMessageBean(String string, String string2, ConnectionFactory connectionFactory, Destination destination, Object object) {
        this.deployMessageBean(string, string2, connectionFactory, destination, object, TransactionPolicy.NOT_SUPPORTED);
    }

    public void deployMessageBean(String string, String string2, ConnectionFactory connectionFactory, Destination destination, Object object, TransactionPolicy transactionPolicy) {
        this.bindToContext(string, connectionFactory);
        this.bindToContext(string2, destination);
        MDBDescriptor mDBDescriptor = new MDBDescriptor(string, string2, object);
        mDBDescriptor.setIsAlreadyBound(true);
        mDBDescriptor.setIsTopic(destination instanceof Topic);
        this.deploy((BasicEjbDescriptor)mDBDescriptor, transactionPolicy);
    }

    public void bindToContext(String string, Object object) {
        try {
            InitialContext initialContext = new InitialContext();
            initialContext.rebind(string, object);
        }
        catch (NamingException namingException) {
            throw new RuntimeException("Object with name " + string + " not found.");
        }
    }

    public Object lookup(String string) {
        try {
            InitialContext initialContext = new InitialContext();
            return initialContext.lookup(string);
        }
        catch (NamingException namingException) {
            throw new RuntimeException("Object with name " + string + " not found.");
        }
    }

    public Object lookupBean(String string) {
        return this.createBean(string);
    }

    public Object createBean(String string) {
        return this.createBean(string, new Object[0]);
    }

    public Object lookupBean(String string, Object[] objectArray) {
        return this.createBean(string, objectArray);
    }

    public Object createBean(String string, Object[] objectArray) {
        return this.createBean(string, "create", objectArray);
    }

    public Object lookupBean(String string, String string2, Object[] objectArray) {
        return this.createBean(string, string2, objectArray);
    }

    public Object createBean(String string, String string2, Object[] objectArray) {
        Object object = this.lookupHome(string);
        return this.invokeHomeMethod(object, string2, objectArray, null);
    }

    public Object createBean(String string, String string2, Object[] objectArray, Class[] classArray) {
        Object object = this.lookupHome(string);
        return this.invokeHomeMethod(object, string2, objectArray, classArray);
    }

    public Object createEntityBean(String string, Object object) {
        return this.createEntityBean(string, new Object[0], object);
    }

    public Object createEntityBean(String string, Object[] objectArray, Object object) {
        return this.createEntityBean(string, "create", objectArray, object);
    }

    public Object createEntityBean(String string, String string2, Object[] objectArray, Object object) {
        return this.createEntityBean(string, string2, objectArray, null, object);
    }

    public Object createEntityBean(String string, String string2, Object[] objectArray, Class[] classArray, Object object) {
        Object object2 = this.lookupHome(string);
        Object object3 = this.invokeHomeMethod(object2, string2, objectArray, classArray);
        Class[] classArray2 = object2.getClass().getInterfaces();
        Class clazz = this.getHomeInterfaceClass(classArray2);
        if (null != clazz && null != object3) {
            this.mockFactory.getMockContainer().getEntityDatabase().add(clazz, object, object3);
        }
        return object3;
    }

    public Object findByPrimaryKey(String string, Object object) {
        Object object2 = this.lookupHome(string);
        return this.invokeHomeMethod(object2, "findByPrimaryKey", new Object[]{object}, null);
    }

    private Class getHomeInterfaceClass(Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz;
            if (!(class$javax$ejb$EJBHome == null ? EJBTestModule.class$("javax.ejb.EJBHome") : class$javax$ejb$EJBHome).isAssignableFrom(clazz = classArray[i]) && !(class$javax$ejb$EJBLocalHome == null ? EJBTestModule.class$("javax.ejb.EJBLocalHome") : class$javax$ejb$EJBLocalHome).isAssignableFrom(clazz)) continue;
            return clazz;
        }
        return null;
    }

    private Object lookupHome(String string) {
        Object object = this.lookup(string);
        if (null == object) {
            return null;
        }
        if (!(object instanceof EJBHome) && !(object instanceof EJBLocalHome)) {
            return null;
        }
        return object;
    }

    private Object invokeHomeMethod(Object object, String string, Object[] objectArray, Class[] classArray) {
        if (null == classArray) {
            this.checkNullParameters(string, objectArray);
        }
        try {
            if (null == classArray) {
                return MethodUtils.invokeMethod((Object)object, (String)string, (Object[])objectArray);
            }
            return MethodUtils.invokeExactMethod((Object)object, (String)string, (Object[])objectArray, (Class[])classArray);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private void checkNullParameters(String string, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (null != objectArray[i]) continue;
            String string2 = "Calling method " + string + " failed. ";
            string2 = string2 + "Null is not allowed if the parameter types are not specified.";
            throw new IllegalArgumentException(string2);
        }
    }

    public void resetUserTransaction() {
        MockUserTransaction mockUserTransaction = this.mockFactory.getMockUserTransaction();
        if (null == mockUserTransaction) {
            return;
        }
        mockUserTransaction.reset();
    }

    public void verifyCommitted() {
        MockUserTransaction mockUserTransaction = this.mockFactory.getMockUserTransaction();
        if (null == mockUserTransaction) {
            throw new VerifyFailedException("MockTransaction is null.");
        }
        if (!mockUserTransaction.wasCommitCalled()) {
            throw new VerifyFailedException("Transaction was not committed.");
        }
    }

    public void verifyNotCommitted() {
        MockUserTransaction mockUserTransaction = this.mockFactory.getMockUserTransaction();
        if (null == mockUserTransaction) {
            throw new VerifyFailedException("MockTransaction is null.");
        }
        if (mockUserTransaction.wasCommitCalled()) {
            throw new VerifyFailedException("Transaction was committed.");
        }
    }

    public void verifyRolledBack() {
        MockUserTransaction mockUserTransaction = this.mockFactory.getMockUserTransaction();
        if (null == mockUserTransaction) {
            throw new VerifyFailedException("MockTransaction is null.");
        }
        if (!mockUserTransaction.wasRollbackCalled()) {
            throw new VerifyFailedException("Transaction was not rolled back");
        }
    }

    public void verifyNotRolledBack() {
        MockUserTransaction mockUserTransaction = this.mockFactory.getMockUserTransaction();
        if (null == mockUserTransaction) {
            throw new VerifyFailedException("MockTransaction is null.");
        }
        if (mockUserTransaction.wasRollbackCalled()) {
            throw new VerifyFailedException("Transaction was rolled back");
        }
    }

    public void verifyMarkedForRollback() {
        MockUserTransaction mockUserTransaction = this.mockFactory.getMockUserTransaction();
        if (null == mockUserTransaction) {
            throw new VerifyFailedException("MockTransaction is null.");
        }
        if (!mockUserTransaction.wasRollbackOnlyCalled()) {
            throw new VerifyFailedException("Transaction was not marked for rollback");
        }
    }

    public void verifyNotMarkedForRollback() {
        MockUserTransaction mockUserTransaction = this.mockFactory.getMockUserTransaction();
        if (null == mockUserTransaction) {
            throw new VerifyFailedException("MockTransaction is null.");
        }
        if (mockUserTransaction.wasRollbackOnlyCalled()) {
            throw new VerifyFailedException("Transaction was marked for rollback");
        }
    }

    private Class getHomeClass(Class clazz) {
        String string = ClassUtil.getPackageName(clazz);
        String string2 = ClassUtil.getClassName(clazz);
        string2 = this.truncateImplClassName(string2);
        if (null != this.homeInterfaceSuffix && 0 != this.homeInterfaceSuffix.length()) {
            string2 = string2 + this.homeInterfaceSuffix;
        }
        if (null != this.homeInterfacePackage && 0 != this.homeInterfacePackage.length()) {
            string = this.homeInterfacePackage;
        }
        try {
            return Class.forName(this.getClassName(string, string2), true, clazz.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Home interface not found: " + classNotFoundException.getMessage());
        }
    }

    private Class getRemoteClass(Class clazz) {
        String string = ClassUtil.getPackageName(clazz);
        String string2 = ClassUtil.getClassName(clazz);
        string2 = this.truncateImplClassName(string2);
        if (null != this.businessInterfaceSuffix && 0 != this.businessInterfaceSuffix.length()) {
            string2 = string2 + this.businessInterfaceSuffix;
        }
        if (null != this.businessInterfacePackage && 0 != this.businessInterfacePackage.length()) {
            string = this.businessInterfacePackage;
        }
        try {
            return Class.forName(this.getClassName(string, string2), true, clazz.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Interface not found: " + classNotFoundException.getMessage());
        }
    }

    private String getClassName(String string, String string2) {
        if (null == string || string.length() == 0) {
            return string2;
        }
        return string + "." + string2;
    }

    private String truncateImplClassName(String string) {
        if (null != this.impSuffix && string.endsWith(this.impSuffix)) {
            string = string.substring(0, string.length() - this.impSuffix.length());
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

