/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.jms.MockMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public class MockBytesMessage
extends MockMessage
implements BytesMessage {
    private DataOutputStream outStream;
    private ByteArrayOutputStream byteOutStream;
    private DataInputStream inStream;

    public MockBytesMessage() {
        try {
            this.clearBody();
        }
        catch (JMSException jMSException) {
            throw new NestedApplicationException(jMSException);
        }
    }

    public long getBodyLength() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        return this.outStream.size();
    }

    public boolean readBoolean() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readBoolean();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(eOFException.getMessage());
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public byte readByte() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readByte();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(eOFException.getMessage());
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public int readUnsignedByte() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readByte();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(eOFException.getMessage());
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public short readShort() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readShort();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(eOFException.getMessage());
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public int readUnsignedShort() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readShort();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(eOFException.getMessage());
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public char readChar() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readChar();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(eOFException.getMessage());
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public int readInt() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readInt();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(eOFException.getMessage());
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public long readLong() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readLong();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(eOFException.getMessage());
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public float readFloat() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readFloat();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(eOFException.getMessage());
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public double readDouble() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readDouble();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(eOFException.getMessage());
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public String readUTF() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.readUTF();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(eOFException.getMessage());
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public int readBytes(byte[] byArray) throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.read(byArray);
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(eOFException.getMessage());
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public int readBytes(byte[] byArray, int n) throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        try {
            return this.inStream.read(byArray, 0, n);
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(eOFException.getMessage());
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public void writeBoolean(boolean bl) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.writeBoolean(bl);
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public void writeByte(byte by) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.writeByte(by);
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public void writeShort(short s) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.writeShort(s);
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public void writeChar(char c) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.writeChar(c);
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public void writeInt(int n) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.writeInt(n);
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public void writeLong(long l) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.writeLong(l);
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public void writeFloat(float f) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.writeFloat(f);
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public void writeDouble(double d) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.writeDouble(d);
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public void writeUTF(String string) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        try {
            this.outStream.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
    }

    public void writeObject(Object object) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        if (object instanceof Byte) {
            this.writeByte((Byte)object);
            return;
        }
        if (object instanceof Short) {
            this.writeShort((Short)object);
            return;
        }
        if (object instanceof Integer) {
            this.writeInt((Integer)object);
            return;
        }
        if (object instanceof Long) {
            this.writeLong((Long)object);
            return;
        }
        if (object instanceof Float) {
            this.writeFloat(((Float)object).floatValue());
            return;
        }
        if (object instanceof Double) {
            this.writeDouble((Double)object);
            return;
        }
        if (object instanceof Character) {
            this.writeChar(((Character)object).charValue());
            return;
        }
        if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
            return;
        }
        if (object instanceof String) {
            this.writeUTF((String)object);
            return;
        }
        if (object instanceof byte[]) {
            this.writeBytes((byte[])object);
            return;
        }
        throw new MessageFormatException(object.getClass().getName() + " is an invalid type");
    }

    public void reset() throws JMSException {
        this.setReadOnly(true);
        try {
            this.outStream.flush();
        }
        catch (IOException iOException) {
            throw new JMSException(iOException.getMessage());
        }
        this.inStream = new DataInputStream(new ByteArrayInputStream(this.byteOutStream.toByteArray()));
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.byteOutStream = new ByteArrayOutputStream();
        this.outStream = new DataOutputStream(this.byteOutStream);
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!(object instanceof MockBytesMessage)) {
            return false;
        }
        MockBytesMessage mockBytesMessage = (MockBytesMessage)object;
        byte[] byArray = this.byteOutStream.toByteArray();
        byte[] byArray2 = mockBytesMessage.byteOutStream.toByteArray();
        return Arrays.equals(byArray, byArray2);
    }

    public int hashCode() {
        int n = 0;
        byte[] byArray = this.byteOutStream.toByteArray();
        for (int i = 0; i < byArray.length; ++i) {
            n += byArray[i];
        }
        return n;
    }

    public Object clone() {
        MockBytesMessage mockBytesMessage = (MockBytesMessage)super.clone();
        try {
            mockBytesMessage.clearBody();
            mockBytesMessage.outStream.write(this.byteOutStream.toByteArray());
            return mockBytesMessage;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }
}

