/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter.mockrunner;

import javax.jms.JMSException;
import javax.jms.Message;
import org.activemq.filter.mockrunner.BinaryExpression;
import org.activemq.filter.mockrunner.BooleanExpression;

public abstract class LogicExpression
extends BinaryExpression
implements BooleanExpression {
    public static BooleanExpression createOR(BooleanExpression booleanExpression, BooleanExpression booleanExpression2) {
        return new LogicExpression(booleanExpression, booleanExpression2){

            public Object evaluate(Message message) throws JMSException {
                Boolean bl = (Boolean)this.left.evaluate(message);
                if (bl != null && bl.booleanValue()) {
                    return Boolean.TRUE;
                }
                Boolean bl2 = (Boolean)this.right.evaluate(message);
                return bl2 == null ? null : bl2;
            }

            public String getExpressionSymbol() {
                return "OR";
            }
        };
    }

    public static BooleanExpression createAND(BooleanExpression booleanExpression, BooleanExpression booleanExpression2) {
        return new LogicExpression(booleanExpression, booleanExpression2){

            public Object evaluate(Message message) throws JMSException {
                Boolean bl = (Boolean)this.left.evaluate(message);
                if (bl == null) {
                    return null;
                }
                if (!bl.booleanValue()) {
                    return Boolean.FALSE;
                }
                Boolean bl2 = (Boolean)this.right.evaluate(message);
                return bl2 == null ? null : bl2;
            }

            protected Object evaluate(Boolean bl, Boolean bl2) {
                return bl != false && bl2 != false ? Boolean.TRUE : Boolean.FALSE;
            }

            public String getExpressionSymbol() {
                return "AND";
            }
        };
    }

    public LogicExpression(BooleanExpression booleanExpression, BooleanExpression booleanExpression2) {
        super(booleanExpression, booleanExpression2);
    }

    public abstract Object evaluate(Message var1) throws JMSException;
}

