/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.adapters;

import org.springframework.security.GrantedAuthority;
import org.springframework.security.adapters.AuthByAdapter;
import org.springframework.security.providers.AbstractAuthenticationToken;

public abstract class AbstractAdapterAuthenticationToken
extends AbstractAuthenticationToken
implements AuthByAdapter {
    private int keyHash;

    protected AbstractAdapterAuthenticationToken() {
        super(null);
    }

    protected AbstractAdapterAuthenticationToken(String key, GrantedAuthority[] authorities) {
        super(authorities);
        this.keyHash = key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractAdapterAuthenticationToken) {
            if (!super.equals(obj)) {
                return false;
            }
            AbstractAdapterAuthenticationToken test = (AbstractAdapterAuthenticationToken)obj;
            return this.getKeyHash() == test.getKeyHash();
        }
        return false;
    }

    public int getKeyHash() {
        return this.keyHash;
    }

    public boolean isAuthenticated() {
        return true;
    }

    public boolean isUserInRole(String role) {
        GrantedAuthority[] authorities = super.getAuthorities();
        for (int i = 0; i < authorities.length; ++i) {
            if (!role.equals(authorities[i].getAuthority())) continue;
            return true;
        }
        return false;
    }

    public void setAuthenticated(boolean ignored) {
    }

    public abstract /* synthetic */ Object getPrincipal();

    public abstract /* synthetic */ Object getCredentials();
}

