/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.ConfigUtils;
import org.springframework.security.config.LdapUserServiceBeanDefinitionParser;
import org.springframework.security.config.PasswordEncoderParser;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class LdapProviderBeanDefinitionParser
implements BeanDefinitionParser {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String ATT_USER_DN_PATTERN = "user-dn-pattern";
    private static final String ATT_USER_PASSWORD = "password-attribute";
    private static final String ATT_HASH = "hash";
    private static final String DEF_USER_SEARCH_FILTER = "uid={0}";
    static /* synthetic */ Class class$org$springframework$security$ldap$search$FilterBasedLdapUserSearch;
    static /* synthetic */ Class class$org$springframework$security$providers$ldap$authenticator$BindAuthenticator;
    static /* synthetic */ Class class$org$springframework$security$providers$ldap$authenticator$PasswordComparisonAuthenticator;
    static /* synthetic */ Class class$org$springframework$security$providers$ldap$LdapAuthenticationProvider;

    public BeanDefinition parse(Element elt, ParserContext parserContext) {
        RuntimeBeanReference contextSource = LdapUserServiceBeanDefinitionParser.parseServerReference(elt, parserContext);
        RootBeanDefinition searchBean = LdapUserServiceBeanDefinitionParser.parseSearchBean(elt, parserContext);
        String userDnPattern = elt.getAttribute(ATT_USER_DN_PATTERN);
        String[] userDnPatternArray = new String[]{};
        if (StringUtils.hasText((String)userDnPattern)) {
            userDnPatternArray = new String[]{userDnPattern};
        } else if (searchBean == null) {
            this.logger.info((Object)"No search information or DN pattern specified. Using default search filter 'uid={0}'");
            searchBean = new RootBeanDefinition(class$org$springframework$security$ldap$search$FilterBasedLdapUserSearch == null ? (class$org$springframework$security$ldap$search$FilterBasedLdapUserSearch = LdapProviderBeanDefinitionParser.class$("org.springframework.security.ldap.search.FilterBasedLdapUserSearch")) : class$org$springframework$security$ldap$search$FilterBasedLdapUserSearch);
            searchBean.setSource((Object)elt);
            searchBean.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)"");
            searchBean.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)DEF_USER_SEARCH_FILTER);
            searchBean.getConstructorArgumentValues().addIndexedArgumentValue(2, (Object)contextSource);
        }
        RootBeanDefinition authenticator = new RootBeanDefinition(class$org$springframework$security$providers$ldap$authenticator$BindAuthenticator == null ? (class$org$springframework$security$providers$ldap$authenticator$BindAuthenticator = LdapProviderBeanDefinitionParser.class$("org.springframework.security.providers.ldap.authenticator.BindAuthenticator")) : class$org$springframework$security$providers$ldap$authenticator$BindAuthenticator);
        Element passwordCompareElt = DomUtils.getChildElementByTagName((Element)elt, (String)"password-compare");
        if (passwordCompareElt != null) {
            authenticator = new RootBeanDefinition(class$org$springframework$security$providers$ldap$authenticator$PasswordComparisonAuthenticator == null ? (class$org$springframework$security$providers$ldap$authenticator$PasswordComparisonAuthenticator = LdapProviderBeanDefinitionParser.class$("org.springframework.security.providers.ldap.authenticator.PasswordComparisonAuthenticator")) : class$org$springframework$security$providers$ldap$authenticator$PasswordComparisonAuthenticator);
            String passwordAttribute = passwordCompareElt.getAttribute(ATT_USER_PASSWORD);
            if (StringUtils.hasText((String)passwordAttribute)) {
                authenticator.getPropertyValues().addPropertyValue("passwordAttributeName", (Object)passwordAttribute);
            }
            Element passwordEncoderElement = DomUtils.getChildElementByTagName((Element)passwordCompareElt, (String)"password-encoder");
            String hash = passwordCompareElt.getAttribute(ATT_HASH);
            if (passwordEncoderElement != null) {
                if (StringUtils.hasText((String)hash)) {
                    parserContext.getReaderContext().warning("Attribute 'hash' cannot be used with 'password-encoder' and will be ignored.", parserContext.extractSource((Object)elt));
                }
                PasswordEncoderParser pep = new PasswordEncoderParser(passwordEncoderElement, parserContext);
                authenticator.getPropertyValues().addPropertyValue("passwordEncoder", (Object)pep.getPasswordEncoder());
                if (pep.getSaltSource() != null) {
                    parserContext.getReaderContext().warning("Salt source information isn't valid when used with LDAP", (Object)passwordEncoderElement);
                }
            } else if (StringUtils.hasText((String)hash)) {
                Class encoderClass = (Class)PasswordEncoderParser.ENCODER_CLASSES.get(hash);
                authenticator.getPropertyValues().addPropertyValue("passwordEncoder", (Object)new RootBeanDefinition(encoderClass));
            }
        }
        authenticator.getConstructorArgumentValues().addGenericArgumentValue((Object)contextSource);
        authenticator.getPropertyValues().addPropertyValue("userDnPatterns", (Object)userDnPatternArray);
        if (searchBean != null) {
            authenticator.getPropertyValues().addPropertyValue("userSearch", (Object)searchBean);
        }
        RootBeanDefinition ldapProvider = new RootBeanDefinition(class$org$springframework$security$providers$ldap$LdapAuthenticationProvider == null ? (class$org$springframework$security$providers$ldap$LdapAuthenticationProvider = LdapProviderBeanDefinitionParser.class$("org.springframework.security.providers.ldap.LdapAuthenticationProvider")) : class$org$springframework$security$providers$ldap$LdapAuthenticationProvider);
        ldapProvider.getConstructorArgumentValues().addGenericArgumentValue((Object)authenticator);
        ldapProvider.getConstructorArgumentValues().addGenericArgumentValue((Object)LdapUserServiceBeanDefinitionParser.parseAuthoritiesPopulator(elt, parserContext));
        ldapProvider.getPropertyValues().addPropertyValue("userDetailsContextMapper", (Object)LdapUserServiceBeanDefinitionParser.parseUserDetailsClass(elt, parserContext));
        ConfigUtils.getRegisteredProviders(parserContext).add(ldapProvider);
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

