/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class LdapServerBeanDefinitionParser
implements BeanDefinitionParser {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String ATT_URL = "url";
    private static final String ATT_PRINCIPAL = "manager-dn";
    private static final String ATT_PASSWORD = "manager-password";
    public static final String ATT_ROOT_SUFFIX = "root";
    private static final String OPT_DEFAULT_ROOT_SUFFIX = "dc=springframework,dc=org";
    public static final String ATT_LDIF_FILE = "ldif";
    private static final String OPT_DEFAULT_LDIF_FILE = "classpath*:*.ldif";
    public static final String ATT_PORT = "port";
    public static final String OPT_DEFAULT_PORT = "33389";
    static /* synthetic */ Class class$org$springframework$security$ldap$DefaultSpringSecurityContextSource;

    public BeanDefinition parse(Element elt, ParserContext parserContext) {
        String id;
        RootBeanDefinition contextSource;
        String url = elt.getAttribute(ATT_URL);
        if (!StringUtils.hasText((String)url)) {
            contextSource = this.createEmbeddedServer(elt, parserContext);
        } else {
            contextSource = new RootBeanDefinition(class$org$springframework$security$ldap$DefaultSpringSecurityContextSource == null ? (class$org$springframework$security$ldap$DefaultSpringSecurityContextSource = LdapServerBeanDefinitionParser.class$("org.springframework.security.ldap.DefaultSpringSecurityContextSource")) : class$org$springframework$security$ldap$DefaultSpringSecurityContextSource);
            contextSource.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)url);
        }
        contextSource.setSource(parserContext.extractSource((Object)elt));
        String managerDn = elt.getAttribute(ATT_PRINCIPAL);
        String managerPassword = elt.getAttribute(ATT_PASSWORD);
        if (StringUtils.hasText((String)managerDn)) {
            if (!StringUtils.hasText((String)managerPassword)) {
                parserContext.getReaderContext().error("You must specify the manager-password if you supply a " + managerDn, (Object)elt);
            }
            contextSource.getPropertyValues().addPropertyValue("userDn", (Object)managerDn);
            contextSource.getPropertyValues().addPropertyValue("password", (Object)managerPassword);
        }
        String contextSourceId = StringUtils.hasText((String)(id = elt.getAttribute("id"))) ? id : "_securityContextSource";
        parserContext.getRegistry().registerBeanDefinition(contextSourceId, (BeanDefinition)contextSource);
        return null;
    }

    private RootBeanDefinition createEmbeddedServer(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        BeanDefinitionBuilder configuration = BeanDefinitionBuilder.rootBeanDefinition((String)"org.apache.directory.server.configuration.MutableServerStartupConfiguration");
        BeanDefinitionBuilder partition = BeanDefinitionBuilder.rootBeanDefinition((String)"org.apache.directory.server.core.partition.impl.btree.MutableBTreePartitionConfiguration");
        configuration.setSource(source);
        partition.setSource(source);
        DirContextAdapter rootContext = new DirContextAdapter();
        rootContext.setAttributeValues("objectClass", (Object[])new String[]{"top", "domain", "extensibleObject"});
        rootContext.setAttributeValue("dc", (Object)"springsecurity");
        partition.addPropertyValue("name", (Object)"springsecurity");
        partition.addPropertyValue("contextEntry", (Object)rootContext.getAttributes());
        String suffix = element.getAttribute(ATT_ROOT_SUFFIX);
        if (!StringUtils.hasText((String)suffix)) {
            suffix = OPT_DEFAULT_ROOT_SUFFIX;
        }
        partition.addPropertyValue("suffix", (Object)suffix);
        ManagedSet partitions = new ManagedSet(1);
        partitions.add((Object)partition.getBeanDefinition());
        String port = element.getAttribute(ATT_PORT);
        if (!StringUtils.hasText((String)port)) {
            port = OPT_DEFAULT_PORT;
        }
        configuration.addPropertyValue("ldapPort", (Object)port);
        configuration.addPropertyValue("shutdownHookEnabled", (Object)Boolean.FALSE);
        configuration.addPropertyValue("exitVmOnShutdown", (Object)Boolean.FALSE);
        configuration.addPropertyValue("contextPartitionConfigurations", (Object)partitions);
        String url = "ldap://127.0.0.1:" + port + "/" + suffix;
        RootBeanDefinition contextSource = new RootBeanDefinition(class$org$springframework$security$ldap$DefaultSpringSecurityContextSource == null ? (class$org$springframework$security$ldap$DefaultSpringSecurityContextSource = LdapServerBeanDefinitionParser.class$("org.springframework.security.ldap.DefaultSpringSecurityContextSource")) : class$org$springframework$security$ldap$DefaultSpringSecurityContextSource);
        contextSource.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)url);
        contextSource.getPropertyValues().addPropertyValue("userDn", (Object)"uid=admin,ou=system");
        contextSource.getPropertyValues().addPropertyValue("password", (Object)"secret");
        RootBeanDefinition apacheContainer = new RootBeanDefinition("org.springframework.security.config.ApacheDSContainer", null, null);
        apacheContainer.setSource(source);
        apacheContainer.getConstructorArgumentValues().addGenericArgumentValue((Object)configuration.getBeanDefinition());
        apacheContainer.getConstructorArgumentValues().addGenericArgumentValue((Object)contextSource);
        String ldifs = element.getAttribute(ATT_LDIF_FILE);
        if (!StringUtils.hasText((String)ldifs)) {
            ldifs = OPT_DEFAULT_LDIF_FILE;
        }
        apacheContainer.getConstructorArgumentValues().addGenericArgumentValue((Object)ldifs);
        this.logger.info((Object)("Embedded LDAP server bean created for URL: " + url));
        if (parserContext.getRegistry().containsBeanDefinition("_apacheDirectoryServerContainer")) {
            parserContext.getReaderContext().error("Only one embedded server bean is allowed per application context", (Object)element);
        }
        parserContext.getRegistry().registerBeanDefinition("_apacheDirectoryServerContainer", (BeanDefinition)apacheContainer);
        return contextSource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

