/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.AbstractUserDetailsServiceBeanDefinitionParser;
import org.springframework.security.config.LdapConfigUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class LdapUserServiceBeanDefinitionParser
extends AbstractUserDetailsServiceBeanDefinitionParser {
    public static final String ATT_SERVER = "server-ref";
    public static final String ATT_USER_SEARCH_FILTER = "user-search-filter";
    public static final String ATT_USER_SEARCH_BASE = "user-search-base";
    public static final String DEF_USER_SEARCH_BASE = "";
    public static final String ATT_GROUP_SEARCH_FILTER = "group-search-filter";
    public static final String ATT_GROUP_SEARCH_BASE = "group-search-base";
    public static final String ATT_GROUP_ROLE_ATTRIBUTE = "group-role-attribute";
    public static final String DEF_GROUP_SEARCH_FILTER = "(uniqueMember={0})";
    public static final String DEF_GROUP_SEARCH_BASE = "ou=groups";
    static final String ATT_ROLE_PREFIX = "role-prefix";
    static final String ATT_USER_CLASS = "user-details-class";
    static final String OPT_PERSON = "person";
    static final String OPT_INETORGPERSON = "inetOrgPerson";
    static /* synthetic */ Class class$org$springframework$security$userdetails$ldap$LdapUserDetailsService;
    static /* synthetic */ Class class$org$springframework$security$ldap$search$FilterBasedLdapUserSearch;
    static /* synthetic */ Class class$org$springframework$security$userdetails$ldap$PersonContextMapper;
    static /* synthetic */ Class class$org$springframework$security$userdetails$ldap$InetOrgPersonContextMapper;
    static /* synthetic */ Class class$org$springframework$security$userdetails$ldap$LdapUserDetailsMapper;
    static /* synthetic */ Class class$org$springframework$security$ldap$populator$DefaultLdapAuthoritiesPopulator;

    protected Class getBeanClass(Element element) {
        return class$org$springframework$security$userdetails$ldap$LdapUserDetailsService == null ? (class$org$springframework$security$userdetails$ldap$LdapUserDetailsService = LdapUserServiceBeanDefinitionParser.class$("org.springframework.security.userdetails.ldap.LdapUserDetailsService")) : class$org$springframework$security$userdetails$ldap$LdapUserDetailsService;
    }

    protected void doParse(Element elt, ParserContext parserContext, BeanDefinitionBuilder builder) {
        if (!StringUtils.hasText((String)elt.getAttribute(ATT_USER_SEARCH_FILTER))) {
            parserContext.getReaderContext().error("User search filter must be supplied", (Object)elt);
        }
        builder.addConstructorArg((Object)LdapUserServiceBeanDefinitionParser.parseSearchBean(elt, parserContext));
        builder.addConstructorArg((Object)LdapUserServiceBeanDefinitionParser.parseAuthoritiesPopulator(elt, parserContext));
        builder.addPropertyValue("userDetailsMapper", (Object)LdapUserServiceBeanDefinitionParser.parseUserDetailsClass(elt, parserContext));
    }

    static RootBeanDefinition parseSearchBean(Element elt, ParserContext parserContext) {
        String userSearchFilter = elt.getAttribute(ATT_USER_SEARCH_FILTER);
        String userSearchBase = elt.getAttribute(ATT_USER_SEARCH_BASE);
        Object source = parserContext.extractSource((Object)elt);
        if (StringUtils.hasText((String)userSearchBase)) {
            if (!StringUtils.hasText((String)userSearchFilter)) {
                parserContext.getReaderContext().error("user-search-base cannot be used without a user-search-filter", source);
            }
        } else {
            userSearchBase = DEF_USER_SEARCH_BASE;
        }
        if (!StringUtils.hasText((String)userSearchFilter)) {
            return null;
        }
        BeanDefinitionBuilder searchBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$security$ldap$search$FilterBasedLdapUserSearch == null ? (class$org$springframework$security$ldap$search$FilterBasedLdapUserSearch = LdapUserServiceBeanDefinitionParser.class$("org.springframework.security.ldap.search.FilterBasedLdapUserSearch")) : class$org$springframework$security$ldap$search$FilterBasedLdapUserSearch));
        searchBuilder.setSource(source);
        searchBuilder.addConstructorArg((Object)userSearchBase);
        searchBuilder.addConstructorArg((Object)userSearchFilter);
        searchBuilder.addConstructorArg((Object)LdapUserServiceBeanDefinitionParser.parseServerReference(elt, parserContext));
        return (RootBeanDefinition)searchBuilder.getBeanDefinition();
    }

    static RuntimeBeanReference parseServerReference(Element elt, ParserContext parserContext) {
        String server = elt.getAttribute(ATT_SERVER);
        boolean requiresDefaultName = false;
        if (!StringUtils.hasText((String)server)) {
            server = "_securityContextSource";
            requiresDefaultName = true;
        }
        RuntimeBeanReference contextSource = new RuntimeBeanReference(server);
        contextSource.setSource(parserContext.extractSource((Object)elt));
        LdapConfigUtils.registerPostProcessorIfNecessary(parserContext.getRegistry(), requiresDefaultName);
        return contextSource;
    }

    static RootBeanDefinition parseUserDetailsClass(Element elt, ParserContext parserContext) {
        String userDetailsClass = elt.getAttribute(ATT_USER_CLASS);
        if (OPT_PERSON.equals(userDetailsClass)) {
            return new RootBeanDefinition(class$org$springframework$security$userdetails$ldap$PersonContextMapper == null ? (class$org$springframework$security$userdetails$ldap$PersonContextMapper = LdapUserServiceBeanDefinitionParser.class$("org.springframework.security.userdetails.ldap.PersonContextMapper")) : class$org$springframework$security$userdetails$ldap$PersonContextMapper);
        }
        if (OPT_INETORGPERSON.equals(userDetailsClass)) {
            return new RootBeanDefinition(class$org$springframework$security$userdetails$ldap$InetOrgPersonContextMapper == null ? (class$org$springframework$security$userdetails$ldap$InetOrgPersonContextMapper = LdapUserServiceBeanDefinitionParser.class$("org.springframework.security.userdetails.ldap.InetOrgPersonContextMapper")) : class$org$springframework$security$userdetails$ldap$InetOrgPersonContextMapper);
        }
        return new RootBeanDefinition(class$org$springframework$security$userdetails$ldap$LdapUserDetailsMapper == null ? (class$org$springframework$security$userdetails$ldap$LdapUserDetailsMapper = LdapUserServiceBeanDefinitionParser.class$("org.springframework.security.userdetails.ldap.LdapUserDetailsMapper")) : class$org$springframework$security$userdetails$ldap$LdapUserDetailsMapper);
    }

    static RootBeanDefinition parseAuthoritiesPopulator(Element elt, ParserContext parserContext) {
        String groupSearchFilter = elt.getAttribute(ATT_GROUP_SEARCH_FILTER);
        String groupSearchBase = elt.getAttribute(ATT_GROUP_SEARCH_BASE);
        String groupRoleAttribute = elt.getAttribute(ATT_GROUP_ROLE_ATTRIBUTE);
        String rolePrefix = elt.getAttribute(ATT_ROLE_PREFIX);
        if (!StringUtils.hasText((String)groupSearchFilter)) {
            groupSearchFilter = DEF_GROUP_SEARCH_FILTER;
        }
        if (!StringUtils.hasText((String)groupSearchBase)) {
            groupSearchBase = DEF_GROUP_SEARCH_BASE;
        }
        BeanDefinitionBuilder populator = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$security$ldap$populator$DefaultLdapAuthoritiesPopulator == null ? (class$org$springframework$security$ldap$populator$DefaultLdapAuthoritiesPopulator = LdapUserServiceBeanDefinitionParser.class$("org.springframework.security.ldap.populator.DefaultLdapAuthoritiesPopulator")) : class$org$springframework$security$ldap$populator$DefaultLdapAuthoritiesPopulator));
        populator.setSource(parserContext.extractSource((Object)elt));
        populator.addConstructorArg((Object)LdapUserServiceBeanDefinitionParser.parseServerReference(elt, parserContext));
        populator.addConstructorArg((Object)groupSearchBase);
        populator.addPropertyValue("groupSearchFilter", (Object)groupSearchFilter);
        if (StringUtils.hasText((String)rolePrefix)) {
            if ("none".equals(rolePrefix)) {
                rolePrefix = DEF_USER_SEARCH_BASE;
            }
            populator.addPropertyValue("rolePrefix", (Object)rolePrefix);
        }
        if (StringUtils.hasLength((String)groupRoleAttribute)) {
            populator.addPropertyValue("groupRoleAttribute", (Object)groupRoleAttribute);
        }
        return (RootBeanDefinition)populator.getBeanDefinition();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

