/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.SaltSourceBeanDefinitionParser;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class PasswordEncoderParser {
    static final String ATT_REF = "ref";
    static final String ATT_HASH = "hash";
    static final String ATT_BASE_64 = "base64";
    static final String OPT_HASH_PLAINTEXT = "plaintext";
    static final String OPT_HASH_SHA = "sha";
    static final String OPT_HASH_MD4 = "md4";
    static final String OPT_HASH_MD5 = "md5";
    static final String OPT_HASH_LDAP_SHA = "{sha}";
    static final Map ENCODER_CLASSES = new HashMap();
    private Log logger = LogFactory.getLog(this.getClass());
    private BeanMetadataElement passwordEncoder;
    private BeanDefinition saltSource;
    static /* synthetic */ Class class$org$springframework$security$providers$encoding$PlaintextPasswordEncoder;
    static /* synthetic */ Class class$org$springframework$security$providers$encoding$ShaPasswordEncoder;
    static /* synthetic */ Class class$org$springframework$security$providers$encoding$Md4PasswordEncoder;
    static /* synthetic */ Class class$org$springframework$security$providers$encoding$Md5PasswordEncoder;
    static /* synthetic */ Class class$org$springframework$security$providers$ldap$authenticator$LdapShaPasswordEncoder;
    static /* synthetic */ Class class$org$springframework$security$providers$encoding$BaseDigestPasswordEncoder;

    public PasswordEncoderParser(Element element, ParserContext parserContext) {
        this.parse(element, parserContext);
    }

    private void parse(Element element, ParserContext parserContext) {
        String ref;
        String hash = element.getAttribute(ATT_HASH);
        boolean useBase64 = false;
        if (StringUtils.hasText((String)element.getAttribute(ATT_BASE_64))) {
            useBase64 = new Boolean(element.getAttribute(ATT_BASE_64));
        }
        if (StringUtils.hasText((String)(ref = element.getAttribute(ATT_REF)))) {
            this.passwordEncoder = new RuntimeBeanReference(ref);
        } else {
            Class beanClass = (Class)ENCODER_CLASSES.get(hash);
            RootBeanDefinition beanDefinition = new RootBeanDefinition(beanClass);
            beanDefinition.setSource(parserContext.extractSource((Object)element));
            if (useBase64) {
                if ((class$org$springframework$security$providers$encoding$BaseDigestPasswordEncoder == null ? (class$org$springframework$security$providers$encoding$BaseDigestPasswordEncoder = PasswordEncoderParser.class$("org.springframework.security.providers.encoding.BaseDigestPasswordEncoder")) : class$org$springframework$security$providers$encoding$BaseDigestPasswordEncoder).isAssignableFrom(beanClass)) {
                    beanDefinition.getPropertyValues().addPropertyValue("encodeHashAsBase64", (Object)"true");
                } else {
                    this.logger.warn((Object)("base64 isn't compatible with " + hash + " and will be ignored"));
                }
            }
            this.passwordEncoder = beanDefinition;
        }
        Element saltSourceElt = DomUtils.getChildElementByTagName((Element)element, (String)"salt-source");
        if (saltSourceElt != null) {
            this.saltSource = new SaltSourceBeanDefinitionParser().parse(saltSourceElt, parserContext);
        }
    }

    public BeanMetadataElement getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public BeanDefinition getSaltSource() {
        return this.saltSource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ENCODER_CLASSES.put(OPT_HASH_PLAINTEXT, class$org$springframework$security$providers$encoding$PlaintextPasswordEncoder == null ? (class$org$springframework$security$providers$encoding$PlaintextPasswordEncoder = PasswordEncoderParser.class$("org.springframework.security.providers.encoding.PlaintextPasswordEncoder")) : class$org$springframework$security$providers$encoding$PlaintextPasswordEncoder);
        ENCODER_CLASSES.put(OPT_HASH_SHA, class$org$springframework$security$providers$encoding$ShaPasswordEncoder == null ? (class$org$springframework$security$providers$encoding$ShaPasswordEncoder = PasswordEncoderParser.class$("org.springframework.security.providers.encoding.ShaPasswordEncoder")) : class$org$springframework$security$providers$encoding$ShaPasswordEncoder);
        ENCODER_CLASSES.put(OPT_HASH_MD4, class$org$springframework$security$providers$encoding$Md4PasswordEncoder == null ? (class$org$springframework$security$providers$encoding$Md4PasswordEncoder = PasswordEncoderParser.class$("org.springframework.security.providers.encoding.Md4PasswordEncoder")) : class$org$springframework$security$providers$encoding$Md4PasswordEncoder);
        ENCODER_CLASSES.put(OPT_HASH_MD5, class$org$springframework$security$providers$encoding$Md5PasswordEncoder == null ? (class$org$springframework$security$providers$encoding$Md5PasswordEncoder = PasswordEncoderParser.class$("org.springframework.security.providers.encoding.Md5PasswordEncoder")) : class$org$springframework$security$providers$encoding$Md5PasswordEncoder);
        ENCODER_CLASSES.put(OPT_HASH_LDAP_SHA, class$org$springframework$security$providers$ldap$authenticator$LdapShaPasswordEncoder == null ? (class$org$springframework$security$providers$ldap$authenticator$LdapShaPasswordEncoder = PasswordEncoderParser.class$("org.springframework.security.providers.ldap.authenticator.LdapShaPasswordEncoder")) : class$org$springframework$security$providers$ldap$authenticator$LdapShaPasswordEncoder);
    }
}

