/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.preauth;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Ordered;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.security.providers.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsChecker;
import org.springframework.security.userdetails.checker.AccountStatusUserDetailsChecker;
import org.springframework.util.Assert;

public class PreAuthenticatedAuthenticationProvider
implements AuthenticationProvider,
InitializingBean,
Ordered {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$providers$preauth$PreAuthenticatedAuthenticationProvider == null ? (class$org$springframework$security$providers$preauth$PreAuthenticatedAuthenticationProvider = PreAuthenticatedAuthenticationProvider.class$("org.springframework.security.providers.preauth.PreAuthenticatedAuthenticationProvider")) : class$org$springframework$security$providers$preauth$PreAuthenticatedAuthenticationProvider));
    private AuthenticationUserDetailsService preAuthenticatedUserDetailsService = null;
    private UserDetailsChecker userDetailsChecker = new AccountStatusUserDetailsChecker();
    private boolean throwExceptionWhenTokenRejected = false;
    private int order = -1;
    static /* synthetic */ Class class$org$springframework$security$providers$preauth$PreAuthenticatedAuthenticationProvider;
    static /* synthetic */ Class class$org$springframework$security$providers$preauth$PreAuthenticatedAuthenticationToken;

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.preAuthenticatedUserDetailsService, (String)"An AuthenticationUserDetailsService must be set");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PreAuthenticated authentication request: " + authentication));
        }
        if (authentication.getPrincipal() == null) {
            logger.debug((Object)"No pre-authenticated principal found in request.");
            if (this.throwExceptionWhenTokenRejected) {
                throw new BadCredentialsException("No pre-authenticated principal found in request.");
            }
            return null;
        }
        if (authentication.getCredentials() == null) {
            logger.debug((Object)"No pre-authenticated credentials found in request.");
            if (this.throwExceptionWhenTokenRejected) {
                throw new BadCredentialsException("No pre-authenticated credentials found in request.");
            }
            return null;
        }
        UserDetails ud = this.preAuthenticatedUserDetailsService.loadUserDetails(authentication);
        this.userDetailsChecker.check(ud);
        PreAuthenticatedAuthenticationToken result = new PreAuthenticatedAuthenticationToken(ud, authentication.getCredentials(), ud.getAuthorities());
        result.setDetails(authentication.getDetails());
        return result;
    }

    public boolean supports(Class authentication) {
        return (class$org$springframework$security$providers$preauth$PreAuthenticatedAuthenticationToken == null ? (class$org$springframework$security$providers$preauth$PreAuthenticatedAuthenticationToken = PreAuthenticatedAuthenticationProvider.class$("org.springframework.security.providers.preauth.PreAuthenticatedAuthenticationToken")) : class$org$springframework$security$providers$preauth$PreAuthenticatedAuthenticationToken).isAssignableFrom(authentication);
    }

    public void setPreAuthenticatedUserDetailsService(AuthenticationUserDetailsService aPreAuthenticatedUserDetailsService) {
        this.preAuthenticatedUserDetailsService = aPreAuthenticatedUserDetailsService;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int i) {
        this.order = i;
    }

    public void setThrowExceptionWhenTokenRejected(boolean throwExceptionWhenTokenRejected) {
        this.throwExceptionWhenTokenRejected = throwExceptionWhenTokenRejected;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

