/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationTrustResolver;
import org.springframework.security.AuthenticationTrustResolverImpl;
import org.springframework.security.concurrent.SessionRegistry;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.ui.FilterChainOrder;
import org.springframework.security.ui.SpringSecurityFilter;
import org.springframework.security.util.SessionUtils;

public class SessionFixationProtectionFilter
extends SpringSecurityFilter {
    static final String FILTER_APPLIED = "__spring_security_session_fixation_filter_applied";
    private SessionRegistry sessionRegistry;
    private boolean migrateSessionAttributes = true;
    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getSession(false) == null || request.getAttribute(FILTER_APPLIED) != null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        request.setAttribute(FILTER_APPLIED, (Object)Boolean.TRUE);
        if (this.isAuthenticated()) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        SessionFixationProtectionResponseWrapper wrapper = new SessionFixationProtectionResponseWrapper(response, request);
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
        }
        finally {
            if (!wrapper.isNewSessionStarted()) {
                this.startNewSessionIfRequired(request, response);
            }
        }
    }

    private boolean isAuthenticated() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && !this.authenticationTrustResolver.isAnonymous(authentication);
    }

    public void setMigrateSessionAttributes(boolean migrateSessionAttributes) {
        this.migrateSessionAttributes = migrateSessionAttributes;
    }

    public void setSessionRegistry(SessionRegistry sessionRegistry) {
        this.sessionRegistry = sessionRegistry;
    }

    public int getOrder() {
        return FilterChainOrder.SESSION_FIXATION_FILTER;
    }

    protected void startNewSessionIfRequired(HttpServletRequest request, HttpServletResponse response) {
        if (this.isAuthenticated()) {
            if (request.getSession(false) != null && response.isCommitted()) {
                this.logger.warn((Object)"Response is already committed. Unable to create new session.");
            }
            SessionUtils.startNewSessionIfRequired(request, this.migrateSessionAttributes, this.sessionRegistry);
        }
    }

    class SessionFixationProtectionResponseWrapper
    extends HttpServletResponseWrapper {
        private HttpServletRequest request;
        private boolean newSessionStarted;

        SessionFixationProtectionResponseWrapper(HttpServletResponse response, HttpServletRequest request) {
            super(response);
            this.request = request;
        }

        public void sendError(int sc) throws IOException {
            this.startNewSession();
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.startNewSession();
            super.sendError(sc, msg);
        }

        public void sendRedirect(String location) throws IOException {
            this.startNewSession();
            super.sendRedirect(location);
        }

        public void flushBuffer() throws IOException {
            this.startNewSession();
            super.flushBuffer();
        }

        private void startNewSession() {
            if (this.newSessionStarted) {
                return;
            }
            SessionFixationProtectionFilter.this.startNewSessionIfRequired(this.request, (HttpServletResponse)this);
            this.newSessionStarted = true;
        }

        boolean isNewSessionStarted() {
            return this.newSessionStarted;
        }
    }
}

