/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.rememberme;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.AccountStatusException;
import org.springframework.security.Authentication;
import org.springframework.security.SpringSecurityMessageSource;
import org.springframework.security.providers.rememberme.RememberMeAuthenticationToken;
import org.springframework.security.ui.AuthenticationDetailsSource;
import org.springframework.security.ui.WebAuthenticationDetailsSource;
import org.springframework.security.ui.logout.LogoutHandler;
import org.springframework.security.ui.rememberme.CookieTheftException;
import org.springframework.security.ui.rememberme.InvalidCookieException;
import org.springframework.security.ui.rememberme.RememberMeAuthenticationException;
import org.springframework.security.ui.rememberme.RememberMeServices;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsChecker;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.security.userdetails.checker.AccountStatusUserDetailsChecker;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractRememberMeServices
implements RememberMeServices,
InitializingBean,
LogoutHandler {
    public static final String SPRING_SECURITY_REMEMBER_ME_COOKIE_KEY = "SPRING_SECURITY_REMEMBER_ME_COOKIE";
    public static final String DEFAULT_PARAMETER = "_spring_security_remember_me";
    private static final String DELIMITER = ":";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private UserDetailsService userDetailsService;
    private UserDetailsChecker userDetailsChecker = new AccountStatusUserDetailsChecker();
    private AuthenticationDetailsSource authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private String cookieName = "SPRING_SECURITY_REMEMBER_ME_COOKIE";
    private String parameter = "_spring_security_remember_me";
    private boolean alwaysRemember;
    private String key;
    private int tokenValiditySeconds = 1209600;

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.key);
        Assert.hasLength((String)this.parameter);
        Assert.hasLength((String)this.cookieName);
        Assert.notNull((Object)this.userDetailsService);
    }

    public final Authentication autoLogin(HttpServletRequest request, HttpServletResponse response) {
        String rememberMeCookie = this.extractRememberMeCookie(request);
        if (rememberMeCookie == null) {
            return null;
        }
        this.logger.debug((Object)"Remember-me cookie detected");
        UserDetails user = null;
        try {
            String[] cookieTokens = this.decodeCookie(rememberMeCookie);
            user = this.processAutoLoginCookie(cookieTokens, request, response);
            this.userDetailsChecker.check(user);
        }
        catch (CookieTheftException cte) {
            this.cancelCookie(request, response);
            throw cte;
        }
        catch (UsernameNotFoundException noUser) {
            this.cancelCookie(request, response);
            this.logger.debug((Object)"Remember-me login was valid but corresponding user not found.", (Throwable)((Object)noUser));
            return null;
        }
        catch (InvalidCookieException invalidCookie) {
            this.cancelCookie(request, response);
            this.logger.debug((Object)("Invalid remember-me cookie: " + invalidCookie.getMessage()));
            return null;
        }
        catch (AccountStatusException statusInvalid) {
            this.cancelCookie(request, response);
            this.logger.debug((Object)("Invalid UserDetails: " + statusInvalid.getMessage()));
            return null;
        }
        catch (RememberMeAuthenticationException e) {
            this.cancelCookie(request, response);
            this.logger.debug((Object)e.getMessage());
            return null;
        }
        this.logger.debug((Object)"Remember-me cookie accepted");
        RememberMeAuthenticationToken auth = new RememberMeAuthenticationToken(this.key, user, user.getAuthorities());
        auth.setDetails(this.authenticationDetailsSource.buildDetails(request));
        return auth;
    }

    private String extractRememberMeCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!this.cookieName.equals(cookies[i].getName())) continue;
            return cookies[i].getValue();
        }
        return null;
    }

    protected String[] decodeCookie(String cookieValue) throws InvalidCookieException {
        for (int j = 0; j < cookieValue.length() % 4; ++j) {
            cookieValue = cookieValue + "=";
        }
        if (!Base64.isArrayByteBase64((byte[])cookieValue.getBytes())) {
            throw new InvalidCookieException("Cookie token was not Base64 encoded; value was '" + cookieValue + "'");
        }
        String cookieAsPlainText = new String(Base64.decodeBase64((byte[])cookieValue.getBytes()));
        return StringUtils.delimitedListToStringArray((String)cookieAsPlainText, (String)DELIMITER);
    }

    protected String encodeCookie(String[] cookieTokens) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cookieTokens.length; ++i) {
            sb.append(cookieTokens[i]);
            if (i >= cookieTokens.length - 1) continue;
            sb.append(DELIMITER);
        }
        String value = sb.toString();
        sb = new StringBuffer(new String(Base64.encodeBase64((byte[])value.getBytes())));
        while (sb.charAt(sb.length() - 1) == '=') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public final void loginFail(HttpServletRequest request, HttpServletResponse response) {
        this.logger.debug((Object)"Interactive login attempt was unsuccessful.");
        this.cancelCookie(request, response);
        this.onLoginFail(request, response);
    }

    protected void onLoginFail(HttpServletRequest request, HttpServletResponse response) {
    }

    public final void loginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        if (!this.rememberMeRequested(request, this.parameter)) {
            this.logger.debug((Object)"Remember-me login not requested.");
            return;
        }
        this.onLoginSuccess(request, response, successfulAuthentication);
    }

    protected abstract void onLoginSuccess(HttpServletRequest var1, HttpServletResponse var2, Authentication var3);

    protected boolean rememberMeRequested(HttpServletRequest request, String parameter) {
        if (this.alwaysRemember) {
            return true;
        }
        String paramValue = request.getParameter(parameter);
        if (paramValue != null && (paramValue.equalsIgnoreCase("true") || paramValue.equalsIgnoreCase("on") || paramValue.equalsIgnoreCase("yes") || paramValue.equals("1"))) {
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Did not send remember-me cookie (principal did not set parameter '" + parameter + "')"));
        }
        return false;
    }

    protected abstract UserDetails processAutoLoginCookie(String[] var1, HttpServletRequest var2, HttpServletResponse var3) throws RememberMeAuthenticationException, UsernameNotFoundException;

    protected void cancelCookie(HttpServletRequest request, HttpServletResponse response) {
        this.logger.debug((Object)"Cancelling cookie");
        Cookie cookie = new Cookie(this.cookieName, null);
        cookie.setMaxAge(0);
        cookie.setPath(StringUtils.hasLength((String)request.getContextPath()) ? request.getContextPath() : "/");
        response.addCookie(cookie);
    }

    protected void setCookie(String[] tokens, int maxAge, HttpServletRequest request, HttpServletResponse response) {
        String cookieValue = this.encodeCookie(tokens);
        Cookie cookie = new Cookie(this.cookieName, cookieValue);
        cookie.setMaxAge(maxAge);
        cookie.setPath(StringUtils.hasLength((String)request.getContextPath()) ? request.getContextPath() : "/");
        response.addCookie(cookie);
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Logout of user " + (authentication == null ? "Unknown" : authentication.getName())));
        }
        this.cancelCookie(request, response);
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public void setAlwaysRemember(boolean alwaysRemember) {
        this.alwaysRemember = alwaysRemember;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public String getParameter() {
        return this.parameter;
    }

    protected UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setTokenValiditySeconds(int tokenValiditySeconds) {
        this.tokenValiditySeconds = tokenValiditySeconds;
    }

    protected int getTokenValiditySeconds() {
        return this.tokenValiditySeconds;
    }

    protected AuthenticationDetailsSource getAuthenticationDetailsSource() {
        return this.authenticationDetailsSource;
    }
}

