/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.hierarchicalroles;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.hierarchicalroles.CycleInRoleHierarchyException;
import org.springframework.security.userdetails.hierarchicalroles.RoleHierarchy;

public class RoleHierarchyImpl
implements RoleHierarchy {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$userdetails$hierarchicalroles$RoleHierarchyImpl == null ? (class$org$springframework$security$userdetails$hierarchicalroles$RoleHierarchyImpl = RoleHierarchyImpl.class$("org.springframework.security.userdetails.hierarchicalroles.RoleHierarchyImpl")) : class$org$springframework$security$userdetails$hierarchicalroles$RoleHierarchyImpl));
    private String roleHierarchyStringRepresentation = null;
    private Map rolesReachableInOneStepMap = null;
    private Map rolesReachableInOneOrMoreStepsMap = null;
    static /* synthetic */ Class class$org$springframework$security$userdetails$hierarchicalroles$RoleHierarchyImpl;

    public void setHierarchy(String roleHierarchyStringRepresentation) {
        this.roleHierarchyStringRepresentation = roleHierarchyStringRepresentation;
        logger.debug((Object)("setHierarchy() - The following role hierarchy was set: " + roleHierarchyStringRepresentation));
        this.buildRolesReachableInOneStepMap();
        this.buildRolesReachableInOneOrMoreStepsMap();
    }

    public GrantedAuthority[] getReachableGrantedAuthorities(GrantedAuthority[] authorities) {
        if (authorities == null || authorities.length == 0) {
            return null;
        }
        HashSet<GrantedAuthority> reachableRoles = new HashSet<GrantedAuthority>();
        for (int i = 0; i < authorities.length; ++i) {
            reachableRoles.add(authorities[i]);
            Set additionalReachableRoles = (Set)this.rolesReachableInOneOrMoreStepsMap.get(authorities[i]);
            if (additionalReachableRoles == null) continue;
            reachableRoles.addAll(additionalReachableRoles);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getReachableGrantedAuthorities() - From the roles " + Arrays.asList(authorities) + " one can reach " + reachableRoles + " in zero or more steps."));
        }
        return reachableRoles.toArray(new GrantedAuthority[reachableRoles.size()]);
    }

    private void buildRolesReachableInOneStepMap() {
        String parsingRegex = "(\\s*(\\w+)\\s*\\>\\s*(\\w+))";
        Pattern pattern = Pattern.compile(parsingRegex);
        Matcher roleHierarchyMatcher = pattern.matcher(this.roleHierarchyStringRepresentation);
        this.rolesReachableInOneStepMap = new HashMap();
        while (roleHierarchyMatcher.find()) {
            GrantedAuthorityImpl higherRole = new GrantedAuthorityImpl(roleHierarchyMatcher.group(2));
            GrantedAuthorityImpl lowerRole = new GrantedAuthorityImpl(roleHierarchyMatcher.group(3));
            Set<GrantedAuthorityImpl> rolesReachableInOneStepSet = null;
            if (!this.rolesReachableInOneStepMap.containsKey(higherRole)) {
                rolesReachableInOneStepSet = new HashSet();
                this.rolesReachableInOneStepMap.put(higherRole, rolesReachableInOneStepSet);
            } else {
                rolesReachableInOneStepSet = (Set)this.rolesReachableInOneStepMap.get(higherRole);
            }
            rolesReachableInOneStepSet.add(lowerRole);
            logger.debug((Object)("buildRolesReachableInOneStepMap() - From role " + higherRole + " one can reach role " + lowerRole + " in one step."));
        }
    }

    private void buildRolesReachableInOneOrMoreStepsMap() {
        this.rolesReachableInOneOrMoreStepsMap = new HashMap();
        Iterator roleIterator = this.rolesReachableInOneStepMap.keySet().iterator();
        while (roleIterator.hasNext()) {
            GrantedAuthority role = (GrantedAuthority)roleIterator.next();
            HashSet rolesToVisitSet = new HashSet();
            if (this.rolesReachableInOneStepMap.containsKey(role)) {
                rolesToVisitSet.addAll((Set)this.rolesReachableInOneStepMap.get(role));
            }
            HashSet<GrantedAuthority> visitedRolesSet = new HashSet<GrantedAuthority>();
            while (!rolesToVisitSet.isEmpty()) {
                GrantedAuthority aRole = (GrantedAuthority)rolesToVisitSet.iterator().next();
                rolesToVisitSet.remove(aRole);
                visitedRolesSet.add(aRole);
                if (!this.rolesReachableInOneStepMap.containsKey(aRole)) continue;
                Set newReachableRoles = (Set)this.rolesReachableInOneStepMap.get(aRole);
                if (rolesToVisitSet.contains(role) || visitedRolesSet.contains(role)) {
                    throw new CycleInRoleHierarchyException();
                }
                rolesToVisitSet.addAll(newReachableRoles);
            }
            this.rolesReachableInOneOrMoreStepsMap.put(role, visitedRolesSet);
            logger.debug((Object)("buildRolesReachableInOneOrMoreStepsMap() - From role " + role + " one can reach " + visitedRolesSet + " in one or more steps."));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

