/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.object.MappingSqlQuery;
import org.springframework.jdbc.object.SqlQuery;
import org.springframework.jdbc.object.SqlUpdate;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.dao.UserCache;
import org.springframework.security.providers.dao.cache.NullUserCache;
import org.springframework.security.userdetails.GroupManager;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsManager;
import org.springframework.security.userdetails.jdbc.JdbcDaoImpl;
import org.springframework.security.util.AuthorityUtils;
import org.springframework.util.Assert;

public class JdbcUserDetailsManager
extends JdbcDaoImpl
implements UserDetailsManager,
GroupManager {
    public static final String DEF_CREATE_USER_SQL = "insert into users (username, password, enabled) values (?,?,?)";
    public static final String DEF_DELETE_USER_SQL = "delete from users where username = ?";
    public static final String DEF_UPDATE_USER_SQL = "update users set password = ?, enabled = ? where username = ?";
    public static final String DEF_INSERT_AUTHORITY_SQL = "insert into authorities (username, authority) values (?,?)";
    public static final String DEF_DELETE_USER_AUTHORITIES_SQL = "delete from authorities where username = ?";
    public static final String DEF_USER_EXISTS_SQL = "select username from users where username = ?";
    public static final String DEF_CHANGE_PASSWORD_SQL = "update users set password = ? where username = ?";
    public static final String DEF_FIND_GROUPS_SQL = "select group_name from groups";
    public static final String DEF_FIND_USERS_IN_GROUP_SQL = "select username from group_members gm, groups g where gm.group_id = g.id and g.group_name = ?";
    public static final String DEF_INSERT_GROUP_SQL = "insert into groups (group_name) values (?)";
    public static final String DEF_FIND_GROUP_ID_SQL = "select id from groups where group_name = ?";
    public static final String DEF_INSERT_GROUP_AUTHORITY_SQL = "insert into group_authorities (group_id, authority) values (?,?)";
    public static final String DEF_DELETE_GROUP_SQL = "delete from groups where id = ?";
    public static final String DEF_DELETE_GROUP_AUTHORITIES_SQL = "delete from group_authorities where group_id = ?";
    public static final String DEF_DELETE_GROUP_MEMBERS_SQL = "delete from group_members where group_id = ?";
    public static final String DEF_RENAME_GROUP_SQL = "update groups set group_name = ? where group_name = ?";
    public static final String DEF_INSERT_GROUP_MEMBER_SQL = "insert into group_members (group_id, username) values (?,?)";
    public static final String DEF_DELETE_GROUP_MEMBER_SQL = "delete from group_members where group_id = ? and username = ?";
    public static final String DEF_GROUP_AUTHORITIES_QUERY_SQL = "select g.id, g.group_name, ga.authority from groups g, group_authorities ga where g.group_name = ? and g.id = ga.group_id ";
    public static final String DEF_DELETE_GROUP_AUTHORITY_SQL = "delete from group_authorities where group_id = ? and authority = ?";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String createUserSql = "insert into users (username, password, enabled) values (?,?,?)";
    private String deleteUserSql = "delete from users where username = ?";
    private String updateUserSql = "update users set password = ?, enabled = ? where username = ?";
    private String createAuthoritySql = "insert into authorities (username, authority) values (?,?)";
    private String deleteUserAuthoritiesSql = "delete from authorities where username = ?";
    private String userExistsSql = "select username from users where username = ?";
    private String changePasswordSql = "update users set password = ? where username = ?";
    private String findAllGroupsSql = "select group_name from groups";
    private String findUsersInGroupSql = "select username from group_members gm, groups g where gm.group_id = g.id and g.group_name = ?";
    private String insertGroupSql = "insert into groups (group_name) values (?)";
    private String findGroupIdSql = "select id from groups where group_name = ?";
    private String insertGroupAuthoritySql = "insert into group_authorities (group_id, authority) values (?,?)";
    private String deleteGroupSql = "delete from groups where id = ?";
    private String deleteGroupAuthoritiesSql = "delete from group_authorities where group_id = ?";
    private String deleteGroupMembersSql = "delete from group_members where group_id = ?";
    private String renameGroupSql = "update groups set group_name = ? where group_name = ?";
    private String insertGroupMemberSql = "insert into group_members (group_id, username) values (?,?)";
    private String deleteGroupMemberSql = "delete from group_members where group_id = ? and username = ?";
    private String groupAuthoritiesSql = "select g.id, g.group_name, ga.authority from groups g, group_authorities ga where g.group_name = ? and g.id = ga.group_id ";
    private String deleteGroupAuthoritySql = "delete from group_authorities where group_id = ? and authority = ?";
    private SqlUpdate insertUser;
    private SqlUpdate deleteUser;
    private SqlUpdate updateUser;
    private SqlUpdate insertAuthority;
    private SqlUpdate deleteUserAuthorities;
    private SqlQuery userExistsQuery;
    private SqlUpdate changePassword;
    private SqlQuery findAllGroupsQuery;
    private SqlQuery findUsersInGroupQuery;
    private SqlUpdate insertGroup;
    private SqlQuery findGroupIdQuery;
    private SqlUpdate insertGroupAuthority;
    private SqlUpdate deleteGroup;
    private SqlUpdate deleteGroupMembers;
    private SqlUpdate deleteGroupAuthorities;
    private SqlUpdate renameGroup;
    private SqlUpdate insertGroupMember;
    private SqlUpdate deleteGroupMember;
    private SqlQuery groupAuthoritiesQuery;
    private SqlUpdate deleteGroupAuthority;
    private AuthenticationManager authenticationManager;
    private UserCache userCache = new NullUserCache();

    protected void initDao() throws ApplicationContextException {
        if (this.authenticationManager == null) {
            this.logger.info((Object)"No authentication manager set. Reauthentication of users when changing passwords will not be performed.");
        }
        this.insertUser = new InsertUser(this.getDataSource());
        this.deleteUser = new DeleteUser(this.getDataSource());
        this.updateUser = new UpdateUser(this.getDataSource());
        this.insertAuthority = new InsertAuthority(this.getDataSource());
        this.deleteUserAuthorities = new DeleteUserAuthorities(this.getDataSource());
        this.userExistsQuery = new UserExistsQuery(this.getDataSource());
        this.changePassword = new ChangePassword(this.getDataSource());
        this.findAllGroupsQuery = new AllGroupsQuery(this.getDataSource());
        this.findUsersInGroupQuery = new GroupMembersQuery(this.getDataSource());
        this.insertGroup = new InsertGroup(this.getDataSource());
        this.findGroupIdQuery = new FindGroupIdQuery(this.getDataSource());
        this.insertGroupAuthority = new InsertGroupAuthority(this.getDataSource());
        this.deleteGroup = new DeleteGroup(this.getDataSource());
        this.deleteGroupAuthorities = new DeleteGroupAuthorities(this.getDataSource());
        this.deleteGroupMembers = new DeleteGroupMembers(this.getDataSource());
        this.renameGroup = new RenameGroup(this.getDataSource());
        this.insertGroupMember = new InsertGroupMember(this.getDataSource());
        this.deleteGroupMember = new DeleteGroupMember(this.getDataSource());
        this.groupAuthoritiesQuery = new GroupAuthoritiesByGroupNameMapping(this.getDataSource());
        this.deleteGroupAuthority = new DeleteGroupAuthority(this.getDataSource());
        super.initDao();
    }

    public void createUser(UserDetails user) {
        this.validateUserDetails(user);
        this.insertUser.update(new Object[]{user.getUsername(), user.getPassword(), user.isEnabled()});
        this.insertUserAuthorities(user);
    }

    public void updateUser(UserDetails user) {
        this.validateUserDetails(user);
        this.updateUser.update(new Object[]{user.getPassword(), user.isEnabled(), user.getUsername()});
        this.deleteUserAuthorities.update(user.getUsername());
        this.insertUserAuthorities(user);
        this.userCache.removeUserFromCache(user.getUsername());
    }

    private void insertUserAuthorities(UserDetails user) {
        for (int i = 0; i < user.getAuthorities().length; ++i) {
            this.insertAuthority.update(user.getUsername(), user.getAuthorities()[i].getAuthority());
        }
    }

    public void deleteUser(String username) {
        this.deleteUserAuthorities.update(username);
        this.deleteUser.update(username);
        this.userCache.removeUserFromCache(username);
    }

    public void changePassword(String oldPassword, String newPassword) throws AuthenticationException {
        Authentication currentUser = SecurityContextHolder.getContext().getAuthentication();
        if (currentUser == null) {
            throw new AccessDeniedException("Can't change password as no Authentication object found in context for current user.");
        }
        String username = currentUser.getName();
        if (this.authenticationManager != null) {
            this.logger.debug((Object)("Reauthenticating user '" + username + "' for password change request."));
            this.authenticationManager.authenticate(new UsernamePasswordAuthenticationToken(username, oldPassword));
        } else {
            this.logger.debug((Object)"No authentication manager set. Password won't be re-checked.");
        }
        this.logger.debug((Object)("Changing password for user '" + username + "'"));
        this.changePassword.update((Object[])new String[]{newPassword, username});
        SecurityContextHolder.getContext().setAuthentication(this.createNewAuthentication(currentUser, newPassword));
        this.userCache.removeUserFromCache(username);
    }

    protected Authentication createNewAuthentication(Authentication currentAuth, String newPassword) {
        UserDetails user = this.loadUserByUsername(currentAuth.getName());
        UsernamePasswordAuthenticationToken newAuthentication = new UsernamePasswordAuthenticationToken(user, user.getPassword(), user.getAuthorities());
        newAuthentication.setDetails(currentAuth.getDetails());
        return newAuthentication;
    }

    public boolean userExists(String username) {
        List users = this.userExistsQuery.execute(username);
        if (users.size() > 1) {
            throw new IllegalStateException("More than one user found with name '" + username + "'");
        }
        return users.size() == 1;
    }

    public String[] findAllGroups() {
        return this.findAllGroupsQuery.execute().toArray(new String[0]);
    }

    public String[] findUsersInGroup(String groupName) {
        Assert.hasText((String)groupName);
        return this.findUsersInGroupQuery.execute(groupName).toArray(new String[0]);
    }

    public void createGroup(String groupName, GrantedAuthority[] authorities) {
        Assert.hasText((String)groupName);
        Assert.notNull((Object)authorities);
        this.logger.debug((Object)("Creating new group '" + groupName + "' with authorities " + AuthorityUtils.authorityArrayToSet(authorities)));
        this.insertGroup.update(groupName);
        Integer id = (Integer)this.findGroupIdQuery.findObject(groupName);
        for (int i = 0; i < authorities.length; ++i) {
            this.insertGroupAuthority.update(new Object[]{id, authorities[i].getAuthority()});
        }
    }

    public void deleteGroup(String groupName) {
        this.logger.debug((Object)("Deleting group '" + groupName + "'"));
        Assert.hasText((String)groupName);
        int id = (Integer)this.findGroupIdQuery.findObject(groupName);
        this.deleteGroupMembers.update(id);
        this.deleteGroupAuthorities.update(id);
        this.deleteGroup.update(id);
    }

    public void renameGroup(String oldName, String newName) {
        this.logger.debug((Object)("Changing group name from '" + oldName + "' to '" + newName + "'"));
        Assert.hasText((String)oldName);
        Assert.hasText((String)newName);
        this.renameGroup.update(newName, oldName);
    }

    public void addUserToGroup(String username, String groupName) {
        this.logger.debug((Object)("Adding user '" + username + "' to group '" + groupName + "'"));
        Assert.hasText((String)username);
        Assert.hasText((String)groupName);
        Integer id = (Integer)this.findGroupIdQuery.findObject(groupName);
        this.insertGroupMember.update(new Object[]{id, username});
        this.userCache.removeUserFromCache(username);
    }

    public void removeUserFromGroup(String username, String groupName) {
        this.logger.debug((Object)("Removing user '" + username + "' to group '" + groupName + "'"));
        Assert.hasText((String)username);
        Assert.hasText((String)groupName);
        Integer id = (Integer)this.findGroupIdQuery.findObject(groupName);
        this.deleteGroupMember.update(new Object[]{id, username});
        this.userCache.removeUserFromCache(username);
    }

    public GrantedAuthority[] findGroupAuthorities(String groupName) {
        this.logger.debug((Object)("Loading authorities for group '" + groupName + "'"));
        Assert.hasText((String)groupName);
        return this.groupAuthoritiesQuery.execute(groupName).toArray(new GrantedAuthority[0]);
    }

    public void removeGroupAuthority(String groupName, GrantedAuthority authority) {
        this.logger.debug((Object)("Removing authority '" + authority + "' from group '" + groupName + "'"));
        Assert.hasText((String)groupName);
        Assert.notNull((Object)authority);
        Integer id = (Integer)this.findGroupIdQuery.findObject(groupName);
        this.deleteGroupAuthority.update(new Object[]{id, authority});
    }

    public void addGroupAuthority(String groupName, GrantedAuthority authority) {
        this.logger.debug((Object)("Adding authority '" + authority + "' to group '" + groupName + "'"));
        Assert.hasText((String)groupName);
        Assert.notNull((Object)authority);
        Integer id = (Integer)this.findGroupIdQuery.findObject(groupName);
        this.insertGroupAuthority.update(new Object[]{id, authority.getAuthority()});
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setCreateUserSql(String createUserSql) {
        Assert.hasText((String)createUserSql);
        this.createUserSql = createUserSql;
    }

    public void setDeleteUserSql(String deleteUserSql) {
        Assert.hasText((String)deleteUserSql);
        this.deleteUserSql = deleteUserSql;
    }

    public void setUpdateUserSql(String updateUserSql) {
        Assert.hasText((String)updateUserSql);
        this.updateUserSql = updateUserSql;
    }

    public void setCreateAuthoritySql(String createAuthoritySql) {
        Assert.hasText((String)createAuthoritySql);
        this.createAuthoritySql = createAuthoritySql;
    }

    public void setDeleteUserAuthoritiesSql(String deleteUserAuthoritiesSql) {
        Assert.hasText((String)deleteUserAuthoritiesSql);
        this.deleteUserAuthoritiesSql = deleteUserAuthoritiesSql;
    }

    public void setUserExistsSql(String userExistsSql) {
        Assert.hasText((String)userExistsSql);
        this.userExistsSql = userExistsSql;
    }

    public void setChangePasswordSql(String changePasswordSql) {
        Assert.hasText((String)changePasswordSql);
        this.changePasswordSql = changePasswordSql;
    }

    public void setFindAllGroupsSql(String findAllGroupsSql) {
        this.findAllGroupsSql = findAllGroupsSql;
    }

    public void setUserCache(UserCache userCache) {
        Assert.notNull((Object)userCache, (String)"userCache cannot be null");
        this.userCache = userCache;
    }

    private void validateUserDetails(UserDetails user) {
        Assert.hasText((String)user.getUsername(), (String)"Username may not be empty or null");
        this.validateAuthorities(user.getAuthorities());
    }

    private void validateAuthorities(GrantedAuthority[] authorities) {
        Assert.notNull((Object)authorities, (String)"Authorities list must not be null");
        for (int i = 0; i < authorities.length; ++i) {
            Assert.notNull((Object)authorities[i], (String)"Authorities list contains a null entry");
            Assert.hasText((String)authorities[i].getAuthority(), (String)"getAuthority() method must return a non-empty string");
        }
    }

    private class DeleteGroupAuthority
    extends SqlUpdate {
        public DeleteGroupAuthority(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.deleteGroupAuthoritySql);
            this.declareParameter(new SqlParameter(4));
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }
    }

    private class GroupAuthoritiesByGroupNameMapping
    extends MappingSqlQuery {
        protected GroupAuthoritiesByGroupNameMapping(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.groupAuthoritiesSql);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            String roleName = JdbcUserDetailsManager.this.getRolePrefix() + rs.getString(3);
            GrantedAuthorityImpl authority = new GrantedAuthorityImpl(roleName);
            return authority;
        }
    }

    private class DeleteGroupMember
    extends SqlUpdate {
        public DeleteGroupMember(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.deleteGroupMemberSql);
            this.declareParameter(new SqlParameter(4));
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }
    }

    protected class InsertGroupMember
    extends SqlUpdate {
        public InsertGroupMember(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.insertGroupMemberSql);
            this.declareParameter(new SqlParameter(4));
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }
    }

    private class RenameGroup
    extends SqlUpdate {
        public RenameGroup(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.renameGroupSql);
            this.declareParameter(new SqlParameter(12));
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }
    }

    protected class DeleteGroupAuthorities
    extends SqlUpdate {
        public DeleteGroupAuthorities(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.deleteGroupAuthoritiesSql);
            this.declareParameter(new SqlParameter(4));
            this.compile();
        }
    }

    private class DeleteGroupMembers
    extends SqlUpdate {
        public DeleteGroupMembers(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.deleteGroupMembersSql);
            this.declareParameter(new SqlParameter(4));
            this.compile();
        }
    }

    protected class DeleteGroup
    extends SqlUpdate {
        public DeleteGroup(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.deleteGroupSql);
            this.declareParameter(new SqlParameter(4));
            this.compile();
        }
    }

    private class InsertGroupAuthority
    extends SqlUpdate {
        public InsertGroupAuthority(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.insertGroupAuthoritySql);
            this.declareParameter(new SqlParameter(4));
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }
    }

    private class FindGroupIdQuery
    extends MappingSqlQuery {
        public FindGroupIdQuery(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.findGroupIdSql);
            this.declareParameter(new SqlParameter(4));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            return new Integer(rs.getInt(1));
        }
    }

    private class InsertGroup
    extends SqlUpdate {
        public InsertGroup(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.insertGroupSql);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }
    }

    private class GroupMembersQuery
    extends MappingSqlQuery {
        public GroupMembersQuery(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.findUsersInGroupSql);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            return rs.getString(1);
        }
    }

    private class AllGroupsQuery
    extends MappingSqlQuery {
        public AllGroupsQuery(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.findAllGroupsSql);
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            return rs.getString(1);
        }
    }

    private class UserExistsQuery
    extends MappingSqlQuery {
        public UserExistsQuery(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.userExistsSql);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            return rs.getString(1);
        }
    }

    private class ChangePassword
    extends SqlUpdate {
        public ChangePassword(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.changePasswordSql);
            this.declareParameter(new SqlParameter(12));
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }
    }

    private class UpdateUser
    extends SqlUpdate {
        public UpdateUser(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.updateUserSql);
            this.declareParameter(new SqlParameter(12));
            this.declareParameter(new SqlParameter(16));
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }
    }

    private class DeleteUserAuthorities
    extends SqlUpdate {
        public DeleteUserAuthorities(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.deleteUserAuthoritiesSql);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }
    }

    private class InsertAuthority
    extends SqlUpdate {
        public InsertAuthority(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.createAuthoritySql);
            this.declareParameter(new SqlParameter(12));
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }
    }

    private class DeleteUser
    extends SqlUpdate {
        public DeleteUser(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.deleteUserSql);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }
    }

    private class InsertUser
    extends SqlUpdate {
        public InsertUser(DataSource ds) {
            super(ds, JdbcUserDetailsManager.this.createUserSql);
            this.declareParameter(new SqlParameter(12));
            this.declareParameter(new SqlParameter(12));
            this.declareParameter(new SqlParameter(16));
            this.compile();
        }
    }
}

