/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.DataCachePCData;
import org.apache.openjpa.datacache.DataCachePCDataImpl;
import org.apache.openjpa.datacache.QueryCache;
import org.apache.openjpa.datacache.QueryCacheStoreQuery;
import org.apache.openjpa.datacache.TypesChangedEvent;
import org.apache.openjpa.enhance.PCDataGenerator;
import org.apache.openjpa.kernel.DelegatingStoreManager;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.QueryLanguages;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.OptimisticException;

public class DataCacheStoreManager
extends DelegatingStoreManager {
    private Collection _inserts = null;
    private Map _updates = null;
    private Collection _deletes = null;
    private StoreContext _ctx = null;
    private PCDataGenerator _gen = null;

    public DataCacheStoreManager(StoreManager sm) {
        super(sm);
    }

    public void setContext(StoreContext ctx) {
        this._ctx = ctx;
        this._gen = ctx.getConfiguration().getDataCacheManagerInstance().getPCDataGenerator();
        super.setContext(ctx);
    }

    public void begin() {
        super.begin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        try {
            super.commit();
            this.updateCaches();
        }
        finally {
            this._inserts = null;
            this._updates = null;
            this._deletes = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        try {
            super.rollback();
        }
        finally {
            this._inserts = null;
            this._updates = null;
            this._deletes = null;
        }
    }

    private void evictTypes(Collection classes) {
        if (classes.isEmpty()) {
            return;
        }
        MetaDataRepository mdr = this._ctx.getConfiguration().getMetaDataRepositoryInstance();
        ClassLoader loader = this._ctx.getClassLoader();
        Iterator itr = classes.iterator();
        while (itr.hasNext()) {
            Class cls = (Class)itr.next();
            DataCache cache = mdr.getMetaData(cls, loader, false).getDataCache();
            if (cache == null) continue;
            cache.removeAll(cls, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCaches() {
        QueryCache queryCache;
        Iterator<Object> itr;
        Map.Entry entry;
        DataCachePCData data;
        Modifications mods;
        DataCache cache;
        OpenJPAStateManager sm;
        HashMap modMap = null;
        if (this._ctx.getPopulateDataCache() && this._inserts != null) {
            Iterator itr2 = this._inserts.iterator();
            while (itr2.hasNext()) {
                sm = (OpenJPAStateManager)itr2.next();
                cache = sm.getMetaData().getDataCache();
                if (cache == null) continue;
                if (modMap == null) {
                    modMap = new HashMap();
                }
                mods = DataCacheStoreManager.getModifications(modMap, cache);
                data = this.newPCData(sm);
                data.store(sm);
                mods.additions.add(new PCDataHolder(data, sm));
            }
        }
        if (this._updates != null) {
            Iterator itr3 = this._updates.entrySet().iterator();
            while (itr3.hasNext()) {
                entry = itr3.next();
                sm = (OpenJPAStateManager)entry.getKey();
                BitSet fields = (BitSet)entry.getValue();
                cache = sm.getMetaData().getDataCache();
                if (cache == null) continue;
                if (modMap == null) {
                    modMap = new HashMap();
                }
                data = cache.get(sm.getObjectId());
                mods = DataCacheStoreManager.getModifications(modMap, cache);
                if (data == null) {
                    data = this.newPCData(sm);
                    data.store(sm);
                    mods.newUpdates.add(new PCDataHolder(data, sm));
                    continue;
                }
                data.store(sm, fields);
                mods.existingUpdates.add(new PCDataHolder(data, sm));
            }
        }
        if (this._deletes != null) {
            itr = this._deletes.iterator();
            while (itr.hasNext()) {
                sm = (OpenJPAStateManager)itr.next();
                cache = sm.getMetaData().getDataCache();
                if (cache == null) continue;
                if (modMap == null) {
                    modMap = new HashMap();
                }
                mods = DataCacheStoreManager.getModifications(modMap, cache);
                mods.deletes.add(sm.getObjectId());
            }
        }
        if (modMap != null) {
            itr = modMap.entrySet().iterator();
            while (itr.hasNext()) {
                entry = (Map.Entry)itr.next();
                cache = (DataCache)entry.getKey();
                mods = (Modifications)entry.getValue();
                cache.writeLock();
                try {
                    this.transformToVersionSafePCDatas(cache, mods.additions);
                    this.transformToVersionSafePCDatas(cache, mods.newUpdates);
                    this.transformToVersionSafePCDatas(cache, mods.existingUpdates);
                    cache.commit(mods.additions, mods.newUpdates, mods.existingUpdates, mods.deletes);
                }
                finally {
                    cache.writeUnlock();
                }
            }
        }
        if (this._ctx.isLargeTransaction()) {
            this.evictTypes(this._ctx.getDeletedTypes());
            this.evictTypes(this._ctx.getUpdatedTypes());
        }
        if ((queryCache = this._ctx.getConfiguration().getDataCacheManagerInstance().getSystemQueryCache()) != null) {
            Collection pers = this._ctx.getPersistedTypes();
            Collection del = this._ctx.getDeletedTypes();
            Collection up = this._ctx.getUpdatedTypes();
            int size = pers.size() + del.size() + up.size();
            if (size > 0) {
                ArrayList types = new ArrayList(size);
                types.addAll(pers);
                types.addAll(del);
                types.addAll(up);
                queryCache.onTypesChanged(new TypesChangedEvent(this, types));
            }
        }
    }

    private void transformToVersionSafePCDatas(DataCache cache, List holders) {
        ListIterator<DataCachePCData> iter = holders.listIterator();
        while (iter.hasNext()) {
            PCDataHolder holder = (PCDataHolder)iter.next();
            DataCachePCData oldpc = cache.get(holder.sm.getObjectId());
            if (oldpc != null && this.compareVersion(holder.sm, holder.sm.getVersion(), oldpc.getVersion()) == 2) {
                iter.remove();
                continue;
            }
            iter.set(holder.pcdata);
        }
    }

    private static Modifications getModifications(Map modMap, DataCache cache) {
        Modifications mods = (Modifications)modMap.get(cache);
        if (mods == null) {
            mods = new Modifications();
            modMap.put(cache, mods);
        }
        return mods;
    }

    public boolean exists(OpenJPAStateManager sm, Object edata) {
        DataCache cache = sm.getMetaData().getDataCache();
        if (cache != null && !this.isLocking(null) && cache.contains(sm.getObjectId())) {
            return true;
        }
        return super.exists(sm, edata);
    }

    public boolean syncVersion(OpenJPAStateManager sm, Object edata) {
        DataCache cache = sm.getMetaData().getDataCache();
        if (cache == null || sm.isEmbedded()) {
            return super.syncVersion(sm, edata);
        }
        Object version = null;
        DataCachePCData data = cache.get(sm.getObjectId());
        if (!this.isLocking(null) && data != null) {
            version = data.getVersion();
        }
        if (version != null) {
            if (!version.equals(sm.getVersion())) {
                sm.setVersion(version);
                return false;
            }
            return true;
        }
        return super.syncVersion(sm, edata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initialize(OpenJPAStateManager sm, PCState state, FetchConfiguration fetch, Object edata) {
        DataCache cache = sm.getMetaData().getDataCache();
        if (cache == null || sm.isEmbedded()) {
            return super.initialize(sm, state, fetch, edata);
        }
        DataCachePCData data = cache.get(sm.getObjectId());
        if (data != null && !this.isLocking(fetch)) {
            sm.initialize(data.getType(), state);
            data.load(sm, fetch, edata);
            return true;
        }
        if (!super.initialize(sm, state, fetch, edata)) {
            return false;
        }
        if (!this._ctx.getPopulateDataCache()) {
            return true;
        }
        cache.writeLock();
        try {
            data = cache.get(sm.getObjectId());
            if (data != null && this.compareVersion(sm, sm.getVersion(), data.getVersion()) == 2) {
                boolean bl = true;
                return bl;
            }
            if (data == null) {
                data = this.newPCData(sm);
            }
            data.store(sm);
            cache.put(data);
        }
        finally {
            cache.writeUnlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(OpenJPAStateManager sm, BitSet fields, FetchConfiguration fetch, int lockLevel, Object edata) {
        DataCache cache = sm.getMetaData().getDataCache();
        if (cache == null || sm.isEmbedded()) {
            return super.load(sm, fields, fetch, lockLevel, edata);
        }
        DataCachePCData data = cache.get(sm.getObjectId());
        if (lockLevel == 0 && !this.isLocking(fetch) && data != null) {
            data.load(sm, fields, fetch, edata);
        }
        if (fields.length() == 0) {
            return true;
        }
        if (!super.load(sm, (BitSet)fields.clone(), fetch, lockLevel, edata)) {
            return false;
        }
        if (!this._ctx.getPopulateDataCache()) {
            return true;
        }
        cache.writeLock();
        try {
            boolean isNew;
            data = cache.get(sm.getObjectId());
            if (data != null && this.compareVersion(sm, sm.getVersion(), data.getVersion()) == 2) {
                boolean bl = true;
                return bl;
            }
            boolean bl = isNew = data == null;
            if (isNew) {
                data = this.newPCData(sm);
            }
            data.store(sm, fields);
            if (isNew) {
                cache.put(data);
            } else {
                cache.update(data);
            }
        }
        finally {
            cache.writeUnlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection loadAll(Collection sms, PCState state, int load, FetchConfiguration fetch, Object edata) {
        BitSet fields;
        DataCachePCData data;
        DataCache cache;
        OpenJPAStateManager sm;
        if (this.isLocking(fetch)) {
            return super.loadAll(sms, state, load, fetch, edata);
        }
        Map unloaded = null;
        Iterator itr = sms.iterator();
        while (itr.hasNext()) {
            sm = (OpenJPAStateManager)itr.next();
            cache = sm.getMetaData().getDataCache();
            if (cache == null || sm.isEmbedded()) {
                unloaded = DataCacheStoreManager.addUnloaded(sm, null, unloaded);
                continue;
            }
            if (sm.getManagedInstance() == null) {
                data = cache.get(sm.getObjectId());
                if (data != null) {
                    sm.initialize(data.getType(), state);
                    data.load(sm, fetch, edata);
                    continue;
                }
                unloaded = DataCacheStoreManager.addUnloaded(sm, null, unloaded);
                continue;
            }
            if (load != 0 || sm.getPCState() == PCState.HOLLOW) {
                data = cache.get(sm.getObjectId());
                if (data != null) {
                    fields = sm.getUnloaded(fetch);
                    data.load(sm, fields, fetch, edata);
                    if (fields.length() <= 0) continue;
                    unloaded = DataCacheStoreManager.addUnloaded(sm, fields, unloaded);
                    continue;
                }
                unloaded = DataCacheStoreManager.addUnloaded(sm, null, unloaded);
                continue;
            }
            if (cache.contains(sm.getObjectId())) continue;
            unloaded = DataCacheStoreManager.addUnloaded(sm, null, unloaded);
        }
        if (unloaded == null) {
            return Collections.EMPTY_LIST;
        }
        Collection failed = super.loadAll(unloaded.keySet(), state, load, fetch, edata);
        if (!this._ctx.getPopulateDataCache()) {
            return failed;
        }
        Iterator itr2 = unloaded.entrySet().iterator();
        while (itr2.hasNext()) {
            Map.Entry entry = itr2.next();
            sm = (OpenJPAStateManager)entry.getKey();
            fields = (BitSet)entry.getValue();
            cache = sm.getMetaData().getDataCache();
            if (cache == null || sm.isEmbedded() || failed != null && failed.contains(sm.getId())) continue;
            cache.writeLock();
            try {
                boolean isNew;
                data = cache.get(sm.getObjectId());
                if (data != null && this.compareVersion(sm, sm.getVersion(), data.getVersion()) == 2) continue;
                boolean bl = isNew = data == null;
                if (isNew) {
                    data = this.newPCData(sm);
                }
                if (fields == null) {
                    data.store(sm);
                } else {
                    data.store(sm, fields);
                }
                if (isNew) {
                    cache.put(data);
                    continue;
                }
                cache.update(data);
            }
            finally {
                cache.writeUnlock();
            }
        }
        return failed;
    }

    private static Map addUnloaded(OpenJPAStateManager sm, BitSet fields, Map unloaded) {
        if (unloaded == null) {
            unloaded = new HashMap<OpenJPAStateManager, BitSet>();
        }
        unloaded.put(sm, fields);
        return unloaded;
    }

    public Collection flush(Collection states) {
        Collection exceps = super.flush(states);
        if (!exceps.isEmpty()) {
            Iterator iter = exceps.iterator();
            while (iter.hasNext()) {
                Exception e = (Exception)iter.next();
                if (!(e instanceof OptimisticException)) continue;
                this.evictOptimisticLockFailure((OptimisticException)e);
            }
            return exceps;
        }
        if (this._ctx.isLargeTransaction()) {
            return exceps;
        }
        Iterator itr = states.iterator();
        while (itr.hasNext()) {
            OpenJPAStateManager sm = (OpenJPAStateManager)itr.next();
            if (sm.getPCState() == PCState.PNEW && !sm.isFlushed()) {
                if (this._inserts == null) {
                    this._inserts = new ArrayList();
                }
                this._inserts.add(sm);
                if (this._deletes == null) continue;
                this._deletes.remove(sm);
                continue;
            }
            if (this._inserts != null && (sm.getPCState() == PCState.PNEWDELETED || sm.getPCState() == PCState.PNEWFLUSHEDDELETED)) {
                this._inserts.remove(sm);
                continue;
            }
            if (sm.getPCState() == PCState.PDIRTY) {
                if (this._updates == null) {
                    this._updates = new HashMap();
                }
                this._updates.put(sm, sm.getDirty());
                continue;
            }
            if (sm.getPCState() != PCState.PDELETED) continue;
            if (this._deletes == null) {
                this._deletes = new HashSet();
            }
            this._deletes.add(sm);
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictOptimisticLockFailure(OptimisticException e) {
        Object o = e.getFailedObject();
        OpenJPAStateManager sm = this._ctx.getStateManager(o);
        if (sm == null) {
            return;
        }
        ClassMetaData meta = sm.getMetaData();
        DataCache cache = meta.getDataCache();
        if (cache == null) {
            return;
        }
        cache.writeLock();
        try {
            boolean remove;
            DataCachePCData data = cache.get(sm.getId());
            if (data == null) {
                return;
            }
            switch (this.compareVersion(sm, sm.getVersion(), data.getVersion())) {
                case 1: 
                case 3: {
                    remove = true;
                    break;
                }
                case 2: {
                    remove = false;
                    break;
                }
                case 4: {
                    remove = true;
                    break;
                }
                default: {
                    remove = true;
                }
            }
            if (remove) {
                cache.remove(sm.getId());
            }
        }
        finally {
            cache.writeUnlock();
        }
    }

    public StoreQuery newQuery(String language) {
        StoreQuery q = super.newQuery(language);
        if (q == null || QueryLanguages.parserForLanguage(language) == null) {
            return q;
        }
        QueryCache queryCache = this._ctx.getConfiguration().getDataCacheManagerInstance().getSystemQueryCache();
        if (queryCache == null) {
            return q;
        }
        return new QueryCacheStoreQuery(q, queryCache);
    }

    private DataCachePCData newPCData(OpenJPAStateManager sm) {
        ClassMetaData meta = sm.getMetaData();
        if (this._gen != null) {
            return (DataCachePCData)this._gen.generatePCData(sm.getObjectId(), meta);
        }
        return new DataCachePCDataImpl(sm.fetchObjectId(), meta);
    }

    private boolean isLocking(FetchConfiguration fetch) {
        if (fetch == null) {
            fetch = this._ctx.getFetchConfiguration();
        }
        return fetch.getReadLockLevel() > 0;
    }

    private static class PCDataHolder {
        public final DataCachePCData pcdata;
        public final OpenJPAStateManager sm;

        public PCDataHolder(DataCachePCData pcdata, OpenJPAStateManager sm) {
            this.pcdata = pcdata;
            this.sm = sm;
        }
    }

    private static class Modifications {
        public final List additions = new ArrayList();
        public final List newUpdates = new ArrayList();
        public final List existingUpdates = new ArrayList();
        public final List deletes = new ArrayList();

        private Modifications() {
        }
    }
}

